/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.I0Itec.zkclient.exception.ZkMarshallingError;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.helix.ZNRecord;
import org.apache.helix.util.GZipCompressionUtil;
import org.apache.helix.util.ZNRecordUtil;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZNRecordSerializer
implements ZkSerializer {
    private static Logger LOG = LoggerFactory.getLogger(ZNRecordSerializer.class);

    private static int getListFieldBound(ZNRecord record) {
        int max = Integer.MAX_VALUE;
        if (record.getSimpleFields().containsKey("listField.bound")) {
            String maxStr = record.getSimpleField("listField.bound");
            try {
                max = Integer.parseInt(maxStr);
            }
            catch (Exception e) {
                LOG.error("IllegalNumberFormat for list field bound: " + maxStr);
            }
        }
        return max;
    }

    public byte[] serialize(Object data) {
        byte[] serializedBytes;
        if (!(data instanceof ZNRecord)) {
            LOG.error("Input object must be of type ZNRecord but it is " + data + ". Will not write to zk");
            throw new ZkMarshallingError("Input object is not of type ZNRecord (was " + data + ")");
        }
        ZNRecord record = (ZNRecord)data;
        int max = ZNRecordSerializer.getListFieldBound(record);
        if (max < Integer.MAX_VALUE) {
            Map<String, List<String>> listMap = record.getListFields();
            for (String key : listMap.keySet()) {
                List<String> list = listMap.get(key);
                if (list.size() <= max) continue;
                listMap.put(key, list.subList(0, max));
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        SerializationConfig serializationConfig = mapper.getSerializationConfig();
        serializationConfig.set(SerializationConfig.Feature.INDENT_OUTPUT, true);
        serializationConfig.set(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        serializationConfig.set(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean isCompressed = false;
        try {
            mapper.writeValue((OutputStream)baos, data);
            serializedBytes = baos.toByteArray();
            if (ZNRecordUtil.shouldCompress(record, serializedBytes.length)) {
                serializedBytes = GZipCompressionUtil.compress(serializedBytes);
                isCompressed = true;
            }
        }
        catch (Exception e) {
            LOG.error("Exception during data serialization. ZNRecord ID: {} will not be written to zk.", (Object)record.getId(), (Object)e);
            throw new ZkMarshallingError((Throwable)e);
        }
        int writeSizeLimit = ZNRecordUtil.getSerializerWriteSizeLimit();
        if (serializedBytes.length > writeSizeLimit) {
            LOG.error("Data size: {} is greater than {} bytes, is compressed: {}, ZNRecord.id: {}. Data will not be written to Zookeeper.", new Object[]{serializedBytes.length, writeSizeLimit, isCompressed, record.getId()});
            throw new ZkMarshallingError("Data size: " + serializedBytes.length + " is greater than " + writeSizeLimit + " bytes, is compressed: " + isCompressed + ", ZNRecord.id: " + record.getId());
        }
        return serializedBytes;
    }

    public Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectMapper mapper = new ObjectMapper();
        DeserializationConfig deserializationConfig = mapper.getDeserializationConfig();
        deserializationConfig.set(DeserializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        deserializationConfig.set(DeserializationConfig.Feature.AUTO_DETECT_SETTERS, true);
        deserializationConfig.set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        try {
            if (GZipCompressionUtil.isCompressed(bytes)) {
                byte[] uncompressedBytes = GZipCompressionUtil.uncompress(bais);
                bais = new ByteArrayInputStream(uncompressedBytes);
            }
            return mapper.readValue((InputStream)bais, ZNRecord.class);
        }
        catch (Exception e) {
            LOG.error("Exception during deserialization of bytes: {}", (Object)new String(bytes), (Object)e);
            return null;
        }
    }
}

