/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import org.apache.helix.ZNRecord;
import org.apache.helix.model.PauseSignal;

public class MaintenanceSignal
extends PauseSignal {
    public MaintenanceSignal(String id) {
        super(id);
    }

    public MaintenanceSignal(ZNRecord record) {
        super(record);
    }

    public void setTriggeringEntity(TriggeringEntity triggeringEntity) {
        this._record.setSimpleField(MaintenanceSignalProperty.TRIGGERED_BY.name(), triggeringEntity.name());
    }

    public TriggeringEntity getTriggeringEntity() {
        try {
            return TriggeringEntity.valueOf(this._record.getSimpleField(MaintenanceSignalProperty.TRIGGERED_BY.name()));
        }
        catch (Exception e) {
            return TriggeringEntity.UNKNOWN;
        }
    }

    public void setAutoTriggerReason(AutoTriggerReason internalReason) {
        this._record.setSimpleField(MaintenanceSignalProperty.AUTO_TRIGGER_REASON.name(), internalReason.name());
    }

    public AutoTriggerReason getAutoTriggerReason() {
        try {
            return AutoTriggerReason.valueOf(this._record.getSimpleField(MaintenanceSignalProperty.AUTO_TRIGGER_REASON.name()));
        }
        catch (Exception e) {
            return AutoTriggerReason.NOT_APPLICABLE;
        }
    }

    public void setTimestamp(long timestamp) {
        this._record.setLongField(MaintenanceSignalProperty.TIMESTAMP.name(), timestamp);
    }

    public long getTimestamp() {
        return this._record.getLongField(MaintenanceSignalProperty.TIMESTAMP.name(), -1L);
    }

    public static enum AutoTriggerReason {
        MAX_OFFLINE_INSTANCES_EXCEEDED,
        MAX_PARTITION_PER_INSTANCE_EXCEEDED,
        NOT_APPLICABLE;

    }

    public static enum TriggeringEntity {
        CONTROLLER,
        USER,
        UNKNOWN;

    }

    public static enum MaintenanceSignalProperty {
        TRIGGERED_BY,
        TIMESTAMP,
        AUTO_TRIGGER_REASON;

    }
}

