/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.InstanceType;
import org.apache.helix.PropertyPathBuilder;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.manager.zk.client.HelixZkClient;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.tools.ClusterSetup;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerTasksResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerTasksResource.class);
    public static String CRITERIA = "Criteria";
    public static String MESSAGETEMPLATE = "MessageTemplate";
    public static String TASKQUEUENAME = "TaskQueueName";

    public SchedulerTasksResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation = null;
        try {
            presentation = this.getSchedulerTasksRepresentation();
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("", (Throwable)e);
        }
        return presentation;
    }

    StringRepresentation getSchedulerTasksRepresentation() throws JsonGenerationException, JsonMappingException, IOException {
        String clusterName = (String)this.getRequest().getAttributes().get("clusterName");
        String instanceName = (String)this.getRequest().getAttributes().get("instanceName");
        ZkClient zkClient = (ZkClient)this.getContext().getAttributes().get("zkClient");
        ClusterSetup setupTool = new ClusterSetup((HelixZkClient)zkClient);
        List instances = setupTool.getClusterManagementTool().getInstancesInCluster(clusterName);
        HelixDataAccessor accessor = ClusterRepresentationUtil.getClusterDataAccessor(zkClient, clusterName);
        LiveInstance liveInstance = (LiveInstance)accessor.getProperty(accessor.keyBuilder().liveInstance(instanceName));
        String sessionId = liveInstance.getEphemeralOwner();
        StringRepresentation representation = new StringRepresentation((CharSequence)"");
        return representation;
    }

    public Representation post(Representation entity) {
        try {
            String clusterName = (String)this.getRequest().getAttributes().get("clusterName");
            Form form = new Form(entity);
            ZkClient zkClient = (ZkClient)this.getContext().getAttributes().get("zkClient");
            String msgTemplateString = ClusterRepresentationUtil.getFormJsonParameterString(form, MESSAGETEMPLATE);
            if (msgTemplateString == null) {
                throw new HelixException("SchedulerTasksResource need to have MessageTemplate specified.");
            }
            Map<String, String> messageTemplate = ClusterRepresentationUtil.getFormJsonParameters(form, MESSAGETEMPLATE);
            String criteriaString = ClusterRepresentationUtil.getFormJsonParameterString(form, CRITERIA);
            if (criteriaString == null) {
                throw new HelixException("SchedulerTasksResource need to have Criteria specified.");
            }
            HelixDataAccessor accessor = ClusterRepresentationUtil.getClusterDataAccessor(zkClient, clusterName);
            LiveInstance leader = (LiveInstance)accessor.getProperty(accessor.keyBuilder().controllerLeader());
            if (leader == null) {
                throw new HelixException("There is no leader for the cluster " + clusterName);
            }
            Message schedulerMessage = new Message(Message.MessageType.SCHEDULER_MSG, UUID.randomUUID().toString());
            schedulerMessage.getRecord().getSimpleFields().put(CRITERIA, criteriaString);
            schedulerMessage.getRecord().getMapFields().put(MESSAGETEMPLATE, messageTemplate);
            schedulerMessage.setTgtSessionId(leader.getEphemeralOwner());
            schedulerMessage.setTgtName("CONTROLLER");
            schedulerMessage.setSrcInstanceType(InstanceType.CONTROLLER);
            String taskQueueName = ClusterRepresentationUtil.getFormJsonParameterString(form, TASKQUEUENAME);
            if (taskQueueName != null && taskQueueName.length() > 0) {
                schedulerMessage.getRecord().setSimpleField("SchedulerTaskQueue", taskQueueName);
            }
            accessor.setProperty(accessor.keyBuilder().controllerMessage(schedulerMessage.getMsgId()), (HelixProperty)schedulerMessage);
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("StatusUpdatePath", PropertyPathBuilder.controllerStatusUpdate((String)clusterName, (String)Message.MessageType.SCHEDULER_MSG.name(), (String)schedulerMessage.getMsgId()));
            resultMap.put("MessageType", Message.MessageType.SCHEDULER_MSG.name());
            resultMap.put("MsgId", schedulerMessage.getMsgId());
            String ipAddress = InetAddress.getLocalHost().getCanonicalHostName();
            String url = "http://" + ipAddress + ":" + this.getContext().getAttributes().get("port") + "/clusters/" + clusterName + "/Controller/statusUpdates/SCHEDULER_MSG/" + schedulerMessage.getMsgId();
            resultMap.put("statusUpdateUrl", url);
            this.getResponse().setEntity(ClusterRepresentationUtil.ObjectToJson(resultMap), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
            LOG.error("", (Throwable)e);
        }
        return null;
    }
}

