/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixManagerProperties {
    private static final Logger LOG = LoggerFactory.getLogger((String)HelixManagerProperties.class.getName());
    private final Properties _properties = new Properties();

    public HelixManagerProperties(String propertyFileName) {
        try {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertyFileName);
            this._properties.load(stream);
        }
        catch (Exception e) {
            String errMsg = "fail to open properties file: " + propertyFileName;
            throw new IllegalArgumentException(errMsg, e);
        }
        LOG.info("load helix-manager properties: " + this._properties);
    }

    public HelixManagerProperties() {
    }

    public Properties getProperties() {
        return this._properties;
    }

    public String getVersion() {
        return this.getProperty("clustermanager.version");
    }

    public String getProperty(String key) {
        String value = this._properties.getProperty(key);
        if (value == null) {
            LOG.warn("no property for key: " + key);
        }
        return value;
    }

    static boolean versionNoLessThan(String version1, String version2) {
        if (version1 == null || version2 == null) {
            LOG.warn("fail to compare versions. version1: " + version1 + ", version2: " + version2);
            return true;
        }
        String[] version1Splits = version1.split("(\\.|-)");
        String[] version2Splits = version2.split("(\\.|-)");
        if (version1Splits == null || version1Splits.length == 0 || version2Splits == null || version2Splits.length == 0) {
            LOG.warn("fail to compare versions. version1: " + version1 + ", version2: " + version2);
        }
        for (int i = 0; i < version1Splits.length && i < version2Splits.length; ++i) {
            try {
                int versionNum1 = Integer.parseInt(version1Splits[i]);
                int versionNum2 = Integer.parseInt(version2Splits[i]);
                if (versionNum1 >= versionNum2) continue;
                return false;
            }
            catch (Exception e) {
                break;
            }
        }
        return true;
    }

    public boolean isParticipantCompatible(String participantVersion) {
        return this.isFeatureSupported("participant", participantVersion);
    }

    public boolean isFeatureSupported(String featureName, String participantVersion) {
        String minSupportedVersion = this.getProperty("minimum_supported_version." + featureName);
        return HelixManagerProperties.versionNoLessThan(participantVersion, minSupportedVersion);
    }
}

