/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.examples;

import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.examples.BootstrapHandler;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.messaging.handling.MultiTypeMessageHandlerFactory;
import org.apache.helix.model.Message;
import org.apache.helix.participant.StateMachineEngine;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;

public class BootstrapProcess {
    static final String REQUEST_BOOTSTRAP_URL = "REQUEST_BOOTSTRAP_URL";
    public static final String zkServer = "zkSvr";
    public static final String cluster = "cluster";
    public static final String hostAddress = "host";
    public static final String hostPort = "port";
    public static final String relayCluster = "relayCluster";
    public static final String help = "help";
    public static final String configFile = "configFile";
    public static final String stateModel = "stateModelType";
    public static final String transDelay = "transDelay";
    private final String zkConnectString;
    private final String clusterName;
    private final String instanceName;
    private final String stateModelType;
    private HelixManager manager;
    private String _file = null;
    private StateModelFactory<StateModel> stateModelFactory;
    private final int delay;

    public BootstrapProcess(String zkConnectString, String clusterName, String instanceName, String stateModel, int delay) {
        this.zkConnectString = zkConnectString;
        this.clusterName = clusterName;
        this.instanceName = instanceName;
        this.stateModelType = stateModel;
        this.delay = delay;
    }

    public void start() throws Exception {
        this.manager = HelixManagerFactory.getZKHelixManager(this.clusterName, this.instanceName, InstanceType.PARTICIPANT, this.zkConnectString);
        this.stateModelFactory = new BootstrapHandler();
        StateMachineEngine stateMach = this.manager.getStateMachineEngine();
        stateMach.registerStateModelFactory("MasterSlave", this.stateModelFactory);
        this.manager.getMessagingService().registerMessageHandlerFactory(Message.MessageType.STATE_TRANSITION.name(), (MessageHandlerFactory)stateMach);
        this.manager.getMessagingService().registerMessageHandlerFactory(Message.MessageType.USER_DEFINE_MSG.name(), (MessageHandlerFactory)new CustomMessageHandlerFactory());
        this.manager.connect();
    }

    private static Options constructCommandLineOptions() {
        OptionBuilder.withLongOpt((String)help);
        OptionBuilder.withDescription((String)"Prints command-line options info");
        Option helpOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)zkServer);
        OptionBuilder.withDescription((String)"Provide zookeeper address");
        Option zkServerOption = OptionBuilder.create();
        zkServerOption.setArgs(1);
        zkServerOption.setRequired(true);
        zkServerOption.setArgName("ZookeeperServerAddress(Required)");
        OptionBuilder.withLongOpt((String)cluster);
        OptionBuilder.withDescription((String)"Provide cluster name");
        Option clusterOption = OptionBuilder.create();
        clusterOption.setArgs(1);
        clusterOption.setRequired(true);
        clusterOption.setArgName("Cluster name (Required)");
        OptionBuilder.withLongOpt((String)hostAddress);
        OptionBuilder.withDescription((String)"Provide host name");
        Option hostOption = OptionBuilder.create();
        hostOption.setArgs(1);
        hostOption.setRequired(true);
        hostOption.setArgName("Host name (Required)");
        OptionBuilder.withLongOpt((String)hostPort);
        OptionBuilder.withDescription((String)"Provide host port");
        Option portOption = OptionBuilder.create();
        portOption.setArgs(1);
        portOption.setRequired(true);
        portOption.setArgName("Host port (Required)");
        OptionBuilder.withLongOpt((String)stateModel);
        OptionBuilder.withDescription((String)"StateModel Type");
        Option stateModelOption = OptionBuilder.create();
        stateModelOption.setArgs(1);
        stateModelOption.setRequired(true);
        stateModelOption.setArgName("StateModel Type (Required)");
        OptionBuilder.withLongOpt((String)configFile);
        OptionBuilder.withDescription((String)"Provide file to read states/messages");
        Option fileOption = OptionBuilder.create();
        fileOption.setArgs(1);
        fileOption.setRequired(true);
        fileOption.setArgName("File to read states/messages (Optional)");
        OptionBuilder.withLongOpt((String)transDelay);
        OptionBuilder.withDescription((String)"Provide state trans delay");
        Option transDelayOption = OptionBuilder.create();
        transDelayOption.setArgs(1);
        transDelayOption.setRequired(false);
        transDelayOption.setArgName("Delay time in state transition, in MS");
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.addOption(zkServerOption);
        optionGroup.addOption(fileOption);
        Options options = new Options();
        options.addOption(helpOption);
        options.addOption(clusterOption);
        options.addOption(hostOption);
        options.addOption(portOption);
        options.addOption(stateModelOption);
        options.addOption(transDelayOption);
        options.addOptionGroup(optionGroup);
        return options;
    }

    public static void printUsage(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("java " + BootstrapProcess.class.getName(), cliOptions);
    }

    public static CommandLine processCommandLineArgs(String[] cliArgs) throws Exception {
        GnuParser cliParser = new GnuParser();
        Options cliOptions = BootstrapProcess.constructCommandLineOptions();
        try {
            return cliParser.parse(cliOptions, cliArgs);
        }
        catch (ParseException pe) {
            System.err.println("CommandLineClient: failed to parse command-line options: " + pe.toString());
            BootstrapProcess.printUsage(cliOptions);
            System.exit(1);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String zkConnectString = "localhost:2181";
        String clusterName = "storage-integration-cluster";
        String instanceName = "localhost_8905";
        String stateModelValue = "MasterSlave";
        int delay = 0;
        boolean skipZeroArgs = true;
        if (!skipZeroArgs || args.length > 0) {
            CommandLine cmd = BootstrapProcess.processCommandLineArgs(args);
            zkConnectString = cmd.getOptionValue(zkServer);
            clusterName = cmd.getOptionValue(cluster);
            String host = cmd.getOptionValue(hostAddress);
            String portString = cmd.getOptionValue(hostPort);
            int port = Integer.parseInt(portString);
            instanceName = host + "_" + port;
            stateModelValue = cmd.getOptionValue(stateModel);
            if (cmd.hasOption(transDelay)) {
                try {
                    delay = Integer.parseInt(cmd.getOptionValue(transDelay));
                    if (delay < 0) {
                        throw new Exception("delay must be positive");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    delay = 0;
                }
            }
        }
        System.out.println("Starting Process with ZK:" + zkConnectString);
        BootstrapProcess process = new BootstrapProcess(zkConnectString, clusterName, instanceName, stateModelValue, delay);
        process.start();
        Thread.currentThread().join();
    }

    public static class CustomMessageHandlerFactory
    implements MultiTypeMessageHandlerFactory {
        @Override
        public MessageHandler createHandler(Message message, NotificationContext context) {
            return new CustomMessageHandler(message, context);
        }

        @Override
        @Deprecated
        public String getMessageType() {
            return Message.MessageType.USER_DEFINE_MSG.name();
        }

        @Override
        public List<String> getMessageTypes() {
            return ImmutableList.of((Object)Message.MessageType.USER_DEFINE_MSG.name());
        }

        @Override
        public void reset() {
        }

        static class CustomMessageHandler
        extends MessageHandler {
            public CustomMessageHandler(Message message, NotificationContext context) {
                super(message, context);
            }

            @Override
            public HelixTaskResult handleMessage() throws InterruptedException {
                String hostName;
                HelixTaskResult result = new HelixTaskResult();
                try {
                    hostName = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    hostName = "UNKNOWN";
                }
                String port = "2134";
                String msgSubType = this._message.getMsgSubType();
                if (msgSubType.equals(BootstrapProcess.REQUEST_BOOTSTRAP_URL)) {
                    result.getTaskResultMap().put("BOOTSTRAP_URL", "http://" + hostName + ":" + port + "/getFile?path=/data/bootstrap/" + this._message.getResourceName() + "/" + this._message.getPartitionName() + ".tar");
                    result.getTaskResultMap().put("BOOTSTRAP_TIME", "" + new Date().getTime());
                }
                result.setSuccess(true);
                return result;
            }

            @Override
            public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
                e.printStackTrace();
            }
        }
    }
}

