/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.model.RESTConfig;
import org.apache.helix.rest.client.CustomRestClient;
import org.apache.helix.rest.client.CustomRestClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixDataAccessorWrapper
extends ZKHelixDataAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(HelixDataAccessorWrapper.class);
    private static final ExecutorService POOL = Executors.newCachedThreadPool();
    static final String PARTITION_HEALTH_KEY = "PARTITION_HEALTH";
    static final String IS_HEALTHY_KEY = "IS_HEALTHY";
    static final String EXPIRY_KEY = "EXPIRE";
    private final Map<PropertyKey, HelixProperty> _propertyCache = new HashMap<PropertyKey, HelixProperty>();
    private final Map<PropertyKey, List<String>> _batchNameCache = new HashMap<PropertyKey, List<String>>();
    protected CustomRestClient _restClient = CustomRestClientFactory.get();

    public HelixDataAccessorWrapper(ZKHelixDataAccessor dataAccessor) {
        super(dataAccessor);
    }

    public Map<String, Map<String, Boolean>> getAllPartitionsHealthOnLiveInstance(RESTConfig restConfig, Map<String, String> customPayLoads) {
        List<String> liveInstances = this.getChildNames(this.keyBuilder().liveInstances());
        List zkHealthReports = this.getProperty(liveInstances.stream().map(instance -> this.keyBuilder().healthReport(instance, PARTITION_HEALTH_KEY)).collect(Collectors.toList()), false);
        HashMap<String, Future<Map>> parallelTasks = new HashMap<String, Future<Map>>();
        for (int i = 0; i < liveInstances.size(); ++i) {
            String liveInstance = liveInstances.get(i);
            Optional<ZNRecord> maybeHealthRecord = Optional.ofNullable(zkHealthReports.get(i)).map(HelixProperty::getRecord);
            parallelTasks.put(liveInstance, POOL.submit(() -> maybeHealthRecord.map(record -> this.getPartitionsHealth(liveInstance, (ZNRecord)record, restConfig, customPayLoads)).orElseGet(() -> this.getHealthStatusFromRest(liveInstance, Collections.emptyList(), restConfig, customPayLoads))));
        }
        HashMap<String, Map<String, Boolean>> result = new HashMap<String, Map<String, Boolean>>();
        for (Map.Entry instanceToFuturePartitionHealth : parallelTasks.entrySet()) {
            String instance2 = (String)instanceToFuturePartitionHealth.getKey();
            try {
                result.put(instance2, (Map<String, Boolean>)((Future)instanceToFuturePartitionHealth.getValue()).get());
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Failed to get partition health for instance {}", (Object)instance2, (Object)e);
                result.put(instance2, Collections.emptyMap());
            }
        }
        return result;
    }

    private Map<String, Boolean> getPartitionsHealth(String instance, ZNRecord partitionHealthRecord, RESTConfig restConfig, Map<String, String> customPayLoads) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        ArrayList<String> expiredPartitions = new ArrayList<String>();
        for (String partitionName : partitionHealthRecord.getMapFields().keySet()) {
            Map healthMap = partitionHealthRecord.getMapField(partitionName);
            if (healthMap == null || Long.parseLong((String)healthMap.get(EXPIRY_KEY)) < System.currentTimeMillis()) {
                expiredPartitions.add(partitionName);
                continue;
            }
            result.put(partitionName, Boolean.valueOf((String)healthMap.get(IS_HEALTHY_KEY)));
        }
        if (!expiredPartitions.isEmpty()) {
            Map<String, Boolean> updatedHealthStatus = this.getHealthStatusFromRest(instance, expiredPartitions, restConfig, customPayLoads);
            result.putAll(updatedHealthStatus);
        }
        return result;
    }

    private Map<String, Boolean> getHealthStatusFromRest(String instance, List<String> partitions, RESTConfig restConfig, Map<String, String> customPayLoads) {
        try {
            return this._restClient.getPartitionStoppableCheck(restConfig.getBaseUrl(instance), partitions, customPayLoads);
        }
        catch (IOException e) {
            LOG.error("Failed to get partition status on instance {}, partitions: {}", new Object[]{instance, partitions, e});
            return Collections.emptyMap();
        }
    }

    public <T extends HelixProperty> T getProperty(PropertyKey key) {
        if (this._propertyCache.containsKey(key)) {
            return (T)this._propertyCache.get(key);
        }
        HelixProperty property = super.getProperty(key);
        this._propertyCache.put(key, property);
        return (T)property;
    }

    public List<String> getChildNames(PropertyKey key) {
        if (this._batchNameCache.containsKey(key)) {
            return this._batchNameCache.get(key);
        }
        List names = super.getChildNames(key);
        this._batchNameCache.put(key, names);
        return names;
    }
}

