/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.resources.helix;

import java.io.IOException;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.manager.zk.client.HelixZkClient;
import org.apache.helix.rest.common.ContextPropertyKeys;
import org.apache.helix.rest.server.ServerContext;
import org.apache.helix.rest.server.resources.AbstractResource;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.tools.ClusterSetup;

public class AbstractHelixResource
extends AbstractResource {
    public HelixZkClient getHelixZkClient() {
        ServerContext serverContext = this.getServerContext();
        return serverContext.getHelixZkClient();
    }

    @Deprecated
    public ZkClient getZkClient() {
        return (ZkClient)this.getHelixZkClient();
    }

    public HelixAdmin getHelixAdmin() {
        ServerContext serverContext = this.getServerContext();
        return serverContext.getHelixAdmin();
    }

    public ClusterSetup getClusterSetup() {
        ServerContext serverContext = this.getServerContext();
        return serverContext.getClusterSetup();
    }

    public TaskDriver getTaskDriver(String clusterName) {
        ServerContext serverContext = this.getServerContext();
        return serverContext.getTaskDriver(clusterName);
    }

    public ConfigAccessor getConfigAccessor() {
        ServerContext serverContext = this.getServerContext();
        return serverContext.getConfigAccessor();
    }

    public HelixDataAccessor getDataAccssor(String clusterName) {
        ServerContext serverContext = this.getServerContext();
        return serverContext.getDataAccssor(clusterName);
    }

    protected static ZNRecord toZNRecord(String data) throws IOException {
        return (ZNRecord)OBJECT_MAPPER.reader(ZNRecord.class).readValue(data);
    }

    private ServerContext getServerContext() {
        return (ServerContext)this._application.getProperties().get(ContextPropertyKeys.SERVER_CONTEXT.name());
    }
}

