/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.store.zk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.I0Itec.zkclient.DataUpdater;
import org.apache.helix.AccessOption;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoFallbackPropertyStore<T>
extends ZkHelixPropertyStore<T> {
    private static Logger LOG = LoggerFactory.getLogger(AutoFallbackPropertyStore.class);
    private final ZkHelixPropertyStore<T> _fallbackStore;

    public AutoFallbackPropertyStore(ZkBaseDataAccessor<T> accessor, String root, String fallbackRoot) {
        super(accessor, root, null);
        if (accessor.exists(fallbackRoot, 0)) {
            this._fallbackStore = new ZkHelixPropertyStore<T>(accessor, fallbackRoot, null);
        } else {
            LOG.info("fallbackRoot: " + fallbackRoot + " doesn't exist, skip creating fallback property store");
            this._fallbackStore = null;
        }
    }

    @Override
    public boolean update(String path, DataUpdater<T> updater, int options) {
        Object fallbackValue;
        boolean succeed;
        if (this._fallbackStore == null) {
            return super.update(path, updater, options);
        }
        Stat stat = super.getStat(path, options);
        if (stat == null && !(succeed = super.create(path, fallbackValue = this._fallbackStore.get(path, null, options), AccessOption.PERSISTENT))) {
            LOG.error("Can't update " + path + " since there are concurrent updates");
            return false;
        }
        return super.update(path, updater, options);
    }

    @Override
    public boolean exists(String path, int options) {
        if (this._fallbackStore == null) {
            return super.exists(path, options);
        }
        boolean exist = super.exists(path, options);
        if (!exist) {
            exist = this._fallbackStore.exists(path, options);
        }
        return exist;
    }

    @Override
    public boolean remove(String path, int options) {
        if (this._fallbackStore != null) {
            this._fallbackStore.remove(path, options);
        }
        return super.remove(path, options);
    }

    @Override
    public T get(String path, Stat stat, int options) {
        if (this._fallbackStore == null) {
            return super.get(path, stat, options);
        }
        Object value = super.get(path, stat, options);
        if (value == null) {
            value = this._fallbackStore.get(path, stat, options);
        }
        return value;
    }

    @Override
    public Stat getStat(String path, int options) {
        if (this._fallbackStore == null) {
            return super.getStat(path, options);
        }
        Stat stat = super.getStat(path, options);
        if (stat == null) {
            stat = this._fallbackStore.getStat(path, options);
        }
        return stat;
    }

    @Override
    public boolean[] updateChildren(List<String> paths, List<DataUpdater<T>> updaters, int options) {
        int i;
        if (this._fallbackStore == null) {
            return super.updateChildren(paths, updaters, options);
        }
        Stat[] stats = super.getStats(paths, options);
        HashMap<String, Integer> fallbackMap = new HashMap<String, Integer>();
        HashMap<String, Integer> updateMap = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < paths.size(); ++i2) {
            String path = paths.get(i2);
            if (stats[i2] == null) {
                fallbackMap.put(path, i2);
                continue;
            }
            updateMap.put(path, i2);
        }
        if (fallbackMap.size() > 0) {
            ArrayList<String> fallbackPaths = new ArrayList<String>(fallbackMap.keySet());
            List fallbackValues = this._fallbackStore.get(fallbackPaths, null, options, true);
            boolean[] createSucceed = super.createChildren(fallbackPaths, fallbackValues, AccessOption.PERSISTENT);
            for (i = 0; i < fallbackPaths.size(); ++i) {
                String fallbackPath = (String)fallbackPaths.get(i);
                if (createSucceed[i]) {
                    updateMap.put(fallbackPath, (Integer)fallbackMap.get(fallbackPath));
                    continue;
                }
                LOG.error("Can't update " + fallbackPath + " since there are concurrent updates");
            }
        }
        boolean[] succeed = new boolean[paths.size()];
        if (updateMap.size() > 0) {
            ArrayList<String> updatePaths = new ArrayList<String>(updateMap.keySet());
            ArrayList subUpdaters = new ArrayList();
            for (i = 0; i < updatePaths.size(); ++i) {
                String updatePath = (String)updatePaths.get(i);
                subUpdaters.add(updaters.get((Integer)updateMap.get(updatePath)));
            }
            boolean[] updateSucceed = super.updateChildren(updatePaths, subUpdaters, options);
            for (int i3 = 0; i3 < updatePaths.size(); ++i3) {
                String updatePath = (String)updatePaths.get(i3);
                if (!updateSucceed[i3]) continue;
                succeed[((Integer)updateMap.get((Object)updatePath)).intValue()] = true;
            }
        }
        return succeed;
    }

    @Override
    public boolean[] exists(List<String> paths, int options) {
        if (this._fallbackStore == null) {
            return super.exists(paths, options);
        }
        boolean[] exists = super.exists(paths, options);
        HashMap<String, Integer> fallbackMap = new HashMap<String, Integer>();
        for (int i = 0; i < paths.size(); ++i) {
            boolean exist = exists[i];
            if (exist) continue;
            fallbackMap.put(paths.get(i), i);
        }
        if (fallbackMap.size() > 0) {
            ArrayList<String> fallbackPaths = new ArrayList<String>(fallbackMap.keySet());
            boolean[] fallbackExists = this._fallbackStore.exists(fallbackPaths, options);
            for (int i = 0; i < fallbackPaths.size(); ++i) {
                String fallbackPath = (String)fallbackPaths.get(i);
                int j = (Integer)fallbackMap.get(fallbackPath);
                exists[j] = fallbackExists[i];
            }
        }
        return exists;
    }

    @Override
    public boolean[] remove(List<String> paths, int options) {
        if (this._fallbackStore != null) {
            this._fallbackStore.remove(paths, options);
        }
        return super.remove(paths, options);
    }

    @Override
    public List<T> get(List<String> paths, List<Stat> stats, int options, boolean throwException) {
        if (this._fallbackStore == null) {
            return super.get(paths, stats, options, throwException);
        }
        List values = super.get(paths, stats, options, throwException);
        HashMap<String, Integer> fallbackMap = new HashMap<String, Integer>();
        for (int i = 0; i < paths.size(); ++i) {
            Object value = values.get(i);
            if (value != null) continue;
            fallbackMap.put(paths.get(i), i);
        }
        if (fallbackMap.size() > 0) {
            ArrayList<String> fallbackPaths = new ArrayList<String>(fallbackMap.keySet());
            ArrayList<Stat> fallbackStats = new ArrayList<Stat>();
            List fallbackValues = this._fallbackStore.get(fallbackPaths, fallbackStats, options, throwException);
            for (int i = 0; i < fallbackPaths.size(); ++i) {
                String fallbackPath = (String)fallbackPaths.get(i);
                int j = (Integer)fallbackMap.get(fallbackPath);
                values.set(j, fallbackValues.get(i));
                if (stats == null) continue;
                stats.set(j, (Stat)fallbackStats.get(i));
            }
        }
        return values;
    }

    @Override
    public Stat[] getStats(List<String> paths, int options) {
        if (this._fallbackStore == null) {
            return super.getStats(paths, options);
        }
        Stat[] stats = super.getStats(paths, options);
        HashMap<String, Integer> fallbackMap = new HashMap<String, Integer>();
        for (int i = 0; i < paths.size(); ++i) {
            Stat stat = stats[i];
            if (stat != null) continue;
            fallbackMap.put(paths.get(i), i);
        }
        if (fallbackMap.size() > 0) {
            ArrayList<String> fallbackPaths = new ArrayList<String>(fallbackMap.keySet());
            Stat[] fallbackStats = this._fallbackStore.getStats(fallbackPaths, options);
            for (int i = 0; i < fallbackPaths.size(); ++i) {
                String fallbackPath = (String)fallbackPaths.get(i);
                int j = (Integer)fallbackMap.get(fallbackPath);
                stats[j] = fallbackStats[i];
            }
        }
        return stats;
    }

    @Override
    public List<String> getChildNames(String parentPath, int options) {
        if (this._fallbackStore == null) {
            return super.getChildNames(parentPath, options);
        }
        List<String> childs = super.getChildNames(parentPath, options);
        List<String> fallbackChilds = this._fallbackStore.getChildNames(parentPath, options);
        if (childs == null && fallbackChilds == null) {
            return null;
        }
        HashSet<String> allChildSet = new HashSet<String>();
        if (childs != null) {
            allChildSet.addAll(childs);
        }
        if (fallbackChilds != null) {
            allChildSet.addAll(fallbackChilds);
        }
        ArrayList<String> allChilds = new ArrayList<String>(allChildSet);
        return allChilds;
    }

    @Override
    public void start() {
        if (this._fallbackStore != null) {
            this._fallbackStore.start();
        }
    }

    @Override
    public void stop() {
        if (this._fallbackStore != null) {
            this._fallbackStore.stop();
        }
        super.stop();
    }

    @Override
    public void reset() {
        if (this._fallbackStore != null) {
            this._fallbackStore.reset();
        }
        super.reset();
    }
}

