/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task.assigner;

import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.assigner.AssignableInstance;

public class TaskAssignResult
implements Comparable<TaskAssignResult> {
    private final boolean _isAssignmentSuccessful;
    private final int _fitnessScore;
    private final FailureReason _reason;
    private final AssignableInstance _node;
    private final TaskConfig _taskConfig;
    private final String _description;
    private final String _quotaType;

    public TaskAssignResult(TaskConfig taskConfig, String quotaType, AssignableInstance node, boolean isSuccessful, int fitness, FailureReason reason, String description) {
        this._isAssignmentSuccessful = isSuccessful;
        this._fitnessScore = fitness;
        this._reason = reason;
        this._taskConfig = taskConfig;
        this._node = node;
        this._description = description;
        this._quotaType = quotaType;
    }

    public boolean isSuccessful() {
        return this._isAssignmentSuccessful;
    }

    public TaskConfig getTaskConfig() {
        return this._taskConfig;
    }

    public String getQuotaType() {
        return this._quotaType;
    }

    public String getInstanceName() {
        return this._node == null ? null : this._node.getInstanceName();
    }

    public AssignableInstance getAssignableInstance() {
        return this._node;
    }

    public FailureReason getFailureReason() {
        return this._reason;
    }

    public String getFailureDescription() {
        return this._description;
    }

    public int getFitnessScore() {
        return this._fitnessScore;
    }

    @Override
    public int compareTo(TaskAssignResult other) {
        return other.getFitnessScore() - this._fitnessScore;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TaskAssignResult{");
        sb.append(String.format("_taskConfig=%s, ", this._taskConfig));
        sb.append(String.format("_isAssignmentSuccessful=%s, ", this._isAssignmentSuccessful));
        sb.append(String.format("_fitnessScore=%s, ", this._fitnessScore));
        sb.append(String.format("_reason='%s', ", this._reason == null ? "null" : this._reason.name()));
        sb.append(String.format("_node='%s', ", this._node == null ? "null" : this._node.getInstanceName()));
        sb.append(String.format("_description='%s'", this._description));
        sb.append("}");
        return sb.toString();
    }

    public static enum FailureReason {
        INSUFFICIENT_QUOTA,
        NO_SUCH_RESOURCE_TYPE,
        NO_SUCH_QUOTA_TYPE,
        TASK_ALREADY_ASSIGNED;

    }
}

