/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import org.apache.helix.HelixDefinedState;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public final class OnlineOfflineWithBootstrapSMD
extends StateModelDefinition {
    public static final String name = "OnlineOfflineWithBootstrap";

    private OnlineOfflineWithBootstrapSMD(ZNRecord record) {
        super(record);
    }

    public static OnlineOfflineWithBootstrapSMD build() {
        StateModelDefinition.Builder builder = new StateModelDefinition.Builder(name);
        builder.initialState(States.OFFLINE.name());
        builder.addState(States.ONLINE.name(), 0);
        builder.addState(States.BOOTSTRAP.name(), 1);
        builder.addState(States.OFFLINE.name(), 2);
        for (HelixDefinedState state : HelixDefinedState.values()) {
            builder.addState(state.name());
        }
        builder.addTransition(States.ONLINE.name(), States.OFFLINE.name(), 0);
        builder.addTransition(States.OFFLINE.name(), States.BOOTSTRAP.name(), 1);
        builder.addTransition(States.BOOTSTRAP.name(), States.ONLINE.name(), 2);
        builder.addTransition(States.OFFLINE.name(), HelixDefinedState.DROPPED.name());
        builder.dynamicUpperBound(States.ONLINE.name(), "R");
        return new OnlineOfflineWithBootstrapSMD(builder.build().getRecord());
    }

    public static enum States {
        ONLINE,
        BOOTSTRAP,
        OFFLINE;

    }
}

