/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.agent;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.helix.agent.SystemUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessMonitorThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessMonitorThread.class);
    private static final int MONITOR_PERIOD_BASE = 1000;
    private final String _pid;

    public ProcessMonitorThread(String pid) {
        this._pid = pid;
    }

    @Override
    public void run() {
        try {
            SystemUtil.ProcessStateCode processState = SystemUtil.getProcessState(this._pid);
            while (processState != null) {
                if (processState == SystemUtil.ProcessStateCode.Z) {
                    LOG.error("process: " + this._pid + " is in zombie state");
                    break;
                }
                TimeUnit.MILLISECONDS.sleep(new Random().nextInt(1000) + 1000);
                processState = SystemUtil.getProcessState(this._pid);
            }
        }
        catch (Exception e) {
            LOG.error("fail to monitor process: " + this._pid, (Throwable)e);
        }
    }
}

