/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.thrift.TException;

public class JSONAlterPartitionMessage
extends AlterPartitionMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    String db;
    @JsonProperty
    String table;
    @JsonProperty
    String tableType;
    @JsonProperty
    String tableObjJson;
    @JsonProperty
    String isTruncateOp;
    @JsonProperty
    Long timestamp;
    @JsonProperty
    Long writeId;
    @JsonProperty
    Map<String, String> keyValues;
    @JsonProperty
    String partitionObjBeforeJson;
    @JsonProperty
    String partitionObjAfterJson;

    public JSONAlterPartitionMessage() {
    }

    public JSONAlterPartitionMessage(String server, String servicePrincipal, Table tableObj, Partition partitionObjBefore, Partition partitionObjAfter, boolean isTruncateOp, Long writeId, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.db = tableObj.getDbName();
        this.table = tableObj.getTableName();
        this.tableType = tableObj.getTableType();
        this.isTruncateOp = Boolean.toString(isTruncateOp);
        this.timestamp = timestamp;
        this.keyValues = MessageBuilder.getPartitionKeyValues(tableObj, partitionObjBefore);
        this.writeId = writeId;
        try {
            this.tableObjJson = MessageBuilder.createTableObjJson(tableObj);
            this.partitionObjBeforeJson = MessageBuilder.createPartitionObjJson(partitionObjBefore);
            this.partitionObjAfterJson = MessageBuilder.createPartitionObjJson(partitionObjAfter);
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
        this.checkValid();
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return this.db;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getTableType() {
        if (this.tableType != null) {
            return this.tableType;
        }
        return "";
    }

    @Override
    public boolean getIsTruncateOp() {
        return Boolean.parseBoolean(this.isTruncateOp);
    }

    @Override
    public Map<String, String> getKeyValues() {
        return this.keyValues;
    }

    @Override
    public Table getTableObj() throws Exception {
        return (Table)MessageBuilder.getTObj(this.tableObjJson, Table.class);
    }

    @Override
    public Partition getPtnObjBefore() throws Exception {
        return (Partition)MessageBuilder.getTObj(this.partitionObjBeforeJson, Partition.class);
    }

    @Override
    public Partition getPtnObjAfter() throws Exception {
        return (Partition)MessageBuilder.getTObj(this.partitionObjAfterJson, Partition.class);
    }

    public String getTableObjJson() {
        return this.tableObjJson;
    }

    public String getPartitionObjBeforeJson() {
        return this.partitionObjBeforeJson;
    }

    public String getPartitionObjAfterJson() {
        return this.partitionObjAfterJson;
    }

    @Override
    public Long getWriteId() {
        return this.writeId == null ? 0L : this.writeId;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
    }
}

