/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.mapping.MappingType;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.rdbms.table.ClassTable;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.Localiser;

public class ListIndexOfMethod
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        SQLExpression collSqlExpr = null;
        SQLExpression elemSqlExpr = null;
        if (expr != null) {
            if (args == null || args.size() == 0 || args.size() > 1) {
                throw new NucleusException(Localiser.msg((String)"060016", (Object[])new Object[]{"indexOf", "CollectionExpression", 1}));
            }
            elemSqlExpr = args.get(0);
            collSqlExpr = expr;
        } else {
            if (args == null || args.size() != 2) {
                throw new NucleusException(Localiser.msg((String)"060016", (Object[])new Object[]{"indexOf", "CollectionExpression", 2}));
            }
            elemSqlExpr = args.get(0);
            collSqlExpr = args.get(1);
        }
        AbstractMemberMetaData mmd = collSqlExpr.getJavaTypeMapping().getMemberMetaData();
        if (mmd == null) {
            throw new NucleusException(Localiser.msg((String)"060020", (Object[])new Object[]{"indexOf", collSqlExpr.getClass().getName()}));
        }
        if (!mmd.hasCollection()) {
            throw new NucleusException("List.indexOf expression for field " + mmd.getFullFieldName() + " does not represent a collection!");
        }
        if (!mmd.getOrderMetaData().isIndexedList()) {
            throw new NucleusException("List.indexOf expression for field " + mmd.getFullFieldName() + " does not represent an indexed list!");
        }
        JavaTypeMapping orderMapping = null;
        SQLTable orderTable = null;
        Table joinTbl = stmt.getRDBMSManager().getTable(mmd);
        if (joinTbl != null) {
            CollectionTable collTable = (CollectionTable)joinTbl;
            orderTable = stmt.getTableForDatastoreContainer(collTable);
            if (orderTable == null) {
                orderTable = stmt.join(SQLJoin.JoinType.LEFT_OUTER_JOIN, collSqlExpr.getSQLTable(), collSqlExpr.getSQLTable().getTable().getIdMapping(), collTable, null, collTable.getOwnerMapping(), null, null);
            }
            orderMapping = collTable.getOrderMapping();
        } else {
            orderTable = elemSqlExpr.getSQLTable();
            orderMapping = ((ClassTable)elemSqlExpr.getSQLTable().getTable()).getExternalMapping(mmd, MappingType.EXTERNAL_INDEX);
        }
        return new NumericExpression(stmt, orderTable, orderMapping);
    }
}

