/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.Optional;
import org.apache.hadoop.hive.ql.parse.AlterTableSnapshotRefSpec;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.apache.iceberg.util.SnapshotUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergSnapshotRefExec {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergSnapshotRefExec.class);

    private IcebergSnapshotRefExec() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createBranch(Table table, AlterTableSnapshotRefSpec.CreateSnapshotRefSpec createBranchSpec) {
        String branchName = createBranchSpec.getRefName();
        boolean refExistsAsBranch = IcebergSnapshotRefExec.refExistsAsBranch(table, branchName);
        if (createBranchSpec.isIfNotExists() && refExistsAsBranch) {
            return;
        }
        boolean isReplace = createBranchSpec.isReplace() && refExistsAsBranch;
        Long snapshotId = null;
        if (createBranchSpec.getSnapshotId() != null) {
            snapshotId = createBranchSpec.getSnapshotId();
        } else if (createBranchSpec.getAsOfTime() != null) {
            snapshotId = SnapshotUtil.snapshotIdAsOfTime(table, createBranchSpec.getAsOfTime());
        } else if (createBranchSpec.getAsOfTag() != null) {
            String tagName = createBranchSpec.getAsOfTag();
            SnapshotRef snapshotRef = table.refs().get(tagName);
            if (snapshotRef == null || !snapshotRef.isTag()) throw new IllegalArgumentException(String.format("Tag %s does not exist", tagName));
            snapshotId = snapshotRef.snapshotId();
        } else {
            snapshotId = Optional.ofNullable(table.currentSnapshot()).map(Snapshot::snapshotId).orElse(null);
        }
        ManageSnapshots manageSnapshots = table.manageSnapshots();
        if (snapshotId != null) {
            IcebergSnapshotRefExec.createOrReplaceBranch(manageSnapshots, table, isReplace, branchName, snapshotId);
        } else {
            if (isReplace) {
                throw new IllegalArgumentException("Cannot complete replace branch operation on " + branchName + ", main has no snapshot");
            }
            LOG.info("Creating a branch {} on an empty iceberg table {}", (Object)branchName, (Object)table.name());
            manageSnapshots.createBranch(branchName);
        }
        IcebergSnapshotRefExec.setCreateBranchOptionalParams(createBranchSpec, manageSnapshots, branchName);
        manageSnapshots.commit();
    }

    private static void setCreateBranchOptionalParams(AlterTableSnapshotRefSpec.CreateSnapshotRefSpec createBranchSpec, ManageSnapshots manageSnapshots, String branchName) {
        if (createBranchSpec.getMaxRefAgeMs() != null) {
            manageSnapshots.setMaxRefAgeMs(branchName, createBranchSpec.getMaxRefAgeMs());
        }
        if (createBranchSpec.getMinSnapshotsToKeep() != null) {
            manageSnapshots.setMinSnapshotsToKeep(branchName, createBranchSpec.getMinSnapshotsToKeep());
        }
        if (createBranchSpec.getMaxSnapshotAgeMs() != null) {
            manageSnapshots.setMaxSnapshotAgeMs(branchName, createBranchSpec.getMaxSnapshotAgeMs());
        }
    }

    private static void createOrReplaceBranch(ManageSnapshots manageSnapshots, Table table, boolean isReplace, String branchName, Long snapshotId) {
        if (isReplace) {
            LOG.info("Replacing branch {} on an iceberg table {} with snapshotId {}", new Object[]{branchName, table.name(), snapshotId});
            manageSnapshots.replaceBranch(branchName, snapshotId);
        } else {
            LOG.info("Creating a branch {} on an iceberg table {} with snapshotId {}", new Object[]{branchName, table.name(), snapshotId});
            manageSnapshots.createBranch(branchName, snapshotId);
        }
    }

    private static boolean refExistsAsTag(Table table, String tagName) {
        SnapshotRef tagRef = table.refs().get(tagName);
        if (tagRef != null) {
            if (tagRef.isTag()) {
                return true;
            }
            throw new IllegalArgumentException("Cannot complete create tag operation on " + tagName + ", as it exists as Branch");
        }
        return false;
    }

    private static boolean refExistsAsBranch(Table table, String branchName) {
        SnapshotRef branchRef = table.refs().get(branchName);
        if (branchRef != null) {
            if (branchRef.isBranch()) {
                return true;
            }
            throw new IllegalArgumentException("Cannot complete replace branch operation on " + branchName + ", as it exists as Tag");
        }
        return false;
    }

    public static void dropBranch(Table table, AlterTableSnapshotRefSpec.DropSnapshotRefSpec dropBranchSpec) {
        String branchName = dropBranchSpec.getRefName();
        boolean ifExists = dropBranchSpec.getIfExists();
        SnapshotRef snapshotRef = table.refs().get(branchName);
        if (snapshotRef != null || !ifExists) {
            LOG.info("Dropping branch {} on iceberg table {}", (Object)branchName, (Object)table.name());
            table.manageSnapshots().removeBranch(branchName).commit();
        }
    }

    public static void renameBranch(Table table, AlterTableSnapshotRefSpec.RenameSnapshotrefSpec renameSnapshotrefSpec) {
        String sourceBranch = renameSnapshotrefSpec.getSourceBranchName();
        String targetBranch = renameSnapshotrefSpec.getTargetBranchName();
        LOG.info("Renaming branch {} to {} on iceberg table {}", new Object[]{sourceBranch, targetBranch, table.name()});
        table.manageSnapshots().renameBranch(sourceBranch, targetBranch).commit();
    }

    public static void replaceBranch(Table table, AlterTableSnapshotRefSpec.ReplaceSnapshotrefSpec replaceSnapshotrefSpec) {
        ManageSnapshots manageSnapshots;
        String sourceBranch = replaceSnapshotrefSpec.getSourceRefName();
        if (replaceSnapshotrefSpec.isReplaceBySnapshot()) {
            long targetSnapshot = replaceSnapshotrefSpec.getTargetSnapshot();
            LOG.info("Replacing branch {} with snapshot {} on iceberg table {}", new Object[]{sourceBranch, targetSnapshot, table.name()});
            manageSnapshots = table.manageSnapshots().replaceBranch(sourceBranch, targetSnapshot);
        } else {
            String targetBranch = replaceSnapshotrefSpec.getTargetBranchName();
            LOG.info("Replacing branch {} with branch {} on iceberg table {}", new Object[]{sourceBranch, targetBranch, table.name()});
            manageSnapshots = table.manageSnapshots().replaceBranch(sourceBranch, targetBranch);
        }
        IcebergSnapshotRefExec.setOptionalReplaceParams(replaceSnapshotrefSpec, manageSnapshots, sourceBranch);
        manageSnapshots.commit();
    }

    public static void createTag(Table table, AlterTableSnapshotRefSpec.CreateSnapshotRefSpec createTagSpec) {
        String tagName = createTagSpec.getRefName();
        boolean refExistsAsTag = IcebergSnapshotRefExec.refExistsAsTag(table, tagName);
        if (createTagSpec.isIfNotExists() && refExistsAsTag) {
            return;
        }
        boolean isReplace = createTagSpec.isReplace() && refExistsAsTag;
        Long snapshotId = null;
        snapshotId = createTagSpec.getSnapshotId() != null ? createTagSpec.getSnapshotId() : (createTagSpec.getAsOfTime() != null ? Long.valueOf(SnapshotUtil.snapshotIdAsOfTime(table, createTagSpec.getAsOfTime())) : Long.valueOf(table.currentSnapshot().snapshotId()));
        ManageSnapshots manageSnapshots = table.manageSnapshots();
        if (isReplace) {
            LOG.info("Replacing tag {} on iceberg table {} with snapshotId {}", new Object[]{tagName, table.name(), snapshotId});
            manageSnapshots.replaceTag(tagName, snapshotId);
        } else {
            LOG.info("Creating tag {} on iceberg table {} with snapshotId {}", new Object[]{tagName, table.name(), snapshotId});
            manageSnapshots.createTag(tagName, snapshotId);
        }
        if (createTagSpec.getMaxRefAgeMs() != null) {
            manageSnapshots.setMaxRefAgeMs(tagName, createTagSpec.getMaxRefAgeMs());
        }
        manageSnapshots.commit();
    }

    public static void dropTag(Table table, AlterTableSnapshotRefSpec.DropSnapshotRefSpec dropTagSpec) {
        String tagName = dropTagSpec.getRefName();
        boolean ifExists = dropTagSpec.getIfExists();
        SnapshotRef snapshotRef = table.refs().get(tagName);
        if (snapshotRef != null || !ifExists) {
            LOG.info("Dropping tag {} on iceberg table {}", (Object)tagName, (Object)table.name());
            table.manageSnapshots().removeTag(tagName).commit();
        }
    }

    public static void replaceTag(Table table, AlterTableSnapshotRefSpec.ReplaceSnapshotrefSpec replaceTagRefSpec) {
        String sourceTag = replaceTagRefSpec.getSourceRefName();
        long targetSnapshot = replaceTagRefSpec.getTargetSnapshot();
        LOG.info("Replacing tag {} with snapshot {} on iceberg table {}", new Object[]{sourceTag, targetSnapshot, table.name()});
        ManageSnapshots manageSnapshots = table.manageSnapshots().replaceTag(sourceTag, targetSnapshot);
        IcebergSnapshotRefExec.setOptionalReplaceParams(replaceTagRefSpec, manageSnapshots, sourceTag);
        manageSnapshots.commit();
    }

    static void setOptionalReplaceParams(AlterTableSnapshotRefSpec.ReplaceSnapshotrefSpec replaceSnapshotrefSpec, ManageSnapshots manageSnapshots, String sourceBranch) {
        if (replaceSnapshotrefSpec.getMaxRefAgeMs() > 0L) {
            manageSnapshots.setMaxRefAgeMs(sourceBranch, replaceSnapshotrefSpec.getMaxRefAgeMs());
        }
        if (replaceSnapshotrefSpec.getMaxSnapshotAgeMs() > 0L) {
            manageSnapshots.setMaxSnapshotAgeMs(sourceBranch, replaceSnapshotrefSpec.getMaxSnapshotAgeMs());
        }
        if (replaceSnapshotrefSpec.getMinSnapshotsToKeep() > 0) {
            manageSnapshots.setMinSnapshotsToKeep(sourceBranch, replaceSnapshotrefSpec.getMinSnapshotsToKeep());
        }
    }
}

