/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;
import org.datanucleus.store.types.converters.ColumnLengthDefiningTypeConverter;
import org.datanucleus.store.types.converters.TypeConverter;

public class DateStringConverter
implements TypeConverter<Date, String>,
ColumnLengthDefiningTypeConverter {
    private static final long serialVersionUID = 4638239842151376340L;

    @Override
    public int getDefaultColumnLength(int columnPosition) {
        if (columnPosition != 0) {
            return -1;
        }
        return 28;
    }

    @Override
    public Date toMemberType(String str) {
        if (str == null) {
            return null;
        }
        Instant inst = Instant.parse(str);
        return Date.from(inst.atZone(ZoneId.systemDefault()).toInstant());
    }

    @Override
    public String toDatastoreType(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().toString();
    }
}

