/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.ColumnLengthDefiningTypeConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class LocalTimeStringConverter
implements TypeConverter<LocalTime, String>,
ColumnLengthDefiningTypeConverter {
    private static final long serialVersionUID = 4942570075844340588L;

    @Override
    public LocalTime toMemberType(String str) {
        if (str == null) {
            return null;
        }
        try {
            return LocalTime.parse(str);
        }
        catch (DateTimeParseException pe) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, LocalTime.class.getName()), pe);
        }
    }

    @Override
    public String toDatastoreType(LocalTime date) {
        return date != null ? date.toString() : null;
    }

    @Override
    public int getDefaultColumnLength(int columnPosition) {
        if (columnPosition != 0) {
            return -1;
        }
        return 12;
    }
}

