/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.util.Locale;
import org.datanucleus.store.types.converters.ColumnLengthDefiningTypeConverter;
import org.datanucleus.store.types.converters.TypeConverter;

public class LocaleStringConverter
implements TypeConverter<Locale, String>,
ColumnLengthDefiningTypeConverter {
    private static final long serialVersionUID = -5566584819761013454L;

    @Override
    public Locale toMemberType(String str) {
        if (str == null) {
            return null;
        }
        return LocaleStringConverter.getLocaleFromString(str);
    }

    @Override
    public String toDatastoreType(Locale loc) {
        return loc != null ? loc.toString() : null;
    }

    @Override
    public int getDefaultColumnLength(int columnPosition) {
        if (columnPosition != 0) {
            return -1;
        }
        return 20;
    }

    public static Locale getLocaleFromString(String localeString) {
        if (localeString == null) {
            return null;
        }
        if ((localeString = localeString.trim()).toLowerCase().equals("default")) {
            return Locale.getDefault();
        }
        int languageIndex = localeString.indexOf(95);
        String language = null;
        if (languageIndex == -1) {
            return new Locale(localeString, "");
        }
        language = localeString.substring(0, languageIndex);
        int countryIndex = localeString.indexOf(95, languageIndex + 1);
        String country = null;
        if (countryIndex == -1) {
            country = localeString.substring(languageIndex + 1);
            return new Locale(language, country);
        }
        country = localeString.substring(languageIndex + 1, countryIndex);
        String variant = localeString.substring(countryIndex + 1);
        return new Locale(language, country, variant);
    }
}

