/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.showcreate;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.database.showcreate.ShowCreateDatabaseDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.IOUtils;
import org.apache.hive.common.util.HiveStringUtils;

public class ShowCreateDatabaseOperation
extends DDLOperation<ShowCreateDatabaseDesc> {
    public ShowCreateDatabaseOperation(DDLOperationContext context, ShowCreateDatabaseDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        DataOutputStream outStream = ShowUtils.getOutputStream(((ShowCreateDatabaseDesc)this.desc).getResFile(), this.context);
        try {
            int n = this.showCreateDatabase(outStream);
            return n;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
    }

    private int showCreateDatabase(DataOutputStream outStream) throws Exception {
        String propertiesToString;
        Database database = this.context.getDb().getDatabase(((ShowCreateDatabaseDesc)this.desc).getDatabaseName());
        StringBuilder createDbCommand = new StringBuilder();
        createDbCommand.append("CREATE DATABASE `").append(database.getName()).append("`\n");
        if (database.getDescription() != null) {
            createDbCommand.append("COMMENT\n  '");
            createDbCommand.append(HiveStringUtils.escapeHiveCommand((String)database.getDescription())).append("'\n");
        }
        createDbCommand.append("LOCATION\n  '");
        createDbCommand.append(database.getLocationUri()).append("'\n");
        if (database.getManagedLocationUri() != null) {
            createDbCommand.append("MANAGEDLOCATION\n  '");
            createDbCommand.append(database.getManagedLocationUri()).append("'\n");
        }
        if (!(propertiesToString = ShowUtils.propertiesToString(database.getParameters(), Collections.emptySet())).isEmpty()) {
            createDbCommand.append("WITH DBPROPERTIES (\n");
            createDbCommand.append(propertiesToString).append(")\n");
        }
        outStream.write(createDbCommand.toString().getBytes(StandardCharsets.UTF_8));
        return 0;
    }
}

