/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.dataconnector.desc;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.dataconnector.desc.DescDataConnectorDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={995})
public class DescDataConnectorAnalyzer
extends BaseSemanticAnalyzer {
    public DescDataConnectorAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() == 0 || root.getChildCount() > 2) {
            throw new SemanticException("Unexpected Tokens at DESCRIBE CONNECTOR");
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        String connectorName = DescDataConnectorAnalyzer.stripQuotes(root.getChild(0).getText());
        boolean isExtended = root.getChildCount() == 2;
        this.inputs.add(new ReadEntity(this.getDataConnector(connectorName)));
        DescDataConnectorDesc desc = new DescDataConnectorDesc(this.ctx.getResFile(), connectorName, isExtended);
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask(desc.getSchema()));
    }
}

