/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.process.show.transactions;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.process.show.transactions.ShowTransactionsDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;

public class ShowTransactionsOperation
extends DDLOperation<ShowTransactionsDesc> {
    public ShowTransactionsOperation(DDLOperationContext context, ShowTransactionsDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        SessionState sessionState = SessionState.get();
        GetOpenTxnsInfoResponse rsp = this.context.getDb().showTransactions();
        try (DataOutputStream os = ShowUtils.getOutputStream(new Path(((ShowTransactionsDesc)this.desc).getResFile()), this.context);){
            if (!sessionState.isHiveServerQuery()) {
                this.writeHeader(os);
            }
            for (TxnInfo txn : rsp.getOpen_txns()) {
                this.writeRow(os, txn);
            }
        }
        catch (IOException e) {
            LOG.warn("show transactions: ", (Throwable)e);
            return 1;
        }
        return 0;
    }

    private void writeHeader(DataOutputStream os) throws IOException {
        os.writeBytes("Transaction ID");
        os.write(9);
        os.writeBytes("Transaction State");
        os.write(9);
        os.writeBytes("Started Time");
        os.write(9);
        os.writeBytes("Last Heartbeat Time");
        os.write(9);
        os.writeBytes("User");
        os.write(9);
        os.writeBytes("Hostname");
        os.write(10);
    }

    private void writeRow(DataOutputStream os, TxnInfo txn) throws IOException {
        os.writeBytes(Long.toString(txn.getId()));
        os.write(9);
        os.writeBytes(txn.getState().toString());
        os.write(9);
        os.writeBytes(Long.toString(txn.getStartedTime()));
        os.write(9);
        os.writeBytes(Long.toString(txn.getLastHeartbeatTime()));
        os.write(9);
        os.writeBytes(txn.getUser());
        os.write(9);
        os.writeBytes(txn.getHostname());
        os.write(10);
    }
}

