/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.misc.truncate;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;

@Explain(displayName="Truncate Table or Partition", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class TruncateTableDesc
implements DDLDesc.DDLDescWithWriteId,
Serializable {
    private static final long serialVersionUID = 1L;
    private final TableName tableName;
    private final Map<String, String> partSpec;
    private final ReplicationSpec replicationSpec;
    private final boolean isTransactional;
    private final List<Integer> columnIndexes;
    private final Path inputDir;
    private final Path outputDir;
    private final ListBucketingCtx lbCtx;
    private long writeId = 0L;

    public TruncateTableDesc(TableName tableName, Map<String, String> partSpec, ReplicationSpec replicationSpec) {
        this(tableName, partSpec, replicationSpec, null);
    }

    public TruncateTableDesc(TableName tableName, Map<String, String> partSpec, ReplicationSpec replicationSpec, Table table) {
        this(tableName, partSpec, replicationSpec, table, null, null, null, null);
    }

    public TruncateTableDesc(TableName tableName, Map<String, String> partSpec, ReplicationSpec replicationSpec, Table table, List<Integer> columnIndexes, Path inputDir, Path outputDir, ListBucketingCtx lbCtx) {
        this.tableName = tableName;
        this.partSpec = partSpec;
        this.replicationSpec = replicationSpec;
        this.isTransactional = AcidUtils.isTransactionalTable(table);
        this.columnIndexes = columnIndexes;
        this.inputDir = inputDir;
        this.outputDir = outputDir;
        this.lbCtx = lbCtx;
    }

    @Explain(displayName="table name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName.getNotEmptyDbTable();
    }

    @Override
    public String getFullTableName() {
        return this.tableName.getNotEmptyDbTable();
    }

    @Explain(displayName="partition spec", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, String> getPartSpec() {
        return this.partSpec;
    }

    public ReplicationSpec getReplicationSpec() {
        return this.replicationSpec;
    }

    @Explain(displayName="column indexes")
    public List<Integer> getColumnIndexes() {
        return this.columnIndexes;
    }

    public Path getInputDir() {
        return this.inputDir;
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public ListBucketingCtx getLbCtx() {
        return this.lbCtx;
    }

    @Override
    public void setWriteId(long writeId) {
        this.writeId = writeId;
    }

    @Override
    public boolean mayNeedWriteId() {
        return this.isTransactional;
    }

    public long getWriteId() {
        return this.writeId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.getFullTableName();
    }
}

