/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.load;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.messaging.AddCheckConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AddDefaultConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AddForeignKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.AddNotNullConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AddPrimaryKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.AddUniqueConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageEncoder;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.ConstraintEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.LoadFunction;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.exec.repl.util.TaskTracker;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AddCheckConstraintHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AddDefaultConstraintHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AddForeignKeyHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AddNotNullConstraintHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AddPrimaryKeyHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AddUniqueConstraintHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(LoadFunction.class);
    private Context context;
    private final ConstraintEvent event;
    private final String dbNameToLoadIn;
    private final TaskTracker tracker;
    private final MessageDeserializer deserializer = JSONMessageEncoder.getInstance().getDeserializer();
    String dumpDirectory;
    private transient ReplicationMetricCollector metricCollector;

    public LoadConstraint(Context context, ConstraintEvent event, String dbNameToLoadIn, TaskTracker existingTracker) {
        this.context = context;
        this.event = event;
        this.dbNameToLoadIn = dbNameToLoadIn;
        this.tracker = new TaskTracker(existingTracker);
    }

    public LoadConstraint(Context context, ConstraintEvent event, String dbNameToLoadIn, TaskTracker existingTracker, String dumpDirectory, ReplicationMetricCollector metricCollector) {
        this.context = context;
        this.event = event;
        this.dbNameToLoadIn = dbNameToLoadIn;
        this.tracker = new TaskTracker(existingTracker);
        this.dumpDirectory = dumpDirectory;
        this.metricCollector = metricCollector;
    }

    public TaskTracker tasks() throws IOException, SemanticException {
        URI fromURI = EximUtil.getValidatedURI(this.context.hiveConf, BaseSemanticAnalyzer.stripQuotes(this.event.rootDir().toUri().toString()));
        Path fromPath = new Path(fromURI.getScheme(), fromURI.getAuthority(), fromURI.getPath());
        try {
            DumpMetaData dkDumpMetaData;
            FileSystem fs = FileSystem.get((URI)fromPath.toUri(), (Configuration)this.context.hiveConf);
            JSONObject json = new JSONObject(EximUtil.readAsString(fs, fromPath));
            String pksString = json.getString("pks");
            String fksString = json.getString("fks");
            String uksString = json.getString("uks");
            String nnsString = json.getString("nns");
            String dksString = json.getString("dks");
            String cksString = json.getString("cks");
            ArrayList tasks = new ArrayList();
            if (StringUtils.isNotEmpty((CharSequence)StringUtils.trim((String)pksString)) && !this.isPrimaryKeysAlreadyLoaded(pksString)) {
                AddPrimaryKeyHandler pkHandler = new AddPrimaryKeyHandler();
                DumpMetaData pkDumpMetaData = new DumpMetaData(fromPath, DumpType.EVENT_ADD_PRIMARYKEY, Long.MAX_VALUE, Long.MAX_VALUE, null, this.context.hiveConf);
                pkDumpMetaData.setPayload(pksString);
                tasks.addAll(pkHandler.handle(new MessageHandler.Context(this.dbNameToLoadIn, fromPath.toString(), null, pkDumpMetaData, this.context.hiveConf, this.context.hiveDb, this.context.nestedContext, LOG, this.dumpDirectory, this.metricCollector)));
            }
            if (StringUtils.isNotEmpty((CharSequence)StringUtils.trim((String)uksString)) && !this.isUniqueConstraintsAlreadyLoaded(uksString)) {
                AddUniqueConstraintHandler ukHandler = new AddUniqueConstraintHandler();
                DumpMetaData ukDumpMetaData = new DumpMetaData(fromPath, DumpType.EVENT_ADD_UNIQUECONSTRAINT, Long.MAX_VALUE, Long.MAX_VALUE, null, this.context.hiveConf);
                ukDumpMetaData.setPayload(uksString);
                tasks.addAll(ukHandler.handle(new MessageHandler.Context(this.dbNameToLoadIn, fromPath.toString(), null, ukDumpMetaData, this.context.hiveConf, this.context.hiveDb, this.context.nestedContext, LOG, this.dumpDirectory, this.metricCollector)));
            }
            if (StringUtils.isNotEmpty((CharSequence)StringUtils.trim((String)nnsString)) && !this.isNotNullConstraintsAlreadyLoaded(nnsString)) {
                AddNotNullConstraintHandler nnHandler = new AddNotNullConstraintHandler();
                DumpMetaData nnDumpMetaData = new DumpMetaData(fromPath, DumpType.EVENT_ADD_NOTNULLCONSTRAINT, Long.MAX_VALUE, Long.MAX_VALUE, null, this.context.hiveConf);
                nnDumpMetaData.setPayload(nnsString);
                tasks.addAll(nnHandler.handle(new MessageHandler.Context(this.dbNameToLoadIn, fromPath.toString(), null, nnDumpMetaData, this.context.hiveConf, this.context.hiveDb, this.context.nestedContext, LOG, this.dumpDirectory, this.metricCollector)));
            }
            if (StringUtils.isNotEmpty((CharSequence)StringUtils.trim((String)dksString)) && !this.isDefaultConstraintsAlreadyLoaded(dksString)) {
                AddDefaultConstraintHandler dkHandler = new AddDefaultConstraintHandler();
                dkDumpMetaData = new DumpMetaData(fromPath, DumpType.EVENT_ADD_DEFAULTCONSTRAINT, Long.MAX_VALUE, Long.MAX_VALUE, null, this.context.hiveConf);
                dkDumpMetaData.setPayload(dksString);
                tasks.addAll(dkHandler.handle(new MessageHandler.Context(this.dbNameToLoadIn, fromPath.toString(), null, dkDumpMetaData, this.context.hiveConf, this.context.hiveDb, this.context.nestedContext, LOG, this.dumpDirectory, this.metricCollector)));
            }
            if (StringUtils.isNotEmpty((CharSequence)StringUtils.trim((String)cksString)) && !this.isCheckConstraintsAlreadyLoaded(cksString)) {
                AddCheckConstraintHandler ckHandler = new AddCheckConstraintHandler();
                dkDumpMetaData = new DumpMetaData(fromPath, DumpType.EVENT_ADD_CHECKCONSTRAINT, Long.MAX_VALUE, Long.MAX_VALUE, null, this.context.hiveConf);
                dkDumpMetaData.setPayload(cksString);
                tasks.addAll(ckHandler.handle(new MessageHandler.Context(this.dbNameToLoadIn, fromPath.toString(), null, dkDumpMetaData, this.context.hiveConf, this.context.hiveDb, this.context.nestedContext, LOG, this.dumpDirectory, this.metricCollector)));
            }
            if (StringUtils.isNotEmpty((CharSequence)StringUtils.trim((String)fksString)) && !this.isForeignKeysAlreadyLoaded(fksString)) {
                AddForeignKeyHandler fkHandler = new AddForeignKeyHandler();
                DumpMetaData fkDumpMetaData = new DumpMetaData(fromPath, DumpType.EVENT_ADD_FOREIGNKEY, Long.MAX_VALUE, Long.MAX_VALUE, null, this.context.hiveConf);
                fkDumpMetaData.setPayload(fksString);
                tasks.addAll(fkHandler.handle(new MessageHandler.Context(this.dbNameToLoadIn, fromPath.toString(), null, fkDumpMetaData, this.context.hiveConf, this.context.hiveDb, this.context.nestedContext, LOG, this.dumpDirectory, this.metricCollector)));
            }
            tasks.forEach(this.tracker::addTask);
            return this.tracker;
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), (Throwable)e);
        }
    }

    private boolean isPrimaryKeysAlreadyLoaded(String pksMsgString) throws Exception {
        List<SQLPrimaryKey> pks;
        AddPrimaryKeyMessage msg = this.deserializer.getAddPrimaryKeyMessage(pksMsgString);
        List pksInMsg = msg.getPrimaryKeys();
        if (pksInMsg.isEmpty()) {
            return true;
        }
        String dbName = StringUtils.isBlank((CharSequence)this.dbNameToLoadIn) ? ((SQLPrimaryKey)pksInMsg.get(0)).getTable_db() : this.dbNameToLoadIn;
        try {
            pks = this.context.hiveDb.getPrimaryKeyList(dbName, ((SQLPrimaryKey)pksInMsg.get(0)).getTable_name());
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        return CollectionUtils.isNotEmpty(pks);
    }

    private boolean isForeignKeysAlreadyLoaded(String fksMsgString) throws Exception {
        List<SQLForeignKey> fks;
        AddForeignKeyMessage msg = this.deserializer.getAddForeignKeyMessage(fksMsgString);
        List fksInMsg = msg.getForeignKeys();
        if (fksInMsg.isEmpty()) {
            return true;
        }
        String dbName = StringUtils.isBlank((CharSequence)this.dbNameToLoadIn) ? ((SQLForeignKey)fksInMsg.get(0)).getFktable_db() : this.dbNameToLoadIn;
        try {
            fks = this.context.hiveDb.getForeignKeyList(dbName, ((SQLForeignKey)fksInMsg.get(0)).getFktable_name());
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        return CollectionUtils.isNotEmpty(fks);
    }

    private boolean isUniqueConstraintsAlreadyLoaded(String uksMsgString) throws Exception {
        List<SQLUniqueConstraint> uks;
        AddUniqueConstraintMessage msg = this.deserializer.getAddUniqueConstraintMessage(uksMsgString);
        List uksInMsg = msg.getUniqueConstraints();
        if (uksInMsg.isEmpty()) {
            return true;
        }
        String dbName = StringUtils.isBlank((CharSequence)this.dbNameToLoadIn) ? ((SQLUniqueConstraint)uksInMsg.get(0)).getTable_db() : this.dbNameToLoadIn;
        try {
            uks = this.context.hiveDb.getUniqueConstraintList(dbName, ((SQLUniqueConstraint)uksInMsg.get(0)).getTable_name());
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        return CollectionUtils.isNotEmpty(uks);
    }

    private boolean isNotNullConstraintsAlreadyLoaded(String nnsMsgString) throws Exception {
        List<SQLNotNullConstraint> nns;
        AddNotNullConstraintMessage msg = this.deserializer.getAddNotNullConstraintMessage(nnsMsgString);
        List nnsInMsg = msg.getNotNullConstraints();
        if (nnsInMsg.isEmpty()) {
            return true;
        }
        String dbName = StringUtils.isBlank((CharSequence)this.dbNameToLoadIn) ? ((SQLNotNullConstraint)nnsInMsg.get(0)).getTable_db() : this.dbNameToLoadIn;
        try {
            nns = this.context.hiveDb.getNotNullConstraintList(dbName, ((SQLNotNullConstraint)nnsInMsg.get(0)).getTable_name());
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        return CollectionUtils.isNotEmpty(nns);
    }

    private boolean isCheckConstraintsAlreadyLoaded(String cksMsgString) throws Exception {
        List<SQLCheckConstraint> cks;
        AddCheckConstraintMessage msg = this.deserializer.getAddCheckConstraintMessage(cksMsgString);
        List cksInMsg = msg.getCheckConstraints();
        if (cksInMsg.isEmpty()) {
            return true;
        }
        String dbName = StringUtils.isBlank((CharSequence)this.dbNameToLoadIn) ? ((SQLCheckConstraint)cksInMsg.get(0)).getTable_db() : this.dbNameToLoadIn;
        try {
            cks = this.context.hiveDb.getCheckConstraintList(dbName, ((SQLCheckConstraint)cksInMsg.get(0)).getTable_name());
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        return cks != null && !cks.isEmpty();
    }

    private boolean isDefaultConstraintsAlreadyLoaded(String dksMsgString) throws Exception {
        List<SQLDefaultConstraint> dks;
        AddDefaultConstraintMessage msg = this.deserializer.getAddDefaultConstraintMessage(dksMsgString);
        List dksInMsg = msg.getDefaultConstraints();
        if (dksInMsg.isEmpty()) {
            return true;
        }
        String dbName = StringUtils.isBlank((CharSequence)this.dbNameToLoadIn) ? ((SQLDefaultConstraint)dksInMsg.get(0)).getTable_db() : this.dbNameToLoadIn;
        try {
            dks = this.context.hiveDb.getDefaultConstraintList(dbName, ((SQLDefaultConstraint)dksInMsg.get(0)).getTable_name());
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        return dks != null && !dks.isEmpty();
    }
}

