/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class TruncFloat
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected int scale;

    public TruncFloat() {
    }

    public TruncFloat(int colNum, int scale, int outputColumnNum) {
        super(colNum, outputColumnNum);
        this.scale = scale;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.inputColumnNum[0] + ", scale " + this.scale;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            this.evaluateChildren(batch);
        }
        ColumnVector inputColVector = batch.cols[this.inputColumnNum[0]];
        ColumnVector outputColVector = batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        int n = batch.size;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.trunc(inputColVector, outputColVector, 0);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.trunc(inputColVector, outputColVector, i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.trunc(inputColVector, outputColVector, i);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.trunc(inputColVector, outputColVector, i);
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    this.trunc(inputColVector, outputColVector, i);
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inputColVector.isNull[i]) continue;
                    this.trunc(inputColVector, outputColVector, i);
                }
            }
        }
    }

    protected void trunc(ColumnVector inputColVector, ColumnVector outputColVector, int i) {
        double output;
        BigDecimal input = BigDecimal.valueOf(((DoubleColumnVector)inputColVector).vector[i]);
        ((DoubleColumnVector)outputColVector).vector[i] = output = this.trunc(input).doubleValue();
    }

    protected BigDecimal trunc(BigDecimal input) {
        BigDecimal pow = BigDecimal.valueOf(Math.pow(10.0, Math.abs(this.scale)));
        if (this.scale >= 0) {
            if (this.scale != 0) {
                long longValue = input.multiply(pow).longValue();
                return BigDecimal.valueOf(longValue).divide(pow);
            }
            return BigDecimal.valueOf(input.longValue());
        }
        long longValue2 = input.divide(pow).longValue();
        return BigDecimal.valueOf(longValue2).multiply(pow);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(this.getInputColumnType(), VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR);
        return b.build();
    }

    protected VectorExpressionDescriptor.ArgumentType getInputColumnType() {
        return VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY;
    }
}

