/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.protobuf;

import com.google.protobuf.MessageLite;
import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.hive.ql.io.protobuf.ProtobufMessageInputFormat;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.tez.dag.history.logging.proto.ProtoMessageWritable;

public class LenientProtobufMessageInputFormat<K, V extends MessageLite>
extends ProtobufMessageInputFormat<K, V> {
    @Override
    public RecordReader<K, ProtoMessageWritable<V>> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        RecordReader reader = super.getRecordReader(split, job, reporter);
        return new IgnoreEOFProtoMessageRecordReader(this, reader);
    }

    private class IgnoreEOFProtoMessageRecordReader<K, V extends MessageLite>
    implements RecordReader<K, ProtoMessageWritable<V>> {
        final RecordReader<K, ProtoMessageWritable<V>> mainReader;

        private IgnoreEOFProtoMessageRecordReader(LenientProtobufMessageInputFormat lenientProtobufMessageInputFormat, RecordReader reader) throws IOException {
            this.mainReader = reader;
        }

        public ProtoMessageWritable<V> createValue() {
            return this.mainReader != null ? (ProtoMessageWritable)this.mainReader.createValue() : null;
        }

        public K createKey() {
            return (K)(this.mainReader != null ? this.mainReader.createKey() : null);
        }

        public void close() throws IOException {
            if (this.mainReader != null) {
                this.mainReader.close();
            }
        }

        public long getPos() throws IOException {
            return this.mainReader != null ? this.mainReader.getPos() : 0L;
        }

        public float getProgress() throws IOException {
            return this.mainReader != null ? this.mainReader.getProgress() : 1.0f;
        }

        public boolean next(K arg0, ProtoMessageWritable<V> arg1) throws IOException {
            try {
                return this.mainReader != null ? this.mainReader.next(arg0, arg1) : false;
            }
            catch (EOFException e) {
                FileInputFormat.LOG.warn("Premature EOF while reading proto record at position {}. Returning false.", (Object)(this.mainReader != null ? this.mainReader.getPos() : -1L));
                return false;
            }
        }
    }
}

