/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenMRFileSink1
implements SemanticNodeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger((String)GenMRFileSink1.class.getName());

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, Object ... nodeOutputs) throws SemanticException {
        FetchTask fetchTask;
        FileSinkDesc fileSinkDesc;
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        ParseContext parseCtx = ctx.getParseCtx();
        boolean chDir = false;
        FileSinkOperator fsOp = (FileSinkOperator)nd;
        LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
        GenMRProcContext.GenMapRedCtx mapredCtx = (GenMRProcContext.GenMapRedCtx)mapCurrCtx.get(fsOp.getParentOperators().get(0));
        Task<?> currTask = mapredCtx.getCurrTask();
        ctx.setCurrTask(currTask);
        ctx.addRootIfPossible(currTask);
        boolean isInsertTable = GenMapRedUtils.isInsertInto(parseCtx, fsOp);
        HiveConf hconf = parseCtx.getConf();
        ((MapredWork)currTask.getWork()).setFinalMapRed(true);
        Map<FileSinkDesc, Task<?>> fileSinkDescs = ctx.getLinkedFileDescTasks();
        if (fileSinkDescs != null) {
            Task<?> childTask = fileSinkDescs.get(fsOp.getConf());
            this.processLinkedFileDesc(ctx, childTask);
            return true;
        }
        if (ctx.getSeenFileSinkOps() == null || !ctx.getSeenFileSinkOps().contains(nd)) {
            chDir = GenMapRedUtils.isMergeRequired(ctx.getMvTask(), hconf, fsOp, currTask, isInsertTable);
        }
        Path finalName = this.processFS(fsOp, stack, opProcCtx, chDir);
        if (chDir) {
            LOG.info("using CombineHiveInputformat for the merge job");
            GenMapRedUtils.createMRWorkForMergingFiles(fsOp, finalName, ctx.getDependencyTaskForMultiInsert(), ctx.getMvTask(), hconf, currTask, parseCtx.getQueryState().getLineageState());
        }
        if ((fileSinkDesc = (FileSinkDesc)fsOp.getConf()).isLinkedFileSink() && currTask.getChildTasks() != null && currTask.getChildTasks().size() == 1) {
            Map<FileSinkDesc, Task<?>> linkedFileDescTasks = ctx.getLinkedFileDescTasks();
            if (linkedFileDescTasks == null) {
                linkedFileDescTasks = new HashMap();
                ctx.setLinkedFileDescTasks(linkedFileDescTasks);
            }
            for (FileSinkDesc fileDesc : fileSinkDesc.getLinkedFileSinkDesc()) {
                linkedFileDescTasks.put(fileDesc, currTask.getChildTasks().get(0));
            }
        }
        if ((fetchTask = parseCtx.getFetchTask()) != null && currTask.getNumChild() == 0 && fetchTask.isFetchFrom(fileSinkDesc)) {
            currTask.setFetchSource(true);
        }
        return true;
    }

    private void processLinkedFileDesc(GenMRProcContext ctx, Task<?> childTask) throws SemanticException {
        Task<?> currTask = ctx.getCurrTask();
        TableScanOperator currTopOp = ctx.getCurrTopOp();
        if (currTopOp != null && !ctx.isSeenOp(currTask, currTopOp)) {
            String currAliasId = ctx.getCurrAliasId();
            GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, currTask, false, ctx);
        }
        if (childTask != null) {
            currTask.addDependentTask(childTask);
        }
    }

    private Path processFS(FileSinkOperator fsOp, Stack<Node> stack, NodeProcessorCtx opProcCtx, boolean chDir) throws SemanticException {
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        Task<?> currTask = ctx.getCurrTask();
        Path dest = null;
        List<FileSinkOperator> seenFSOps = ctx.getSeenFileSinkOps();
        if (seenFSOps == null) {
            seenFSOps = new ArrayList<FileSinkOperator>();
        }
        if (!seenFSOps.contains(fsOp)) {
            seenFSOps.add(fsOp);
        }
        ctx.setSeenFileSinkOps(seenFSOps);
        dest = GenMapRedUtils.createMoveTask(ctx.getCurrTask(), chDir, fsOp, ctx.getParseCtx(), ctx.getMvTask(), ctx.getConf(), ctx.getDependencyTaskForMultiInsert());
        TableScanOperator currTopOp = ctx.getCurrTopOp();
        String currAliasId = ctx.getCurrAliasId();
        HashMap<Operator<OperatorDesc>, Task<?>> opTaskMap = ctx.getOpTaskMap();
        if (currTopOp != null) {
            Task<?> mapTask = opTaskMap.get(null);
            if (mapTask == null) {
                if (!ctx.isSeenOp(currTask, currTopOp)) {
                    GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, currTask, false, ctx);
                }
                opTaskMap.put(null, currTask);
            } else if (!ctx.isSeenOp(currTask, currTopOp)) {
                GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, mapTask, false, ctx);
            } else {
                UnionOperator currUnionOp = ctx.getCurrUnionOp();
                if (currUnionOp != null) {
                    opTaskMap.put(null, currTask);
                    ctx.setCurrTopOp(null);
                    GenMapRedUtils.initUnionPlan(ctx, currUnionOp, currTask, false);
                    return dest;
                }
            }
            return dest;
        }
        UnionOperator currUnionOp = ctx.getCurrUnionOp();
        if (currUnionOp != null) {
            opTaskMap.put(null, currTask);
            GenMapRedUtils.initUnionPlan(ctx, currUnionOp, currTask, false);
            return dest;
        }
        return dest;
    }
}

