/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import java.lang.reflect.Method;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.AggregatedColumns;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMetadataQuery;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.MetadataMethod;

public class HiveRelMdAggregatedColumns
implements MetadataHandler<AggregatedColumns> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((MetadataHandler)new HiveRelMdAggregatedColumns(), (Method[])new Method[]{MetadataMethod.AGGREGATED_COLUMNS.method()});

    @Nullable
    public Boolean areColumnsAggregated(Project rel, RelMetadataQuery mq, ImmutableBitSet columns) {
        ImmutableBitSet.Builder iRefs = ImmutableBitSet.builder();
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            int bit = (Integer)iterator.next();
            RexNode e = (RexNode)rel.getProjects().get(bit);
            if (e instanceof RexInputRef) {
                iRefs.set(((RexInputRef)e).getIndex());
                continue;
            }
            return false;
        }
        return ((HiveRelMetadataQuery)mq).areColumnsAggregated(rel.getInput(), iRefs.build());
    }

    @Nullable
    public Boolean areColumnsAggregated(Aggregate aggregate, RelMetadataQuery mq, ImmutableBitSet columns) {
        ImmutableBitSet aggColumns = ImmutableBitSet.range((int)aggregate.getGroupCount(), (int)(aggregate.getGroupCount() + aggregate.getAggCallList().size()));
        return aggColumns.equals((Object)columns);
    }

    @Nullable
    public Boolean areColumnsAggregated(Filter rel, RelMetadataQuery mq, ImmutableBitSet columns) {
        return ((HiveRelMetadataQuery)mq).areColumnsAggregated(rel.getInput(), columns);
    }

    @Nullable
    public Boolean areColumnsAggregated(HepRelVertex rel, RelMetadataQuery mq, ImmutableBitSet columns) {
        return ((HiveRelMetadataQuery)mq).areColumnsAggregated(rel.getCurrentRel(), columns);
    }

    @Nullable
    public Boolean areColumnsAggregated(RelSubset rel, RelMetadataQuery mq, ImmutableBitSet columns) {
        return ((HiveRelMetadataQuery)mq).areColumnsAggregated(rel.getOriginal(), columns);
    }

    @Nullable
    public Boolean areColumnsAggregated(RelNode rel, RelMetadataQuery mq, ImmutableBitSet columns) {
        return null;
    }

    public MetadataDef<AggregatedColumns> getDef() {
        return AggregatedColumns.DEF;
    }
}

