/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.rewrite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeStatement {
    protected static final Logger LOG = LoggerFactory.getLogger(MergeStatement.class);
    private final Table targetTable;
    private final String targetName;
    private final String targetAlias;
    private final String sourceName;
    private final String sourceAlias;
    private final String onClausePredicate;
    private final String onClauseAsText;
    private final String hintStr;
    private final List<WhenClause> whenClauses;

    public static MergeStatementBuilder withTarget(Table targetTable, String targetName, String targetAlias) {
        return new MergeStatementBuilder(targetTable, targetName, targetAlias);
    }

    private MergeStatement(Table targetTable, String targetName, String targetAlias, String sourceName, String sourceAlias, String onClausePredicate, String onClauseAsText, String hintStr, List<WhenClause> whenClauses) {
        this.targetTable = targetTable;
        this.targetName = targetName;
        this.targetAlias = targetAlias;
        this.sourceName = sourceName;
        this.sourceAlias = sourceAlias;
        this.onClausePredicate = onClausePredicate;
        this.onClauseAsText = onClauseAsText;
        this.hintStr = hintStr;
        this.whenClauses = whenClauses;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getTargetAlias() {
        return this.targetAlias;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getSourceAlias() {
        return this.sourceAlias;
    }

    public String getOnClausePredicate() {
        return this.onClausePredicate;
    }

    public String getOnClauseAsText() {
        return this.onClauseAsText;
    }

    public String getHintStr() {
        return this.hintStr;
    }

    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    public boolean hasWhenNotMatchedInsertClause() {
        for (WhenClause whenClause : this.whenClauses) {
            if (!(whenClause instanceof InsertClause)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldValidateCardinalityViolation(HiveConf conf) {
        if (!conf.getBoolVar(HiveConf.ConfVars.MERGE_CARDINALITY_VIOLATION_CHECK)) {
            LOG.info("Merge statement cardinality violation check is disabled: {}", (Object)HiveConf.ConfVars.MERGE_CARDINALITY_VIOLATION_CHECK.varname);
            return false;
        }
        boolean onlyHaveWhenNotMatchedClause = this.whenClauses.size() == 1 && this.whenClauses.get(0) instanceof InsertClause;
        return !onlyHaveWhenNotMatchedClause;
    }

    public static class MergeStatementBuilder {
        private final Table targetTable;
        private final String targetName;
        private final String targetAlias;
        private String sourceName;
        private String sourceAlias;
        private String onClausePredicate;
        private String onClauseAsText;
        private String hintStr;
        private final List<WhenClause> whenClauses;

        private MergeStatementBuilder(Table targetTable, String targetName, String targetAlias) {
            this.targetTable = targetTable;
            this.targetName = targetName;
            this.targetAlias = targetAlias;
            this.whenClauses = new ArrayList<WhenClause>(3);
        }

        public MergeStatementBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public MergeStatementBuilder sourceAlias(String sourceAlias) {
            this.sourceAlias = sourceAlias;
            return this;
        }

        public MergeStatementBuilder onClausePredicate(String onClausePredicate) {
            this.onClausePredicate = onClausePredicate;
            return this;
        }

        public MergeStatementBuilder onClauseAsText(String onClauseAsText) {
            this.onClauseAsText = onClauseAsText;
            return this;
        }

        public MergeStatementBuilder hintStr(String hintStr) {
            this.hintStr = hintStr;
            return this;
        }

        public MergeStatementBuilder addWhenClause(WhenClause whenClause) {
            this.whenClauses.add(whenClause);
            return this;
        }

        public MergeStatement build() {
            return new MergeStatement(this.targetTable, this.targetName, this.targetAlias, this.sourceName, this.sourceAlias, this.onClausePredicate, this.onClauseAsText, this.hintStr, Collections.unmodifiableList(this.whenClauses));
        }
    }

    protected static abstract class WhenClause {
        private final String extraPredicate;

        public WhenClause(String extraPredicate) {
            this.extraPredicate = extraPredicate;
        }

        public String getExtraPredicate() {
            return this.extraPredicate;
        }

        public abstract void toSql(MergeSqlGenerator var1);

        public abstract int addDestNamePrefixOfInsert(DestClausePrefixSetter var1, int var2, Context var3);
    }

    public static class InsertClause
    extends WhenClause {
        private final List<String> columnList;
        private final List<String> valuesClause;
        private final String predicate;

        public InsertClause(List<String> columnList, List<String> valuesClause, String predicate, String extraPredicate) {
            super(extraPredicate);
            this.predicate = predicate;
            this.columnList = columnList;
            this.valuesClause = valuesClause;
        }

        public List<String> getColumnList() {
            return this.columnList;
        }

        public List<String> getValuesClause() {
            return this.valuesClause;
        }

        public String getPredicate() {
            return this.predicate;
        }

        @Override
        public void toSql(MergeSqlGenerator sqlGenerator) {
            sqlGenerator.appendWhenNotMatchedInsertClause(this);
        }

        @Override
        public int addDestNamePrefixOfInsert(DestClausePrefixSetter setter, int pos, Context context) {
            return setter.addDestNamePrefixOfInsert(pos, context);
        }
    }

    public static interface DestClausePrefixSetter {
        default public int addDestNamePrefixOfInsert(int pos, Context context) {
            context.addDestNamePrefix(pos, Context.DestClausePrefix.INSERT);
            return 1;
        }

        default public int addDestNamePrefixOfUpdate(int pos, Context context) {
            context.addDestNamePrefix(pos, Context.DestClausePrefix.UPDATE);
            return 1;
        }

        default public int addDestNamePrefixOfDelete(int pos, Context context) {
            context.addDestNamePrefix(pos, Context.DestClausePrefix.DELETE);
            return 1;
        }
    }

    public static interface MergeSqlGenerator {
        public void appendWhenNotMatchedInsertClause(InsertClause var1);

        public void appendWhenMatchedUpdateClause(UpdateClause var1);

        public void appendWhenMatchedDeleteClause(DeleteClause var1);
    }

    public static class DeleteClause
    extends WhenClause {
        private final String updateExtraPredicate;

        public DeleteClause(String extraPredicate, String updateExtraPredicate) {
            super(extraPredicate);
            this.updateExtraPredicate = updateExtraPredicate;
        }

        public String getUpdateExtraPredicate() {
            return this.updateExtraPredicate;
        }

        @Override
        public void toSql(MergeSqlGenerator sqlGenerator) {
            sqlGenerator.appendWhenMatchedDeleteClause(this);
        }

        @Override
        public int addDestNamePrefixOfInsert(DestClausePrefixSetter setter, int pos, Context context) {
            return setter.addDestNamePrefixOfDelete(pos, context);
        }
    }

    public static class UpdateClause
    extends WhenClause {
        private final Map<String, String> newValuesMap;
        private final String deleteExtraPredicate;

        public UpdateClause(String extraPredicate, String deleteExtraPredicate, Map<String, String> newValuesMap) {
            super(extraPredicate);
            this.newValuesMap = newValuesMap;
            this.deleteExtraPredicate = deleteExtraPredicate;
        }

        public Map<String, String> getNewValuesMap() {
            return this.newValuesMap;
        }

        public String getDeleteExtraPredicate() {
            return this.deleteExtraPredicate;
        }

        @Override
        public void toSql(MergeSqlGenerator sqlGenerator) {
            sqlGenerator.appendWhenMatchedUpdateClause(this);
        }

        @Override
        public int addDestNamePrefixOfInsert(DestClausePrefixSetter setter, int pos, Context context) {
            return setter.addDestNamePrefixOfUpdate(pos, context);
        }
    }
}

