/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.util.ReflectionUtils;

public class AggregationDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String genericUDAFName;
    private List<ExprNodeDesc> parameters;
    private boolean distinct;
    private GenericUDAFEvaluator.Mode mode;
    private String genericUDAFEvaluatorClassName;
    private GenericUDAFEvaluator genericUDAFWritableEvaluator;
    private transient GenericUDAFEvaluator genericUDAFEvaluator;

    public AggregationDesc() {
    }

    public AggregationDesc(String genericUDAFName, GenericUDAFEvaluator genericUDAFEvaluator, List<ExprNodeDesc> parameters, boolean distinct, GenericUDAFEvaluator.Mode mode) {
        this.genericUDAFName = genericUDAFName;
        this.parameters = parameters;
        this.distinct = distinct;
        this.mode = mode;
        this.setGenericUDAFEvaluator(genericUDAFEvaluator);
    }

    public void setGenericUDAFName(String genericUDAFName) {
        this.genericUDAFName = genericUDAFName;
    }

    public String getGenericUDAFName() {
        return this.genericUDAFName;
    }

    public void setGenericUDAFEvaluator(GenericUDAFEvaluator genericUDAFEvaluator) {
        this.genericUDAFEvaluator = genericUDAFEvaluator;
        if (genericUDAFEvaluator instanceof Serializable) {
            this.genericUDAFWritableEvaluator = genericUDAFEvaluator;
        } else {
            this.genericUDAFEvaluatorClassName = genericUDAFEvaluator.getClass().getName();
        }
    }

    public GenericUDAFEvaluator getGenericUDAFEvaluator() {
        if (this.genericUDAFEvaluator != null) {
            return this.genericUDAFEvaluator;
        }
        if (this.genericUDAFWritableEvaluator != null) {
            this.genericUDAFEvaluator = this.genericUDAFWritableEvaluator;
            return this.genericUDAFEvaluator;
        }
        try {
            this.genericUDAFEvaluator = (GenericUDAFEvaluator)ReflectionUtils.newInstance(Class.forName(this.genericUDAFEvaluatorClassName, true, Utilities.getSessionSpecifiedClassLoader()).asSubclass(GenericUDAFEvaluator.class), null);
            return this.genericUDAFEvaluator;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getGenericUDAFEvaluatorClassName() {
        return this.genericUDAFEvaluatorClassName;
    }

    public void setGenericUDAFEvaluatorClassName(String genericUDAFEvaluatorClassName) {
        this.genericUDAFEvaluatorClassName = genericUDAFEvaluatorClassName;
    }

    public GenericUDAFEvaluator getGenericUDAFWritableEvaluator() {
        return this.genericUDAFWritableEvaluator;
    }

    public void setGenericUDAFWritableEvaluator(GenericUDAFEvaluator genericUDAFWritableEvaluator) {
        this.genericUDAFWritableEvaluator = genericUDAFWritableEvaluator;
    }

    public List<ExprNodeDesc> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ExprNodeDesc> parameters) {
        this.parameters = parameters;
    }

    public boolean getDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setMode(GenericUDAFEvaluator.Mode mode) {
        this.mode = mode;
    }

    public GenericUDAFEvaluator.Mode getMode() {
        return this.mode;
    }

    public String getExprString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.genericUDAFName);
        sb.append("(");
        if (this.distinct) {
            sb.append("DISTINCT ");
        }
        boolean first = true;
        for (ExprNodeDesc exp : this.parameters) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(exp.getExprString());
        }
        String evaluatorExpr = this.getGenericUDAFEvaluator().getExprString();
        if (evaluatorExpr != null && !evaluatorExpr.isEmpty()) {
            sb.append(", ");
            sb.append(evaluatorExpr);
        }
        sb.append(")");
        return sb.toString();
    }
}

