/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.events.PreAlterTableEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateTableEvent;
import org.apache.hadoop.hive.metastore.events.PreDropTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.security.HiveMetastoreAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactoryImpl;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObjectUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.AlterDataConnectorEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.AlterDatabaseEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.CreateDataConnectorEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.CreateFunctionEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.DropDataConnectorEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.DropFunctionEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.LoadPartitionDoneEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.ReadDatabaseEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.ReadTableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.filtercontext.DataConnectorFilterContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.filtercontext.DatabaseFilterContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.filtercontext.TableFilterContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStoreAuthorizer
extends MetaStorePreEventListener
implements MetaStoreFilterHook {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMetaStoreAuthorizer.class);
    private static final ThreadLocal<Map<String, Object>> cConfig = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return null;
        }
    };
    private static final ThreadLocal<Configuration> tConfig = new ThreadLocal<Configuration>(){

        @Override
        protected Configuration initialValue() {
            return null;
        }
    };
    private static final ThreadLocal<HiveMetastoreAuthenticationProvider> tAuthenticator = new ThreadLocal<HiveMetastoreAuthenticationProvider>(){

        @Override
        protected HiveMetastoreAuthenticationProvider initialValue() {
            try {
                return (HiveMetastoreAuthenticationProvider)HiveUtils.getAuthenticator(tConfig.get(), HiveConf.ConfVars.HIVE_METASTORE_AUTHENTICATOR_MANAGER);
            }
            catch (HiveException excp) {
                throw new IllegalStateException("Authentication provider instantiation failure", excp);
            }
        }
    };

    public static void setClientConfig(Map<String, Object> map) {
        cConfig.set(map);
    }

    public static Map<String, Object> getClientConfig() {
        return cConfig.get();
    }

    public HiveMetaStoreAuthorizer(Configuration config) {
        super(config);
    }

    public final void onEvent(PreEventContext preEventContext) throws MetaException, NoSuchObjectException, InvalidOperationException {
        LOG.debug("==> HiveMetaStoreAuthorizer.onEvent(): EventType=" + String.valueOf(preEventContext.getEventType()));
        try {
            HiveMetaStoreAuthzInfo authzContext = this.buildAuthzContext(preEventContext);
            if (!this.skipAuthorization(authzContext)) {
                HiveAuthorizer hiveAuthorizer = this.createHiveMetaStoreAuthorizer();
                this.checkPrivileges(authzContext, hiveAuthorizer);
            }
        }
        catch (Exception e) {
            LOG.error("HiveMetaStoreAuthorizer.onEvent(): failed", (Throwable)e);
            throw MetaStoreUtils.newMetaException((Exception)e);
        }
        LOG.debug("<== HiveMetaStoreAuthorizer.onEvent(): EventType=" + String.valueOf(preEventContext.getEventType()));
    }

    public final List<String> filterDatabases(String catName, List<String> list) throws MetaException {
        LOG.debug("HiveMetaStoreAuthorizer.filterDatabases()");
        if (list == null) {
            return Collections.emptyList();
        }
        DatabaseFilterContext databaseFilterContext = new DatabaseFilterContext(catName, list);
        HiveMetaStoreAuthzInfo hiveMetaStoreAuthzInfo = databaseFilterContext.getAuthzContext();
        List<String> filteredDatabases = this.filterDatabaseObjects(hiveMetaStoreAuthzInfo);
        if (CollectionUtils.isEmpty(filteredDatabases)) {
            filteredDatabases = Collections.emptyList();
        }
        LOG.debug("HiveMetaStoreAuthorizer.filterDatabases() :" + String.valueOf(filteredDatabases));
        return filteredDatabases;
    }

    public final Database filterDatabase(Database database) throws MetaException, NoSuchObjectException {
        if (database != null) {
            String dbName = database.getName();
            List<String> databases = this.filterDatabases(database.getCatalogName(), Collections.singletonList(dbName));
            if (databases.isEmpty()) {
                throw new NoSuchObjectException(String.format("Database %s does not exist", dbName));
            }
        }
        return database;
    }

    public final List<String> filterTableNames(String catName, String dbName, List<String> tableList) throws MetaException {
        TableFilterContext tableFilterContext;
        HiveMetaStoreAuthzInfo hiveMetaStoreAuthzInfo;
        LOG.debug("==> HiveMetaStoreAuthorizer.filterTableNames()");
        List<String> filteredTableNames = null;
        if (tableList != null && CollectionUtils.isEmpty(filteredTableNames = this.filterTableNames(hiveMetaStoreAuthzInfo = (tableFilterContext = new TableFilterContext(catName, dbName, tableList)).getAuthzContext(), catName, dbName, tableList))) {
            filteredTableNames = Collections.emptyList();
        }
        LOG.debug("<== HiveMetaStoreAuthorizer.filterTableNames() : " + String.valueOf(filteredTableNames));
        return filteredTableNames;
    }

    public final Table filterTable(Table table) throws MetaException, NoSuchObjectException {
        List<Table> tables;
        if (table != null && (tables = this.filterTables(Collections.singletonList(table))).isEmpty()) {
            throw new NoSuchObjectException(String.format("Database %s does not exist", table.getTableName()));
        }
        return table;
    }

    public final List<Table> filterTables(List<Table> list) throws MetaException {
        TableFilterContext tableFilterContext;
        HiveMetaStoreAuthzInfo hiveMetaStoreAuthzInfo;
        LOG.debug("==> HiveMetaStoreAuthorizer.filterTables()");
        List<Object> filteredTables = null;
        if (list != null && CollectionUtils.isEmpty(filteredTables = this.filterTableObjects(hiveMetaStoreAuthzInfo = (tableFilterContext = new TableFilterContext(list)).getAuthzContext(), list))) {
            filteredTables = Collections.emptyList();
        }
        LOG.debug("<== HiveMetaStoreAuthorizer.filterTables(): " + String.valueOf(filteredTables));
        return filteredTables;
    }

    public final Catalog filterCatalog(Catalog catalog) throws MetaException {
        return catalog;
    }

    public final List<String> filterCatalogs(List<String> catalogs) throws MetaException {
        return catalogs;
    }

    @Deprecated
    public List<TableMeta> filterTableMetas(String catName, String dbName, List<TableMeta> tableMetas) throws MetaException {
        LOG.debug("==> HiveMetaStoreAuthorizer.filterTableMetas()");
        if (!CollectionUtils.isEmpty(tableMetas)) {
            ArrayList<String> tableNames = new ArrayList<String>();
            tableMetas.forEach(tableMeta -> {
                if (!tableMeta.getCatName().equalsIgnoreCase(catName) || !tableMeta.getDbName().equalsIgnoreCase(dbName)) {
                    throw new IllegalArgumentException(String.format("Table: %s doesn't belong to the catalog: %s, database: %s", tableMeta.getCatName() + "." + tableMeta.getDbName() + "." + tableMeta.getTableName(), catName, dbName));
                }
                tableNames.add(tableMeta.getTableName());
            });
            TableFilterContext tableFilterContext = TableFilterContext.createFromTableMetas(dbName, tableMetas);
            HiveMetaStoreAuthzInfo hiveMetaStoreAuthzInfo = tableFilterContext.getAuthzContext();
            List<String> filteredTableNames = this.filterTableNames(hiveMetaStoreAuthzInfo, catName, dbName, tableNames);
            if (!CollectionUtils.isEmpty(filteredTableNames)) {
                HashSet<String> filteredTabs = new HashSet<String>(filteredTableNames);
                LOG.debug("<== HiveMetaStoreAuthorizer.filterTableMetas() : {}", filteredTabs);
                return tableMetas.stream().filter(tblMeta -> filteredTabs.contains(tblMeta.getTableName())).collect(Collectors.toList());
            }
        }
        LOG.info("<== HiveMetaStoreAuthorizer.filterTableMetas() : returning empty set");
        return Collections.emptyList();
    }

    public final List<TableMeta> filterTableMetas(List<TableMeta> tableMetas) throws MetaException {
        LOG.debug("==> HiveMetaStoreAuthorizer.filterTableMetas()");
        if (!CollectionUtils.isEmpty(tableMetas)) {
            HashMap metaGroupByCatDb = new HashMap();
            tableMetas.forEach(tableMeta -> {
                String key = MetaStoreUtils.prependCatalogToDbName((String)tableMeta.getCatName(), (String)tableMeta.getDbName(), (Configuration)this.getConf()).toLowerCase();
                metaGroupByCatDb.computeIfAbsent(key, s -> new ArrayList()).add(tableMeta);
            });
            ArrayList<TableMeta> filteredTabs = new ArrayList<TableMeta>();
            for (Map.Entry entry : metaGroupByCatDb.entrySet()) {
                TableMeta firstTabMeta = (TableMeta)((List)entry.getValue()).get(0);
                filteredTabs.addAll(this.filterTableMetas(firstTabMeta.getCatName(), firstTabMeta.getDbName(), (List)entry.getValue()));
            }
            return filteredTabs;
        }
        LOG.info("<== HiveMetaStoreAuthorizer.filterTableMetas() : returning empty set");
        return Collections.emptyList();
    }

    public final List<Partition> filterPartitions(List<Partition> list) throws MetaException {
        return list;
    }

    public final List<PartitionSpec> filterPartitionSpecs(List<PartitionSpec> list) throws MetaException {
        return list;
    }

    public final Partition filterPartition(Partition partition) throws MetaException, NoSuchObjectException {
        return partition;
    }

    public final List<String> filterPartitionNames(String catName, String dbName, String tblName, List<String> partitionNames) throws MetaException {
        return partitionNames;
    }

    public List<String> filterDataConnectors(List<String> dcList) throws MetaException {
        LOG.debug("HiveMetaStoreAuthorizer.filterDataConnector()");
        if (dcList == null) {
            return Collections.emptyList();
        }
        DataConnectorFilterContext dataConnectorFilterContext = new DataConnectorFilterContext(dcList);
        HiveMetaStoreAuthzInfo hiveMetaStoreAuthzInfo = dataConnectorFilterContext.getAuthzContext();
        List<String> filteredDataConnector = this.filterDataConnectorObjects(hiveMetaStoreAuthzInfo);
        if (CollectionUtils.isEmpty(filteredDataConnector)) {
            filteredDataConnector = Collections.emptyList();
        }
        LOG.debug("HiveMetaStoreAuthorizer.filterDataConnectors() :" + String.valueOf(filteredDataConnector));
        return filteredDataConnector;
    }

    private List<String> filterDatabaseObjects(HiveMetaStoreAuthzInfo hiveMetaStoreAuthzInfo) throws MetaException {
        List<String> ret = null;
        LOG.debug("==> HiveMetaStoreAuthorizer.filterDatabaseObjects()");
        try {
            List<HivePrivilegeObject> filteredHivePrivilegeObjects;
            HiveAuthorizer hiveAuthorizer = this.createHiveMetaStoreAuthorizer();
            List<HivePrivilegeObject> hivePrivilegeObjects = hiveMetaStoreAuthzInfo.getInputHObjs();
            HiveAuthzContext hiveAuthzContext = hiveMetaStoreAuthzInfo.getHiveAuthzContext();
            Map<String, Object> clientConfig = cConfig.get();
            if (clientConfig != null) {
                HiveAuthzContext.Builder builder = new HiveAuthzContext.Builder();
                builder.setClientConfig(clientConfig);
                if (hiveAuthzContext != null) {
                    builder.setCommandString(hiveAuthzContext.getCommandString());
                    builder.setUserIpAddress(hiveAuthzContext.getIpAddress());
                    builder.setForwardedAddresses(hiveAuthzContext.getForwardedAddresses());
                }
                hiveAuthzContext = builder.build();
            }
            if (CollectionUtils.isNotEmpty(filteredHivePrivilegeObjects = hiveAuthorizer.filterListCmdObjects(hivePrivilegeObjects, hiveAuthzContext))) {
                ret = this.getFilteredDatabaseList(filteredHivePrivilegeObjects);
            }
            LOG.info(String.format("Filtered %d databases out of %d", filteredHivePrivilegeObjects.size(), hivePrivilegeObjects.size()));
        }
        catch (Exception e) {
            throw new MetaException("Error in HiveMetaStoreAuthorizer.filterDatabase()" + e.getMessage());
        }
        LOG.debug("<== HiveMetaStoreAuthorizer.filterDatabaseObjects() :" + String.valueOf(ret));
        return ret;
    }

    public final List<Database> filterDatabaseObjects(List<Database> databases) throws MetaException {
        LOG.debug("==> HiveMetaStoreAuthorizer.filterDatabaseObjects()");
        if (CollectionUtils.isEmpty(databases)) {
            return Collections.emptyList();
        }
        try {
            DatabaseFilterContext databaseFilterContext = DatabaseFilterContext.createFromDatabases(databases);
            HiveMetaStoreAuthzInfo hiveMetaStoreAuthzInfo = databaseFilterContext.getAuthzContext();
            HiveAuthorizer hiveAuthorizer = this.createHiveMetaStoreAuthorizer();
            List<HivePrivilegeObject> hivePrivilegeObjects = hiveMetaStoreAuthzInfo.getInputHObjs();
            HiveAuthzContext hiveAuthzContext = hiveMetaStoreAuthzInfo.getHiveAuthzContext();
            List<HivePrivilegeObject> filteredHivePrivilegeObjects = hiveAuthorizer.filterListCmdObjects(hivePrivilegeObjects, hiveAuthzContext);
            if (CollectionUtils.isEmpty(filteredHivePrivilegeObjects)) {
                List<Database> list = Collections.emptyList();
                return list;
            }
            Set filteredDbNames = filteredHivePrivilegeObjects.stream().map(HivePrivilegeObject::getDbname).collect(Collectors.toSet());
            List<Database> result = databases.stream().filter(db -> filteredDbNames.contains(db.getName())).collect(Collectors.toList());
            LOG.info(String.format("Filtered %d database objects out of %d", result.size(), databases.size()));
            List<Database> list = result;
            return list;
        }
        catch (Exception e) {
            LOG.error("Error in HiveMetaStoreAuthorizer.filterDatabaseObjects(): " + e.getMessage(), (Throwable)e);
            throw new MetaException("Error in HiveMetaStoreAuthorizer.filterDatabaseObjects(): " + e.getMessage());
        }
        finally {
            LOG.debug("<== HiveMetaStoreAuthorizer.filterDatabaseObjects()");
        }
    }

    private List<String> filterDataConnectorObjects(HiveMetaStoreAuthzInfo hiveMetaStoreAuthzInfo) throws MetaException {
        List<String> ret = null;
        LOG.debug("==> HiveMetaStoreAuthorizer.filterDataConnectorObjects()");
        try {
            HiveAuthorizer hiveAuthorizer = this.createHiveMetaStoreAuthorizer();
            List<HivePrivilegeObject> hivePrivilegeObjects = hiveMetaStoreAuthzInfo.getInputHObjs();
            HiveAuthzContext hiveAuthzContext = hiveMetaStoreAuthzInfo.getHiveAuthzContext();
            List<HivePrivilegeObject> filteredHivePrivilegeObjects = hiveAuthorizer.filterListCmdObjects(hivePrivilegeObjects, hiveAuthzContext);
            if (CollectionUtils.isNotEmpty(filteredHivePrivilegeObjects)) {
                ret = this.getFilteredDataConnectorList(filteredHivePrivilegeObjects);
            }
            LOG.info(String.format("Filtered %d connectors out of %d", filteredHivePrivilegeObjects.size(), hivePrivilegeObjects.size()));
        }
        catch (Exception e) {
            throw new MetaException("Error in HiveMetaStoreAuthorizer.filterDataConnector()" + e.getMessage());
        }
        LOG.debug("<== HiveMetaStoreAuthorizer.filterDataConnectorObjects() :" + String.valueOf(ret));
        return ret;
    }

    private List<String> getFilteredDataConnectorList(List<HivePrivilegeObject> hivePrivilegeObjects) {
        ArrayList<String> ret = new ArrayList<String>();
        for (HivePrivilegeObject hivePrivilegeObject : hivePrivilegeObjects) {
            String dcName = hivePrivilegeObject.getObjectName();
            ret.add(dcName);
        }
        return ret;
    }

    private List<Table> filterTableObjects(HiveMetaStoreAuthzInfo hiveMetaStoreAuthzInfo, List<Table> tableList) throws MetaException {
        List<Table> ret = null;
        try {
            HiveAuthorizer hiveAuthorizer = this.createHiveMetaStoreAuthorizer();
            List<HivePrivilegeObject> hivePrivilegeObjects = hiveMetaStoreAuthzInfo.getInputHObjs();
            HiveAuthzContext hiveAuthzContext = hiveMetaStoreAuthzInfo.getHiveAuthzContext();
            List<HivePrivilegeObject> filteredHivePrivilegeObjects = hiveAuthorizer.filterListCmdObjects(hivePrivilegeObjects, hiveAuthzContext);
            if (CollectionUtils.isNotEmpty(filteredHivePrivilegeObjects)) {
                ret = this.getFilteredTableList(filteredHivePrivilegeObjects, tableList);
            }
            LOG.info(String.format("Filtered %d tables out of %d", filteredHivePrivilegeObjects.size(), hivePrivilegeObjects.size()));
        }
        catch (Exception e) {
            throw new MetaException("Error in HiveMetaStoreAuthorizer.filterTables()" + e.getMessage());
        }
        return ret;
    }

    private List<String> getFilteredDatabaseList(List<HivePrivilegeObject> hivePrivilegeObjects) {
        ArrayList<String> ret = new ArrayList<String>();
        for (HivePrivilegeObject hivePrivilegeObject : hivePrivilegeObjects) {
            String dbName = hivePrivilegeObject.getDbname();
            ret.add(dbName);
        }
        return ret;
    }

    private List<Table> getFilteredTableList(List<HivePrivilegeObject> hivePrivilegeObjects, List<Table> tableList) {
        ArrayList<Table> ret = new ArrayList<Table>();
        HivePrivilegeObjectUtils.TablePrivilegeLookup index = new HivePrivilegeObjectUtils.TablePrivilegeLookup(hivePrivilegeObjects);
        for (Table table : tableList) {
            if (index.lookup(table.getCatName(), table.getDbName(), table.getTableName()) == null) continue;
            ret.add(table);
        }
        return ret;
    }

    private List<String> filterTableNames(HiveMetaStoreAuthzInfo hiveMetaStoreAuthzInfo, String catName, String dbName, List<String> tableNames) throws MetaException {
        List<String> ret = null;
        try {
            List<HivePrivilegeObject> filteredHivePrivilegeObjects;
            HiveAuthorizer hiveAuthorizer = this.createHiveMetaStoreAuthorizer();
            List<HivePrivilegeObject> hivePrivilegeObjects = hiveMetaStoreAuthzInfo.getInputHObjs();
            HiveAuthzContext hiveAuthzContext = hiveMetaStoreAuthzInfo.getHiveAuthzContext();
            Map<String, Object> clientConfig = cConfig.get();
            if (clientConfig != null) {
                HiveAuthzContext.Builder builder = new HiveAuthzContext.Builder();
                builder.setClientConfig(clientConfig);
                if (hiveAuthzContext != null) {
                    builder.setCommandString(hiveAuthzContext.getCommandString());
                    builder.setUserIpAddress(hiveAuthzContext.getIpAddress());
                    builder.setForwardedAddresses(hiveAuthzContext.getForwardedAddresses());
                }
                hiveAuthzContext = builder.build();
            }
            if (CollectionUtils.isNotEmpty(filteredHivePrivilegeObjects = hiveAuthorizer.filterListCmdObjects(hivePrivilegeObjects, hiveAuthzContext))) {
                ret = this.getFilteredTableNames(filteredHivePrivilegeObjects, catName, dbName, tableNames);
            }
            LOG.info(String.format("Filtered %d table names out of %d", filteredHivePrivilegeObjects.size(), hivePrivilegeObjects.size()));
        }
        catch (Exception e) {
            throw new MetaException("Error in HiveMetaStoreAuthorizer.filterTables()" + e.getMessage());
        }
        return ret;
    }

    private List<String> getFilteredTableNames(List<HivePrivilegeObject> hivePrivilegeObjects, String catalogName, String databaseName, List<String> tableNames) {
        ArrayList<String> ret = new ArrayList<String>();
        HivePrivilegeObjectUtils.TablePrivilegeLookup index = new HivePrivilegeObjectUtils.TablePrivilegeLookup(hivePrivilegeObjects);
        for (String tableName : tableNames) {
            if (index.lookup(catalogName, databaseName, tableName) == null) continue;
            ret.add(tableName);
        }
        return ret;
    }

    private String getDBName(String str) {
        return str != null ? str.substring(str.indexOf("#") + 1) : null;
    }

    HiveMetaStoreAuthzInfo buildAuthzContext(PreEventContext preEventContext) throws MetaException {
        LOG.debug("==> HiveMetaStoreAuthorizer.buildAuthzContext(): EventType=" + String.valueOf(preEventContext.getEventType()));
        HiveMetaStoreAuthorizableEvent authzEvent = null;
        if (preEventContext != null) {
            switch (preEventContext.getEventType()) {
                case CREATE_DATABASE: {
                    authzEvent = new CreateDatabaseEvent(preEventContext);
                    break;
                }
                case ALTER_DATABASE: {
                    authzEvent = new AlterDatabaseEvent(preEventContext);
                    break;
                }
                case DROP_DATABASE: {
                    authzEvent = new DropDatabaseEvent(preEventContext);
                    break;
                }
                case CREATE_TABLE: {
                    authzEvent = new CreateTableEvent(preEventContext);
                    if (!this.isViewOperation(preEventContext) || this.isSuperUser(this.getCurrentUser(authzEvent))) break;
                    PreCreateTableEvent pcte = (PreCreateTableEvent)preEventContext;
                    Map params = pcte.getTable().getParameters();
                    params.put("Authorized", "false");
                    break;
                }
                case ALTER_TABLE: {
                    authzEvent = new AlterTableEvent(preEventContext);
                    if (!this.isViewOperation(preEventContext) || this.isSuperUser(this.getCurrentUser(authzEvent))) break;
                    PreCreateTableEvent pcte = (PreAlterTableEvent)preEventContext;
                    Map params = pcte.getNewTable().getParameters();
                    params.put("Authorized", "false");
                    break;
                }
                case DROP_TABLE: {
                    authzEvent = new DropTableEvent(preEventContext);
                    if (!this.isViewOperation(preEventContext) || this.isSuperUser(this.getCurrentUser(authzEvent))) break;
                    break;
                }
                case ADD_PARTITION: {
                    authzEvent = new AddPartitionEvent(preEventContext);
                    break;
                }
                case ALTER_PARTITION: {
                    authzEvent = new AlterPartitionEvent(preEventContext);
                    break;
                }
                case LOAD_PARTITION_DONE: {
                    authzEvent = new LoadPartitionDoneEvent(preEventContext);
                    break;
                }
                case DROP_PARTITION: {
                    authzEvent = new DropPartitionEvent(preEventContext);
                    break;
                }
                case READ_TABLE: {
                    authzEvent = new ReadTableEvent(preEventContext);
                    break;
                }
                case READ_DATABASE: {
                    authzEvent = new ReadDatabaseEvent(preEventContext);
                    break;
                }
                case CREATE_FUNCTION: {
                    authzEvent = new CreateFunctionEvent(preEventContext);
                    break;
                }
                case DROP_FUNCTION: {
                    authzEvent = new DropFunctionEvent(preEventContext);
                    break;
                }
                case CREATE_DATACONNECTOR: {
                    authzEvent = new CreateDataConnectorEvent(preEventContext);
                    break;
                }
                case ALTER_DATACONNECTOR: {
                    authzEvent = new AlterDataConnectorEvent(preEventContext);
                    break;
                }
                case DROP_DATACONNECTOR: {
                    authzEvent = new DropDataConnectorEvent(preEventContext);
                    break;
                }
                case AUTHORIZATION_API_CALL: 
                case READ_ISCHEMA: 
                case CREATE_ISCHEMA: 
                case DROP_ISCHEMA: 
                case ALTER_ISCHEMA: 
                case ADD_SCHEMA_VERSION: 
                case ALTER_SCHEMA_VERSION: 
                case DROP_SCHEMA_VERSION: 
                case READ_SCHEMA_VERSION: 
                case CREATE_CATALOG: 
                case ALTER_CATALOG: 
                case DROP_CATALOG: {
                    if (this.isSuperUser(this.getCurrentUser())) break;
                    throw new MetaException(this.getErrorMessage(preEventContext, this.getCurrentUser()));
                }
            }
        }
        HiveMetaStoreAuthzInfo ret = authzEvent != null ? authzEvent.getAuthzContext() : null;
        LOG.debug("<== HiveMetaStoreAuthorizer.buildAuthzContext(): EventType=" + String.valueOf(preEventContext.getEventType()) + "; ret=" + String.valueOf(ret));
        return ret;
    }

    HiveAuthorizer createHiveMetaStoreAuthorizer() throws Exception {
        HiveAuthorizerFactory authorizerFactory;
        HiveAuthorizer ret = null;
        HiveConf hiveConf = (HiveConf)tConfig.get();
        if (hiveConf == null) {
            HiveConf hiveConf1 = new HiveConf(super.getConf(), HiveConf.class);
            tConfig.set((Configuration)hiveConf1);
            hiveConf = hiveConf1;
        }
        if ((authorizerFactory = HiveUtils.getAuthorizerFactory((Configuration)hiveConf, HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER)) != null) {
            HiveMetastoreAuthenticationProvider authenticator = tAuthenticator.get();
            authenticator.setConf((Configuration)hiveConf);
            HiveAuthzSessionContext.Builder authzContextBuilder = new HiveAuthzSessionContext.Builder();
            authzContextBuilder.setClientType(HiveAuthzSessionContext.CLIENT_TYPE.HIVEMETASTORE);
            authzContextBuilder.setSessionString("HiveMetaStore");
            HiveAuthzSessionContext authzSessionContext = authzContextBuilder.build();
            ret = authorizerFactory.createHiveAuthorizer(new HiveMetastoreClientFactoryImpl(), hiveConf, authenticator, authzSessionContext);
        }
        return ret;
    }

    boolean isSuperUser(String userName) {
        Configuration conf = this.getConf();
        String ipAddress = HMSHandler.getIPAddress();
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        return MetaStoreServerUtils.checkUserHasHostProxyPrivileges((String)userName, (Configuration)conf, (String)ipAddress);
    }

    boolean isViewOperation(PreEventContext preEventContext) {
        boolean ret = false;
        PreEventContext.PreEventType preEventType = preEventContext.getEventType();
        switch (preEventType) {
            case CREATE_TABLE: {
                PreCreateTableEvent preCreateTableEvent = (PreCreateTableEvent)preEventContext;
                Table table = preCreateTableEvent.getTable();
                ret = this.isViewType(table);
                break;
            }
            case ALTER_TABLE: {
                PreAlterTableEvent preAlterTableEvent = (PreAlterTableEvent)preEventContext;
                Table inTable = preAlterTableEvent.getOldTable();
                Table outTable = preAlterTableEvent.getNewTable();
                ret = this.isViewType(inTable) || this.isViewType(outTable);
                break;
            }
            case DROP_TABLE: {
                PreDropTableEvent preDropTableEvent = (PreDropTableEvent)preEventContext;
                Table droppedTable = preDropTableEvent.getTable();
                ret = this.isViewType(droppedTable);
            }
        }
        return ret;
    }

    private void checkPrivileges(HiveMetaStoreAuthzInfo authzContext, HiveAuthorizer authorizer) throws HiveAccessControlException, HiveAuthzPluginException {
        LOG.debug("==> HiveMetaStoreAuthorizer.checkPrivileges(): authzContext=" + String.valueOf(authzContext) + ", authorizer=" + String.valueOf(authorizer));
        HiveOperationType hiveOpType = authzContext.getOperationType();
        List<HivePrivilegeObject> inputHObjs = authzContext.getInputHObjs();
        List<HivePrivilegeObject> outputHObjs = authzContext.getOutputHObjs();
        HiveAuthzContext hiveAuthzContext = authzContext.getHiveAuthzContext();
        authorizer.checkPrivileges(hiveOpType, inputHObjs, outputHObjs, hiveAuthzContext);
        LOG.debug("<== HiveMetaStoreAuthorizer.checkPrivileges(): authzContext=" + String.valueOf(authzContext) + ", authorizer=" + String.valueOf(authorizer));
    }

    private boolean skipAuthorization(HiveMetaStoreAuthzInfo authzContext) {
        LOG.debug("==> HiveMetaStoreAuthorizer.skipAuthorization()");
        if (authzContext == null) {
            return true;
        }
        boolean ret = false;
        UserGroupInformation ugi = null;
        try {
            ugi = this.getUGI();
            ret = this.isSuperUser(ugi.getShortUserName());
        }
        catch (IOException e) {
            LOG.warn("Not able to obtain UserGroupInformation", (Throwable)e);
        }
        LOG.debug("<== HiveMetaStoreAuthorizer.skipAuthorization(): " + ret);
        return ret;
    }

    private boolean isViewType(Table table) {
        boolean ret = false;
        String tableType = table.getTableType();
        if (TableType.MATERIALIZED_VIEW.name().equals(tableType) || TableType.VIRTUAL_VIEW.name().equals(tableType)) {
            ret = true;
        }
        return ret;
    }

    private String getErrorMessage(PreEventContext preEventContext, String user) {
        String err = "Operation type " + preEventContext.getEventType().name() + " not allowed for user:" + user;
        return err;
    }

    private String getErrorMessage(String eventType, String user) {
        String err = "Operation type " + eventType + " not allowed for user:" + user;
        return err;
    }

    private String getCurrentUser() {
        try {
            return UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String getCurrentUser(HiveMetaStoreAuthorizableEvent authorizableEvent) {
        return authorizableEvent.getAuthzContext().getUGI().getShortUserName();
    }

    private UserGroupInformation getUGI() throws IOException {
        return UserGroupInformation.getCurrentUser();
    }
}

