/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncHex;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringUnaryUDF;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

@Description(name="hex", value="_FUNC_(n, bin, or str) - Convert the argument to hexadecimal ", extended="If the argument is a string, returns two hex digits for each character in the string.\nIf the argument is a number or binary, returns the hexadecimal representation.\nExample:\n  > SELECT _FUNC_(17) FROM src LIMIT 1;\n  '11'\n  > SELECT _FUNC_('Facebook') FROM src LIMIT 1;\n  '46616365626F6F6B'")
@VectorizedExpressions(value={FuncHex.class})
public class UDFHex
extends UDF
implements StringUnaryUDF.IUDFUnaryString {
    private final Text result = new Text();
    private byte[] value = new byte[16];

    private Text evaluate(long num) {
        int len = 0;
        do {
            this.value[this.value.length - ++len] = (byte)Character.toUpperCase(Character.forDigit((int)(num & 0xFL), 16));
        } while ((num >>>= 4) != 0L);
        this.result.set(this.value, this.value.length - len, len);
        return this.result;
    }

    public Text evaluate(LongWritable n) {
        if (n == null) {
            return null;
        }
        return this.evaluate(n.get());
    }

    public Text evaluate(IntWritable n) {
        if (n == null) {
            return null;
        }
        return this.evaluate(n.get());
    }

    @Override
    public Text evaluate(Text s) {
        if (s == null) {
            return null;
        }
        byte[] str = s.getBytes();
        return this.evaluate(str, s.getLength());
    }

    public Text evaluate(BytesWritable b) {
        if (b == null) {
            return null;
        }
        byte[] bytes = b.getBytes();
        return this.evaluate(bytes, b.getLength());
    }

    private Text evaluate(byte[] bytes, int length) {
        if (this.value.length < length * 2) {
            this.value = new byte[length * 2];
        }
        for (int i = 0; i < length; ++i) {
            this.value[i * 2] = (byte)Character.toUpperCase(Character.forDigit((bytes[i] & 0xF0) >>> 4, 16));
            this.value[i * 2 + 1] = (byte)Character.toUpperCase(Character.forDigit(bytes[i] & 0xF, 16));
        }
        this.result.set(this.value, 0, length * 2);
        return this.result;
    }
}

