/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantIntObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="percentile_cont", value="_FUNC_(input, pc) - Returns the percentile of expr at pc (range: [0,1]).")
@WindowFunctionDescription(supportsWindow=false, pivotResult=true, orderedAggregate=true)
public class GenericUDAFPercentileCont
extends AbstractGenericUDAFResolver {
    private static final Comparator<LongWritable> LONG_COMPARATOR = ShimLoader.getHadoopShims().getLongComparator();
    private static final Comparator<org.apache.hadoop.hive.serde2.io.DoubleWritable> DOUBLE_COMPARATOR = new Comparator<org.apache.hadoop.hive.serde2.io.DoubleWritable>(){

        @Override
        public int compare(org.apache.hadoop.hive.serde2.io.DoubleWritable o1, org.apache.hadoop.hive.serde2.io.DoubleWritable o2) {
            return o1.compareTo((DoubleWritable)o2);
        }
    };

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length == 2) {
            return this.getGenericUDAFEvaluator(parameters[0], parameters[1]);
        }
        if (parameters.length == 4) {
            return this.getGenericUDAFEvaluator(parameters[1], parameters[0]);
        }
        throw new UDFArgumentTypeException(parameters.length - 1, "Only 1 argument and a single order column reference expected.");
    }

    private GenericUDAFEvaluator getGenericUDAFEvaluator(TypeInfo orderByColumn, TypeInfo percentile) throws UDFArgumentTypeException {
        if (orderByColumn.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + orderByColumn.getTypeName() + " is passed.");
        }
        switch (((PrimitiveTypeInfo)orderByColumn).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case VOID: {
                return this.createLongEvaluator(percentile);
            }
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                return this.createDoubleEvaluator(percentile);
            }
        }
        throw new UDFArgumentTypeException(0, "Only numeric arguments are accepted but " + orderByColumn.getTypeName() + " is passed.");
    }

    protected GenericUDAFEvaluator createLongEvaluator(TypeInfo percentile) {
        return percentile.getCategory() == ObjectInspector.Category.LIST ? new PercentileContLongArrayEvaluator() : new PercentileContLongEvaluator();
    }

    protected GenericUDAFEvaluator createDoubleEvaluator(TypeInfo percentile) {
        return percentile.getCategory() == ObjectInspector.Category.LIST ? new PercentileContDoubleArrayEvaluator() : new PercentileContDoubleEvaluator();
    }

    public static class PercentileContLongArrayEvaluator
    extends PercentileContLongEvaluator {
        public PercentileContLongArrayEvaluator() {
            super(new ArrayConverter());
        }
    }

    public static class PercentileContLongEvaluator
    extends PercentileContEvaluator<Long, LongWritable> {
        public PercentileContLongEvaluator() {
            this(new PrimitiveConverter());
        }

        public PercentileContLongEvaluator(Converter converter) {
            super(new LongComparator(), converter);
        }

        @Override
        protected ArrayList<ObjectInspector> getPartialInspectors() {
            ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
            foi.add((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector));
            foi.add((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector));
            foi.add((ObjectInspector)PrimitiveObjectInspectorFactory.writableBooleanObjectInspector);
            return foi;
        }

        @Override
        protected Long getInput(Object parameter, PrimitiveObjectInspector inputOI) {
            return PrimitiveObjectInspectorUtils.getLong((Object)parameter, (PrimitiveObjectInspector)inputOI);
        }

        @Override
        protected LongWritable wrapInput(Long input) {
            return new LongWritable(input.longValue());
        }

        @Override
        protected LongWritable copyInput(LongWritable input) {
            return new LongWritable(input.get());
        }

        @Override
        protected PercentileCalculator<LongWritable> getCalculator() {
            return new PercentileContLongCalculator();
        }
    }

    public static class PercentileContDoubleArrayEvaluator
    extends PercentileContDoubleEvaluator {
        public PercentileContDoubleArrayEvaluator() {
            super(new ArrayConverter());
        }
    }

    public static class PercentileContDoubleEvaluator
    extends PercentileContEvaluator<Double, org.apache.hadoop.hive.serde2.io.DoubleWritable> {
        public PercentileContDoubleEvaluator() {
            this(new PrimitiveConverter());
        }

        public PercentileContDoubleEvaluator(Converter converter) {
            super(new DoubleComparator(), converter);
        }

        @Override
        protected ArrayList<ObjectInspector> getPartialInspectors() {
            ArrayList<ObjectInspector> foi = new ArrayList<ObjectInspector>();
            foi.add((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.writableLongObjectInspector));
            foi.add((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector));
            foi.add((ObjectInspector)PrimitiveObjectInspectorFactory.writableBooleanObjectInspector);
            return foi;
        }

        @Override
        protected Double getInput(Object parameter, PrimitiveObjectInspector inputOI) {
            return PrimitiveObjectInspectorUtils.getDouble((Object)parameter, (PrimitiveObjectInspector)inputOI);
        }

        @Override
        protected org.apache.hadoop.hive.serde2.io.DoubleWritable wrapInput(Double input) {
            return new org.apache.hadoop.hive.serde2.io.DoubleWritable(input.doubleValue());
        }

        @Override
        protected org.apache.hadoop.hive.serde2.io.DoubleWritable copyInput(org.apache.hadoop.hive.serde2.io.DoubleWritable input) {
            return new org.apache.hadoop.hive.serde2.io.DoubleWritable(input.get());
        }

        @Override
        protected PercentileCalculator<org.apache.hadoop.hive.serde2.io.DoubleWritable> getCalculator() {
            return new PercentileContDoubleCalculator();
        }
    }

    public static class PercentileContDoubleCalculator
    implements PercentileCalculator<org.apache.hadoop.hive.serde2.io.DoubleWritable> {
        @Override
        public double getPercentile(List<Map.Entry<org.apache.hadoop.hive.serde2.io.DoubleWritable, LongWritable>> entriesList, double position) {
            double higherKey;
            long lower = (long)Math.floor(position);
            long higher = (long)Math.ceil(position);
            int i = 0;
            while (entriesList.get(i).getValue().get() < lower + 1L) {
                ++i;
            }
            double lowerKey = entriesList.get(i).getKey().get();
            if (higher == lower) {
                return lowerKey;
            }
            if (entriesList.get(i).getValue().get() < higher + 1L) {
                ++i;
            }
            if ((higherKey = entriesList.get(i).getKey().get()) == lowerKey) {
                return lowerKey;
            }
            return ((double)higher - position) * lowerKey + (position - (double)lower) * higherKey;
        }
    }

    public static class PercentileContLongCalculator
    implements PercentileCalculator<LongWritable> {
        @Override
        public double getPercentile(List<Map.Entry<LongWritable, LongWritable>> entriesList, double position) {
            long higherKey;
            long lower = (long)Math.floor(position);
            long higher = (long)Math.ceil(position);
            int i = 0;
            while (entriesList.get(i).getValue().get() < lower + 1L) {
                ++i;
            }
            long lowerKey = entriesList.get(i).getKey().get();
            if (higher == lower) {
                return lowerKey;
            }
            if (entriesList.get(i).getValue().get() < higher + 1L) {
                ++i;
            }
            if ((higherKey = entriesList.get(i).getKey().get()) == lowerKey) {
                return lowerKey;
            }
            return ((double)higher - position) * (double)lowerKey + (position - (double)lower) * (double)higherKey;
        }
    }

    private static class ArrayConverter
    implements Converter {
        private ArrayConverter() {
        }

        @Override
        public List<org.apache.hadoop.hive.serde2.io.DoubleWritable> convertPercentileParameter(Object parameter) {
            ArrayList percentilesParameter = (ArrayList)parameter;
            ArrayList<org.apache.hadoop.hive.serde2.io.DoubleWritable> percentileList = new ArrayList<org.apache.hadoop.hive.serde2.io.DoubleWritable>(percentilesParameter.size());
            for (HiveDecimalWritable hiveDecimalWritable : percentilesParameter) {
                Double percentile = hiveDecimalWritable.getHiveDecimal().doubleValue();
                PercentileContEvaluator.validatePercentile(percentile);
                percentileList.add(new org.apache.hadoop.hive.serde2.io.DoubleWritable(percentile.doubleValue()));
            }
            return percentileList;
        }

        @Override
        public Object convertResults(List<org.apache.hadoop.hive.serde2.io.DoubleWritable> results) {
            return results;
        }

        @Override
        public ObjectInspector getResultObjectInspector() {
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        }
    }

    private static class PrimitiveConverter
    implements Converter {
        private PrimitiveConverter() {
        }

        @Override
        public List<org.apache.hadoop.hive.serde2.io.DoubleWritable> convertPercentileParameter(Object parameter) {
            Double percentile = ((HiveDecimalWritable)parameter).getHiveDecimal().doubleValue();
            PercentileContEvaluator.validatePercentile(percentile);
            return Collections.singletonList(new org.apache.hadoop.hive.serde2.io.DoubleWritable(percentile.doubleValue()));
        }

        @Override
        public Object convertResults(List<org.apache.hadoop.hive.serde2.io.DoubleWritable> results) {
            return results.get(0);
        }

        @Override
        public ObjectInspector getResultObjectInspector() {
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }
    }

    private static interface Converter {
        public List<org.apache.hadoop.hive.serde2.io.DoubleWritable> convertPercentileParameter(Object var1);

        public Object convertResults(List<org.apache.hadoop.hive.serde2.io.DoubleWritable> var1);

        public ObjectInspector getResultObjectInspector();
    }

    public static abstract class PercentileContEvaluator<T, U>
    extends GenericUDAFEvaluator {
        PercentileCalculator<U> calc = this.getCalculator();
        protected PrimitiveObjectInspector inputOI;
        MapObjectInspector countsOI;
        ListObjectInspector percentilesOI;
        protected transient Object[] partialResult;
        protected List<org.apache.hadoop.hive.serde2.io.DoubleWritable> results;
        protected transient StructObjectInspector soi;
        protected transient StructField countsField;
        protected transient StructField percentilesField;
        protected transient StructField isAscendingField;
        private final transient Comparator<Map.Entry<U, LongWritable>> comparator;
        private final transient Converter converter;
        protected transient boolean isAscending;

        protected PercentileContEvaluator(Comparator<Map.Entry<U, LongWritable>> comparator, Converter converter) {
            this.comparator = comparator;
            this.converter = converter;
        }

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                if (parameters.length == 2) {
                    this.initInspectors((PrimitiveObjectInspector)parameters[0]);
                } else {
                    this.initInspectors((PrimitiveObjectInspector)parameters[1], (WritableConstantIntObjectInspector)parameters[2]);
                }
            } else {
                this.initPartialInspectors((StructObjectInspector)parameters[0]);
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                this.partialResult = new Object[3];
                ArrayList<ObjectInspector> foi = this.getPartialInspectors();
                ArrayList<String> fname = new ArrayList<String>();
                fname.add("counts");
                fname.add("percentiles");
                fname.add("isAscending");
                return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
            }
            this.results = null;
            return this.converter.getResultObjectInspector();
        }

        protected abstract PercentileCalculator<U> getCalculator();

        protected abstract ArrayList<ObjectInspector> getPartialInspectors();

        protected abstract T getInput(Object var1, PrimitiveObjectInspector var2);

        protected abstract U wrapInput(T var1);

        protected abstract U copyInput(U var1);

        private void sortEntries(List<Map.Entry<U, LongWritable>> entriesList, boolean isAscending) {
            entriesList.sort(isAscending ? this.comparator : this.comparator.reversed());
        }

        protected void initInspectors(PrimitiveObjectInspector orderByColumnOI) {
            this.inputOI = orderByColumnOI;
            this.isAscending = true;
        }

        protected void initInspectors(PrimitiveObjectInspector orderByColumnOI, WritableConstantIntObjectInspector orderDirectionOI) {
            this.inputOI = orderByColumnOI;
            this.isAscending = orderDirectionOI.getWritableConstantValue().get() != 0;
        }

        protected void initPartialInspectors(StructObjectInspector objectInspector) {
            this.soi = objectInspector;
            this.countsField = this.soi.getStructFieldRef("counts");
            this.percentilesField = this.soi.getStructFieldRef("percentiles");
            this.isAscendingField = this.soi.getStructFieldRef("isAscending");
            this.countsOI = (MapObjectInspector)this.countsField.getFieldObjectInspector();
            this.percentilesOI = (ListObjectInspector)this.percentilesField.getFieldObjectInspector();
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            PercentileAgg agg = new PercentileAgg(this);
            agg.isAscending = this.isAscending;
            return agg;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            PercentileAgg percAgg = (PercentileAgg)agg;
            if (percAgg.counts != null) {
                percAgg.counts.clear();
            }
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            PercentileAgg percAgg = (PercentileAgg)agg;
            if (parameters.length == 4) {
                this.iterate(percAgg, parameters[0], parameters[1]);
            } else {
                this.iterate(percAgg, parameters[1], parameters[0]);
            }
        }

        private void iterate(PercentileAgg percAgg, Object percentiles, Object oderByColumnValue) {
            if (percAgg.percentiles == null) {
                percAgg.percentiles = this.converter.convertPercentileParameter(percentiles);
            }
            if (oderByColumnValue == null) {
                return;
            }
            T input = this.getInput(oderByColumnValue, this.inputOI);
            if (input != null) {
                this.increment(percAgg, this.wrapInput(input), 1L);
            }
        }

        protected void increment(PercentileAgg s, U input, long i) {
            LongWritable count;
            if (s.counts == null) {
                s.counts = new HashMap();
            }
            if ((count = s.counts.get(input)) == null) {
                s.counts.put(this.copyInput(input), new LongWritable(i));
            } else {
                count.set(count.get() + i);
            }
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial == null) {
                return;
            }
            Object objCounts = this.soi.getStructFieldData(partial, this.countsField);
            Object objPercentiles = this.soi.getStructFieldData(partial, this.percentilesField);
            Object objIsAscending = this.soi.getStructFieldData(partial, this.isAscendingField);
            Map counts = this.countsOI.getMap(objCounts);
            List percentiles = this.percentilesOI.getList(objPercentiles);
            if (counts == null || percentiles == null) {
                return;
            }
            PercentileAgg percAgg = (PercentileAgg)agg;
            if (percAgg.percentiles == null) {
                percAgg.percentiles = new ArrayList<org.apache.hadoop.hive.serde2.io.DoubleWritable>(percentiles);
            }
            percAgg.isAscending = ((BooleanWritable)objIsAscending).get();
            for (Map.Entry e : counts.entrySet()) {
                this.increment(percAgg, e.getKey(), ((LongWritable)e.getValue()).get());
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            PercentileAgg percAgg = (PercentileAgg)agg;
            if (percAgg.counts == null || percAgg.counts.size() == 0) {
                return null;
            }
            Set entries = percAgg.counts.entrySet();
            ArrayList entriesList = new ArrayList(entries);
            this.sortEntries(entriesList, percAgg.isAscending);
            long total = this.getTotal(entriesList);
            if (this.results == null) {
                this.results = new ArrayList<org.apache.hadoop.hive.serde2.io.DoubleWritable>(percAgg.percentiles.size());
                for (int i = 0; i < percAgg.percentiles.size(); ++i) {
                    this.results.add(new org.apache.hadoop.hive.serde2.io.DoubleWritable(0.0));
                }
            }
            this.calculatePercentile(percAgg.percentiles, entriesList, total, this.results);
            return this.converter.convertResults(this.results);
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            PercentileAgg percAgg = (PercentileAgg)agg;
            this.partialResult[0] = percAgg.counts;
            this.partialResult[1] = percAgg.percentiles;
            this.partialResult[2] = new BooleanWritable(percAgg.isAscending);
            return this.partialResult;
        }

        protected long getTotal(List<Map.Entry<U, LongWritable>> entriesList) {
            long total = 0L;
            for (int i = 0; i < entriesList.size(); ++i) {
                LongWritable count = entriesList.get(i).getValue();
                count.set(total += count.get());
            }
            return total;
        }

        public static void validatePercentile(Double percentile) {
            if (percentile < 0.0 || percentile > 1.0) {
                throw new RuntimeException("Percentile value must be within the range of 0 to 1.");
            }
        }

        protected List<org.apache.hadoop.hive.serde2.io.DoubleWritable> calculatePercentile(List<org.apache.hadoop.hive.serde2.io.DoubleWritable> percentiles, List<Map.Entry<U, LongWritable>> entriesList, long total, List<org.apache.hadoop.hive.serde2.io.DoubleWritable> results) {
            long maxPosition = total - 1L;
            for (int i = 0; i < percentiles.size(); ++i) {
                org.apache.hadoop.hive.serde2.io.DoubleWritable percentile = percentiles.get(i);
                double position = (double)maxPosition * percentile.get();
                results.get(i).set(this.calc.getPercentile(entriesList, position));
            }
            return results;
        }

        public class PercentileAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            Map<U, LongWritable> counts;
            List<org.apache.hadoop.hive.serde2.io.DoubleWritable> percentiles;
            boolean isAscending;

            public PercentileAgg(PercentileContEvaluator this$0) {
            }
        }
    }

    protected static interface PercentileCalculator<U> {
        public double getPercentile(List<Map.Entry<U, LongWritable>> var1, double var2);
    }

    public static class DoubleComparator
    implements Comparator<Map.Entry<org.apache.hadoop.hive.serde2.io.DoubleWritable, LongWritable>>,
    Serializable {
        @Override
        public int compare(Map.Entry<org.apache.hadoop.hive.serde2.io.DoubleWritable, LongWritable> o1, Map.Entry<org.apache.hadoop.hive.serde2.io.DoubleWritable, LongWritable> o2) {
            return DOUBLE_COMPARATOR.compare(o1.getKey(), o2.getKey());
        }
    }

    public static class LongComparator
    implements Comparator<Map.Entry<LongWritable, LongWritable>>,
    Serializable {
        @Override
        public int compare(Map.Entry<LongWritable, LongWritable> o1, Map.Entry<LongWritable, LongWritable> o2) {
            return LONG_COMPARATOR.compare(o1.getKey(), o2.getKey());
        }
    }
}

