/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.json.HiveJsonReader;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

@Description(name="json_read", value="_FUNC_(json,type) - Parses the given json according to the given complex type specification", extended="Parsed as null: if the json is null, it is the empty string or if it contains only whitespaces\nExample:\nselect _FUNC_('[]','array<struct<a:string>>' ")
public class GenericUDFJsonRead
extends GenericUDF {
    private PrimitiveObjectInspectorConverter.TextConverter inputConverter;
    private HiveJsonReader jsonReader;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 2, 2);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgPrimitive(arguments, 1);
        if (!ObjectInspectorUtils.isConstantObjectInspector((ObjectInspector)arguments[1])) {
            throw new UDFArgumentTypeException(1, this.getFuncName() + " argument 2 may only be a constant");
        }
        this.inputConverter = new PrimitiveObjectInspectorConverter.TextConverter((PrimitiveObjectInspector)arguments[0]);
        String typeStr = this.getConstantStringValue(arguments, 1);
        try {
            TypeInfo t = TypeInfoUtils.getTypeInfoFromTypeString((String)typeStr);
            ObjectInspector oi = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)t);
            this.jsonReader = new HiveJsonReader(oi);
            this.jsonReader.enable(HiveJsonReader.Feature.PRIMITIVE_TO_WRITABLE);
        }
        catch (Exception e) {
            throw new UDFArgumentException(this.getFuncName() + ": Error parsing typestring: " + e.getMessage());
        }
        return this.jsonReader.getObjectInspector();
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object valObject = arguments[0].get();
        if (valObject == null) {
            return null;
        }
        try {
            String text = this.inputConverter.convert(valObject).toString();
            if (text.trim().length() == 0) {
                return null;
            }
            return this.jsonReader.parseStruct(text);
        }
        catch (Exception e) {
            throw new HiveException("Error parsing json: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("json_read", children);
    }
}

