/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import com.google.common.collect.ImmutableMap;
import org.apache.calcite.rel.RelFieldCollation;

public final class DirectionUtils {
    public static final int ASCENDING_CODE = 1;
    public static final int DESCENDING_CODE = 0;
    private static final ImmutableMap<String, Object> ASCENDING_DATA = ImmutableMap.of((Object)"code", (Object)1, (Object)"sign", (Object)Character.valueOf('+'), (Object)"text", (Object)"ASC", (Object)"direction", (Object)RelFieldCollation.Direction.ASCENDING, (Object)"token", (Object)1281);
    private static final ImmutableMap<String, Object> DESCENDING_DATA = ImmutableMap.of((Object)"code", (Object)0, (Object)"sign", (Object)Character.valueOf('-'), (Object)"text", (Object)"DESC", (Object)"direction", (Object)RelFieldCollation.Direction.DESCENDING, (Object)"token", (Object)1282);

    private DirectionUtils() {
        throw new UnsupportedOperationException("DirectionUtils should not be instantiated");
    }

    public static String codeToText(int code) {
        return (String)DirectionUtils.convert("code", code, "text");
    }

    public static char codeToSign(int code) {
        return ((Character)DirectionUtils.convert("code", code, "sign")).charValue();
    }

    public static int tokenToCode(int token) {
        return (Integer)DirectionUtils.convert("token", token, "code");
    }

    public static int signToCode(char sign) {
        return (Integer)DirectionUtils.convert("sign", Character.valueOf(sign), "code");
    }

    public static RelFieldCollation.Direction codeToDirection(int code) {
        return (RelFieldCollation.Direction)DirectionUtils.convert("code", code, "direction");
    }

    public static int directionToCode(RelFieldCollation.Direction direction) {
        return (Integer)DirectionUtils.convert("direction", direction, "code");
    }

    private static Object convert(String typeFrom, Object value, String typeTo) {
        Object ascObject = ASCENDING_DATA.get((Object)typeFrom);
        Object descObject = DESCENDING_DATA.get((Object)typeFrom);
        if (ascObject.equals(value)) {
            return ASCENDING_DATA.get((Object)typeTo);
        }
        if (descObject.equals(value)) {
            return DESCENDING_DATA.get((Object)typeTo);
        }
        throw new IllegalArgumentException("The value " + String.valueOf(value) + " isn not a valid value for " + typeFrom);
    }
}

