/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.dialog;

import java.util.Set;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.VariableRegistry;
import org.apache.hop.core.variables.VariableScope;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AboutDialog
extends Dialog {
    private static final Class<?> PKG = AboutDialog.class;
    private static final String[] JAVA_PROPERTIES = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vm.vendor", "java.specification.version", "java.class.path", "file.encoding"};
    private Shell shell;

    public AboutDialog(Shell parent) {
        super(parent, 0);
    }

    public void open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        PropsUi props = PropsUi.getInstance();
        this.shell = new Shell(parent, 268503152);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AboutDialog.Title", (String[])new String[0]));
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        this.shell.setSize(700, 500);
        this.shell.setMinimumSize(450, 300);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        PropsUi.setLook((Widget)this.shell);
        Composite composite = new Composite((Composite)this.shell, 0);
        FormData fdLink = new FormData();
        fdLink.top = new FormAttachment(0, 0);
        fdLink.left = new FormAttachment(0, 0);
        fdLink.right = new FormAttachment(100, 0);
        composite.setLayoutData((Object)fdLink);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        PropsUi.setLook((Widget)composite);
        Label wLogo = new Label(composite, 0x1000000);
        wLogo.setImage(SwtSvgImageUtil.getImageAsResource(display, "ui/images/logo_hop.svg").getAsBitmapForSize((Device)display, 100, 100));
        wLogo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 3));
        Label wName = new Label(composite, 0x1000000);
        wName.setText("Apache Hop");
        wName.setFont(GuiResource.getInstance().getFontBold());
        wName.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        PropsUi.setLook((Widget)wName);
        Label wVersion = new Label(composite, 0x1000000);
        wVersion.setText(HopGui.class.getPackage().getImplementationVersion());
        wVersion.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        PropsUi.setLook((Widget)wVersion);
        Link wLink = new Link(composite, 66);
        wLink.setText("<a href=\"https://hop.apache.org\">hop.apache.org</a>");
        wLink.addListener(13, e -> {
            try {
                EnvironmentUtils.getInstance().openUrl("https://hop.apache.org");
            }
            catch (Exception ex) {
                new ErrorDialog(this.shell, "Error", "Error opening URL", ex);
            }
        });
        wLink.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        PropsUi.setLook((Widget)wLink);
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wOk}, PropsUi.getMargin(), null);
        Text wText = new Text((Composite)this.shell, 2890);
        wText.setText(this.getProperties());
        FormData fdText = new FormData();
        fdText.top = new FormAttachment((Control)composite, PropsUi.getMargin());
        fdText.left = new FormAttachment(0, 0);
        fdText.right = new FormAttachment(100, 0);
        fdText.bottom = new FormAttachment((Control)wOk, -PropsUi.getMargin());
        wText.setLayoutData((Object)fdText);
        PropsUi.setLook((Widget)wText);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                AboutDialog.this.ok();
            }
        });
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private String getProperties() {
        Set names = VariableRegistry.getInstance().getVariableNames(new VariableScope[]{VariableScope.SYSTEM});
        for (String name : JAVA_PROPERTIES) {
            names.add(name);
        }
        IVariables variables = HopGui.getInstance().getVariables();
        StringBuilder builder = new StringBuilder();
        for (String name : names) {
            builder.append(name);
            builder.append('=');
            builder.append(variables.getVariable(name, ""));
            builder.append('\n');
        }
        return builder.toString();
    }

    public void dispose() {
        this.shell.dispose();
    }

    private void ok() {
        this.dispose();
    }
}

