/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import com.google.auto.value.AutoValue;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.kafka.AutoValue_KafkaSchemaTransformReadConfiguration;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;

@DefaultSchema(value=AutoValueSchema.class)
@Experimental
@AutoValue
public abstract class KafkaSchemaTransformReadConfiguration {
    public static final Set<String> VALID_START_OFFSET_VALUES = Sets.newHashSet((Object[])new String[]{"earliest", "latest"});
    public static final Set<String> VALID_DATA_FORMATS = Sets.newHashSet((Object[])new String[]{"AVRO", "JSON"});

    public void validate() {
        String startOffset = this.getAutoOffsetResetConfig();
        assert (startOffset == null || VALID_START_OFFSET_VALUES.contains(startOffset)) : "Valid Kafka Start offset values are " + VALID_START_OFFSET_VALUES;
        String dataFormat = this.getDataFormat();
        assert (dataFormat == null || VALID_DATA_FORMATS.contains(dataFormat)) : "Valid data formats are " + VALID_DATA_FORMATS;
    }

    public static Builder builder() {
        return new AutoValue_KafkaSchemaTransformReadConfiguration.Builder();
    }

    public abstract String getBootstrapServers();

    @Nullable
    public abstract String getConfluentSchemaRegistryUrl();

    @Nullable
    public abstract String getDataFormat();

    @Nullable
    public abstract String getConfluentSchemaRegistrySubject();

    @Nullable
    public abstract String getAvroSchema();

    @Nullable
    public abstract String getAutoOffsetResetConfig();

    @Nullable
    public abstract Map<String, String> getConsumerConfigUpdates();

    public abstract String getTopic();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setBootstrapServers(String var1);

        public abstract Builder setConfluentSchemaRegistryUrl(String var1);

        public abstract Builder setConfluentSchemaRegistrySubject(String var1);

        public abstract Builder setAvroSchema(String var1);

        public abstract Builder setDataFormat(String var1);

        public abstract Builder setAutoOffsetResetConfig(String var1);

        public abstract Builder setConsumerConfigUpdates(Map<String, String> var1);

        public abstract Builder setTopic(String var1);

        public abstract KafkaSchemaTransformReadConfiguration build();
    }
}

