/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.jsonoutput;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Objects;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.jsonoutput.JsonOutputData;
import org.apache.hop.pipeline.transforms.jsonoutput.JsonOutputField;
import org.apache.hop.pipeline.transforms.jsonoutput.JsonOutputMeta;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JsonOutput
extends BaseTransform<JsonOutputMeta, JsonOutputData> {
    private static final Class<?> PKG = JsonOutput.class;
    private CompatibilityFactory compatibilityFactory;

    public JsonOutput(TransformMeta transformMeta, JsonOutputMeta meta, JsonOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
        JsonOutputMeta jsonOutputMeta = (JsonOutputMeta)transformMeta.getTransform();
        this.compatibilityFactory = jsonOutputMeta.isCompatibilityMode() ? new CompatibilityMode() : new FixedMode();
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.writeJsonToFile();
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((JsonOutputData)this.data).inputRowMeta = this.getInputRowMeta();
            ((JsonOutputData)this.data).inputRowMetaSize = ((JsonOutputData)this.data).inputRowMeta.size();
            if (((JsonOutputData)this.data).outputValue) {
                ((JsonOutputData)this.data).outputRowMeta = ((JsonOutputData)this.data).inputRowMeta.clone();
                ((JsonOutputMeta)this.meta).getFields(((JsonOutputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            }
            ((JsonOutputData)this.data).nrFields = ((JsonOutputMeta)this.meta).getOutputFields().size();
            ((JsonOutputData)this.data).fieldIndexes = new int[((JsonOutputData)this.data).nrFields];
            for (int i = 0; i < ((JsonOutputData)this.data).nrFields; ++i) {
                ((JsonOutputData)this.data).fieldIndexes[i] = ((JsonOutputData)this.data).inputRowMeta.indexOfValue(((JsonOutputMeta)this.meta).getOutputFields().get(i).getFieldName());
                if (((JsonOutputData)this.data).fieldIndexes[i] < 0) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"JsonOutput.Exception.FieldNotFound", (String[])new String[0]));
                }
                JsonOutputField field = ((JsonOutputMeta)this.meta).getOutputFields().get(i);
                field.setElementName(this.resolve(field.getElementName()));
            }
        }
        ((JsonOutputData)this.data).rowsAreSafe = false;
        this.compatibilityFactory.execute(r);
        if (((JsonOutputData)this.data).writeToFile && !((JsonOutputData)this.data).outputValue) {
            this.putRow(((JsonOutputData)this.data).inputRowMeta, r);
            this.incrementLinesOutput();
        }
        return true;
    }

    private void writeJsonToFile() throws HopTransformException {
        if (!((JsonOutputData)this.data).rowsAreSafe) {
            this.outputRow(null);
        }
    }

    private void outputRow(Object[] rowData) throws HopTransformException {
        ((JsonOutputData)this.data).jg = new JSONObject();
        ((JsonOutputData)this.data).jg.put((Object)((JsonOutputData)this.data).realBlocName, (Object)((JsonOutputData)this.data).ja);
        String value = ((JsonOutputData)this.data).jg.toJSONString();
        if (rowData != null && ((JsonOutputData)this.data).outputValue && ((JsonOutputData)this.data).outputRowMeta != null) {
            Object[] outputRowData = RowDataUtil.addValueData((Object[])rowData, (int)((JsonOutputData)this.data).inputRowMetaSize, (Object)value);
            this.incrementLinesOutput();
            this.putRow(((JsonOutputData)this.data).outputRowMeta, outputRowData);
        }
        if (((JsonOutputData)this.data).writeToFile && !((JsonOutputData)this.data).ja.isEmpty()) {
            if (!this.openNewFile()) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"JsonOutput.Error.OpenNewFile", (String[])new String[]{this.buildFilename()}));
            }
            try {
                ((JsonOutputData)this.data).writer.write(value);
            }
            catch (Exception e) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"JsonOutput.Error.Writing", (String[])new String[0]), (Throwable)e);
            }
            this.closeFile();
        }
        ((JsonOutputData)this.data).rowsAreSafe = true;
        ((JsonOutputData)this.data).ja = new JSONArray();
    }

    public boolean init() {
        if (super.init()) {
            ((JsonOutputData)this.data).writeToFile = !Objects.equals(((JsonOutputMeta)this.meta).getOperationType(), "outputvalue");
            boolean bl = ((JsonOutputData)this.data).outputValue = !Objects.equals(((JsonOutputMeta)this.meta).getOperationType(), "writetofile");
            if (((JsonOutputData)this.data).outputValue && Utils.isEmpty((CharSequence)this.resolve(((JsonOutputMeta)this.meta).getOutputValue()))) {
                this.logError(BaseMessages.getString(PKG, (String)"JsonOutput.Error.MissingOutputFieldName", (String[])new String[0]));
                this.stopAll();
                this.setErrors(1L);
                return false;
            }
            if (((JsonOutputData)this.data).writeToFile) {
                if (Utils.isEmpty((CharSequence)((JsonOutputMeta)this.meta).getFileName())) {
                    this.logError(BaseMessages.getString(PKG, (String)"JsonOutput.Error.MissingTargetFilename", (String[])new String[0]));
                    this.stopAll();
                    this.setErrors(1L);
                    return false;
                }
                if (!((JsonOutputMeta)this.meta).isDoNotOpenNewFileInit() && !this.openNewFile()) {
                    this.logError(BaseMessages.getString(PKG, (String)"JsonOutput.Error.OpenNewFile", (String[])new String[]{this.buildFilename()}));
                    this.stopAll();
                    this.setErrors(1L);
                    return false;
                }
            }
            ((JsonOutputData)this.data).realBlocName = Const.NVL((String)this.resolve(((JsonOutputMeta)this.meta).getJsonBloc()), (String)"");
            ((JsonOutputData)this.data).nrRowsInBloc = Const.toInt((String)this.resolve(((JsonOutputMeta)this.meta).getNrRowsInBloc()), (int)0);
            return true;
        }
        return false;
    }

    public void dispose() {
        if (((JsonOutputData)this.data).ja != null) {
            if (((JsonOutputData)this.data).ja.size() > 0) {
                try {
                    this.outputRow(null);
                }
                catch (Exception e) {
                    this.log.logError("Error writing final rows to disk", (Throwable)e);
                }
            }
            ((JsonOutputData)this.data).ja = null;
        }
        if (((JsonOutputData)this.data).jg != null) {
            ((JsonOutputData)this.data).jg = null;
        }
        this.closeFile();
        super.dispose();
    }

    public void startBundle() throws HopException {
        if (!this.first) {
            this.openNewFile();
        }
    }

    public void batchComplete() throws HopException {
        if (!((JsonOutputData)this.data).isBeamContext()) {
            this.writeJsonToFile();
        }
    }

    public void finishBundle() throws HopException {
        this.writeJsonToFile();
    }

    private void createParentFolder(String filename) throws HopTransformException {
        if (!((JsonOutputMeta)this.meta).isCreateParentFolder()) {
            return;
        }
        FileObject parentfolder = null;
        try {
            parentfolder = HopVfs.getFileObject((String)filename).getParent();
            if (!parentfolder.exists()) {
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JsonOutput.Error.ParentFolderNotExist", (Object[])new Object[]{parentfolder.getName()}));
                }
                parentfolder.createFolder();
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JsonOutput.Log.ParentFolderCreated", (String[])new String[0]));
                }
            }
        }
        catch (Exception e) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"JsonOutput.Error.ErrorCreatingParentFolder", (Object[])new Object[]{parentfolder.getName()}));
        }
        finally {
            if (parentfolder != null) {
                try {
                    parentfolder.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean openNewFile() {
        if (((JsonOutputData)this.data).writer != null) {
            return true;
        }
        boolean retval = false;
        try {
            OutputStream fos;
            String filename = this.buildFilename();
            this.createParentFolder(filename);
            if (((JsonOutputMeta)this.meta).isAddToResult()) {
                ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)filename), this.getPipelineMeta().getName(), this.getTransformName());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"JsonOutput.ResultFilenames.Comment", (String[])new String[0]));
                this.addResultFile(resultFile);
            }
            OutputStream outputStream = fos = HopVfs.getOutputStream((String)filename, (boolean)((JsonOutputMeta)this.meta).isFileAppended());
            ((JsonOutputData)this.data).writer = !Utils.isEmpty((CharSequence)((JsonOutputMeta)this.meta).getEncoding()) ? new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream, 5000), this.resolve(((JsonOutputMeta)this.meta).getEncoding())) : new OutputStreamWriter(new BufferedOutputStream(outputStream, 5000));
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JsonOutput.FileOpened", (String[])new String[]{filename}));
            }
            ++((JsonOutputData)this.data).splitnr;
            retval = true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JsonOutput.Error.OpeningFile", (String[])new String[]{e.toString()}));
        }
        return retval;
    }

    public String buildFilename() {
        return ((JsonOutputMeta)this.meta).buildFilename(this.variables, "" + this.getCopy(), null, "" + ((JsonOutputData)this.data).splitnr, ((JsonOutputData)this.data).isBeamContext(), this.log.getLogChannelId(), ((JsonOutputData)this.data).getBeamBundleNr(), false);
    }

    protected boolean closeFile() {
        if (((JsonOutputData)this.data).writer == null) {
            return true;
        }
        boolean retval = false;
        try {
            ((JsonOutputData)this.data).writer.close();
            ((JsonOutputData)this.data).writer = null;
            retval = true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JsonOutput.Error.ClosingFile", (String[])new String[]{e.toString()}));
            this.setErrors(1L);
            retval = false;
        }
        return retval;
    }

    private class FixedMode
    implements CompatibilityFactory {
        private FixedMode() {
        }

        @Override
        public void execute(Object[] row) throws HopException {
            JSONObject jo = new JSONObject();
            block6: for (int i = 0; i < ((JsonOutputData)((JsonOutput)JsonOutput.this).data).nrFields; ++i) {
                JsonOutputField outputField = ((JsonOutputMeta)JsonOutput.this.meta).getOutputFields().get(i);
                IValueMeta v = ((JsonOutputData)((JsonOutput)JsonOutput.this).data).inputRowMeta.getValueMeta(((JsonOutputData)((JsonOutput)JsonOutput.this).data).fieldIndexes[i]);
                switch (v.getType()) {
                    case 4: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutputData)((JsonOutput)JsonOutput.this).data).inputRowMeta.getBoolean(row, ((JsonOutputData)((JsonOutput)JsonOutput.this).data).fieldIndexes[i]));
                        continue block6;
                    }
                    case 5: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutputData)((JsonOutput)JsonOutput.this).data).inputRowMeta.getInteger(row, ((JsonOutputData)((JsonOutput)JsonOutput.this).data).fieldIndexes[i]));
                        continue block6;
                    }
                    case 1: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutputData)((JsonOutput)JsonOutput.this).data).inputRowMeta.getNumber(row, ((JsonOutputData)((JsonOutput)JsonOutput.this).data).fieldIndexes[i]));
                        continue block6;
                    }
                    case 6: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutputData)((JsonOutput)JsonOutput.this).data).inputRowMeta.getBigNumber(row, ((JsonOutputData)((JsonOutput)JsonOutput.this).data).fieldIndexes[i]));
                        continue block6;
                    }
                    default: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutputData)((JsonOutput)JsonOutput.this).data).inputRowMeta.getString(row, ((JsonOutputData)((JsonOutput)JsonOutput.this).data).fieldIndexes[i]));
                    }
                }
            }
            ((JsonOutputData)((JsonOutput)JsonOutput.this).data).ja.add((Object)jo);
            ++((JsonOutputData)((JsonOutput)JsonOutput.this).data).nrRow;
            if (((JsonOutputData)((JsonOutput)JsonOutput.this).data).nrRowsInBloc > 0 && ((JsonOutputData)((JsonOutput)JsonOutput.this).data).nrRow % ((JsonOutputData)((JsonOutput)JsonOutput.this).data).nrRowsInBloc == 0) {
                JsonOutput.this.outputRow(row);
            }
        }
    }

    private class CompatibilityMode
    implements CompatibilityFactory {
        private CompatibilityMode() {
        }

        @Override
        public void execute(Object[] row) throws HopException {
            for (int i = 0; i < ((JsonOutputData)((JsonOutput)JsonOutput.this).data).nrFields; ++i) {
                JsonOutputField outputField = ((JsonOutputMeta)JsonOutput.this.meta).getOutputFields().get(i);
                IValueMeta v = ((JsonOutputData)((JsonOutput)JsonOutput.this).data).inputRowMeta.getValueMeta(((JsonOutputData)((JsonOutput)JsonOutput.this).data).fieldIndexes[i]);
                JSONObject jo = new JSONObject();
                switch (v.getType()) {
                    case 4: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutputData)((JsonOutput)JsonOutput.this).data).inputRowMeta.getBoolean(row, ((JsonOutputData)((JsonOutput)JsonOutput.this).data).fieldIndexes[i]));
                        break;
                    }
                    case 5: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutputData)((JsonOutput)JsonOutput.this).data).inputRowMeta.getInteger(row, ((JsonOutputData)((JsonOutput)JsonOutput.this).data).fieldIndexes[i]));
                        break;
                    }
                    case 1: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutputData)((JsonOutput)JsonOutput.this).data).inputRowMeta.getNumber(row, ((JsonOutputData)((JsonOutput)JsonOutput.this).data).fieldIndexes[i]));
                        break;
                    }
                    case 6: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutputData)((JsonOutput)JsonOutput.this).data).inputRowMeta.getBigNumber(row, ((JsonOutputData)((JsonOutput)JsonOutput.this).data).fieldIndexes[i]));
                        break;
                    }
                    default: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutputData)((JsonOutput)JsonOutput.this).data).inputRowMeta.getString(row, ((JsonOutputData)((JsonOutput)JsonOutput.this).data).fieldIndexes[i]));
                    }
                }
                ((JsonOutputData)((JsonOutput)JsonOutput.this).data).ja.add((Object)jo);
            }
            ++((JsonOutputData)((JsonOutput)JsonOutput.this).data).nrRow;
            if (((JsonOutputData)((JsonOutput)JsonOutput.this).data).nrRowsInBloc > 0 && ((JsonOutputData)((JsonOutput)JsonOutput.this).data).nrRow % ((JsonOutputData)((JsonOutput)JsonOutput.this).data).nrRowsInBloc == 0) {
                JsonOutput.this.outputRow(row);
            }
        }
    }

    private static interface CompatibilityFactory {
        public void execute(Object[] var1) throws HopException;
    }
}

