/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import io.grpc.stub.ClientCallStreamObserver;
import javax.annotation.Nullable;

@InternalApi(value="For internal usage only")
public class CallController<RequestT, ResponseT>
extends ClientCallStreamObserver<RequestT> {
    private static final ClientCall NULL_CALL = new ClientCall(){

        public void start(ClientCall.Listener responseListener, Metadata headers) {
        }

        public void request(int numMessages) {
        }

        public void cancel(String message, Throwable cause) {
        }

        public void halfClose() {
        }

        public void sendMessage(Object message) {
        }
    };
    private boolean autoFlowControlEnabled = true;
    private ClientCall<RequestT, ResponseT> call = NULL_CALL;

    synchronized void resetCall() {
        this.call = NULL_CALL;
    }

    synchronized void setCallAndStart(BigtableAsyncRpc<RequestT, ResponseT> rpc, CallOptions callOptions, RequestT request, ClientCall.Listener<ResponseT> listener, Metadata metadata) {
        this.call = rpc.newCall(callOptions);
        rpc.start(request, listener, metadata, this.call);
    }

    public void onNext(RequestT value) {
        throw new UnsupportedOperationException("onNext() and client-streaming are not supported.");
    }

    public void onError(Throwable t) {
        this.cancel("Cancelled by client with StreamObserver.onError()", t);
    }

    public void onCompleted() {
        throw new UnsupportedOperationException("onCompleted() and client-streaming are not supported.");
    }

    public synchronized boolean isReady() {
        return this.call.isReady();
    }

    public void setOnReadyHandler(Runnable onReadyHandler) {
        throw new UnsupportedOperationException("setOnReadHandler");
    }

    public void disableAutoInboundFlowControl() {
        this.autoFlowControlEnabled = false;
    }

    public synchronized void request(int count) {
        this.call.request(count);
    }

    public void setMessageCompression(boolean enable) {
        throw new UnsupportedOperationException("setMessageCompression()");
    }

    public synchronized void cancel(@Nullable String s, @Nullable Throwable throwable) {
        this.call.cancel(s, throwable);
    }

    public boolean isAutoFlowControlEnabled() {
        return this.autoFlowControlEnabled;
    }
}

