/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.MessageUtilities;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VMessage;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

class MessagePropertiesPane
implements VPropertiesPane {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String dateText_ = ResourceLoader.getText("MESSAGE_DATE") + ": ";
    private static final String generalTabText_ = ResourceLoader.getText("TAB_GENERAL");
    private static final String messageFileText_ = ResourceLoader.getText("MESSAGE_FILE") + ": ";
    private static final String severityText_ = ResourceLoader.getText("MESSAGE_SEVERITY") + ": ";
    private static final String typeText_ = ResourceLoader.getText("MESSAGE_TYPE") + ": ";
    private static DateFormat dateFormat_ = DateFormat.getDateTimeInstance();
    private AS400Message message_;
    private VMessage object_;
    private ChangeEventSupport changeEventSupport_ = new ChangeEventSupport(this);
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private VObjectEventSupport objectEventSupport_ = new VObjectEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);

    public MessagePropertiesPane(VMessage vMessage, AS400Message aS400Message) {
        this.object_ = vMessage;
        this.message_ = aS400Message;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventSupport_.addChangeListener(changeListener);
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public void applyChanges() throws Exception {
    }

    public Component getComponent() {
        Serializable serializable;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int n = 0;
        VUtilities.constrain(new JLabel(this.object_.getText(), this.object_.getIcon(32, false), 2), jPanel, gridBagLayout, 0, n++, 2, 1);
        JTextArea jTextArea = new JTextArea(this.message_.getText());
        jTextArea.setEditable(false);
        jTextArea.setBackground(jPanel.getBackground());
        jTextArea.setColumns(40);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        VUtilities.constrain(jTextArea, jPanel, gridBagLayout, 0, n++, 2, 1);
        String string = this.message_.getHelp();
        if (string != null && string.length() > 0) {
            serializable = new JTextArea(string);
            ((JTextComponent)serializable).setEditable(false);
            ((JComponent)serializable).setBackground(jPanel.getBackground());
            ((JTextArea)serializable).setColumns(40);
            ((JTextArea)serializable).setLineWrap(true);
            ((JTextArea)serializable).setWrapStyleWord(true);
            VUtilities.constrain((Component)serializable, jPanel, gridBagLayout, 0, n++, 2, 1);
        }
        VUtilities.constrain(new JSeparator(), jPanel, gridBagLayout, 0, n++, 2, 1);
        VUtilities.constrain(new JLabel(severityText_), jPanel, gridBagLayout, 0, n, 1, 1);
        VUtilities.constrain(new JLabel(Integer.toString(this.message_.getSeverity())), jPanel, gridBagLayout, 1, n, 1, 1);
        VUtilities.constrain(new JLabel(typeText_), jPanel, gridBagLayout, 0, ++n, 1, 1);
        VUtilities.constrain(new JLabel(MessageUtilities.getTypeText(this.message_.getType())), jPanel, gridBagLayout, 1, n, 1, 1);
        VUtilities.constrain(new JLabel(dateText_), jPanel, gridBagLayout, 0, ++n, 1, 1);
        serializable = this.message_.getDate();
        if (serializable != null) {
            VUtilities.constrain(new JLabel(dateFormat_.format(((Calendar)serializable).getTime())), jPanel, gridBagLayout, 1, n, 1, 1);
        }
        int n2 = ++n;
        VUtilities.constrain(new JSeparator(), jPanel, gridBagLayout, 0, n2, 2, 1);
        VUtilities.constrain(new JLabel(messageFileText_), jPanel, gridBagLayout, 0, ++n, 1, 1);
        VUtilities.constrain(new JLabel(this.message_.getPath()), jPanel, gridBagLayout, 1, n, 1, 1);
        ++n;
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(generalTabText_, null, jPanel);
        jTabbedPane.setSelectedIndex(0);
        return jTabbedPane;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeEventSupport_.removeChangeListener(changeListener);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    static {
        dateFormat_.setTimeZone(TimeZone.getDefault());
    }
}

