/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.SystemPool;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.WorkingEvent;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class VSystemPoolModifyDialog
extends JDialog
implements ActionListener,
WindowListener {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String invalidInputText_ = ResourceLoader.getText("DLG_INVALID_INPUT") + ": ";
    private static final String maximumFalutsText_ = ResourceLoader.getText("SYSTEM_POOL_MAXIMUM_FAULTS") + ": ";
    private static final String maximumPoolSizeText_ = ResourceLoader.getText("SYSTEM_POOL_MAXIMUM_POOL_SIZE") + ": ";
    private static final String messageLoggingText_ = ResourceLoader.getText("SYSTEM_POOL_MESSAGE_LOGGING") + ": ";
    private static final String minimumFaultsText_ = ResourceLoader.getText("SYSTEM_POOL_MINIMUM_FAULTS") + ": ";
    private static final String minimumPoolSizeText_ = ResourceLoader.getText("SYSTEM_POOL_MINIMUM_POOL_SIZE") + ": ";
    private static final String newActivityLevelText_ = ResourceLoader.getText("SYSTEM_POOL_ACTIVITY_LEVEL") + ": ";
    private static final String newPoolSizeText_ = ResourceLoader.getText("SYSTEM_POOL_POOL_SIZE") + ": ";
    private static final String pagingOptionText_ = ResourceLoader.getText("SYSTEM_POOL_PAGING_OPTION") + ": ";
    private static final String perThreadFaultsText_ = ResourceLoader.getText("SYSTEM_POOL_PERTHREADS_FAULTS") + ": ";
    private static final String priorityText_ = ResourceLoader.getText("SYSTEM_POOL_PRIORITY") + ": ";
    private static final String systemPoolIdentifierText_ = ResourceLoader.getText("SYSTEM_POOL_IDENTIFIER") + ": ";
    private static final String title_ = ResourceLoader.getText("DLG_MODIFY");
    private static final String same_ = "*SAME";
    private static final String calc_ = "*CALC";
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private WorkingEventSupport workingEventSupport_ = new WorkingEventSupport(this);
    private SystemPool sysPool_ = null;
    private String sysPoolID_ = "";
    private JTextField sysPoolNewPoolSiz_ = null;
    private JComboBox sysPoolNewPoolActLev_ = null;
    private JComboBox sysPoolMesLog_ = null;
    private JComboBox sysPoolPagOpt_ = null;
    private JComboBox sysPoolPri_ = null;
    private JComboBox sysPoolMinPoolSiz_ = null;
    private JComboBox sysPoolMaxPoolSiz_ = null;
    private JComboBox sysPoolMinFau_ = null;
    private JComboBox sysPoolPerThrFau_ = null;
    private JComboBox sysPoolMaxFau_ = null;
    private JButton applyButton_ = null;
    private JButton cancelButton_ = null;
    private JButton okButton_ = null;
    private boolean isMachinePool_;

    public VSystemPoolModifyDialog(Frame frame, SystemPool systemPool) {
        super(frame, title_, true);
        this.sysPool_ = systemPool;
        this.isMachinePool_ = this.sysPool_.getPoolName().trim().equalsIgnoreCase("*MACHINE");
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton_) {
            if (!this.applyButton_.isEnabled()) {
                this.dispose();
            } else if (this.setChanges()) {
                this.dispose();
            }
        } else if (object == this.applyButton_) {
            if (this.setChanges()) {
                this.applyButton_.setEnabled(false);
            }
        } else if (object == this.cancelButton_) {
            this.dispose();
        }
        this.sysPool_.refreshCache();
    }

    public void addErrorListener(ErrorListener errorListener) {
        if (errorListener == null) {
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        if (workingListener == null) {
            throw new NullPointerException("listener");
        }
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    private JPanel getMainPane() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        int n = 0;
        VUtilities.constrain(systemPoolIdentifierText_, this.sysPoolID_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(newPoolSizeText_), this.sysPoolNewPoolSiz_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(newActivityLevelText_), this.sysPoolNewPoolActLev_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(messageLoggingText_), this.sysPoolMesLog_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(pagingOptionText_), this.sysPoolPagOpt_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(priorityText_), this.sysPoolPri_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(minimumPoolSizeText_), this.sysPoolMinPoolSiz_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(maximumPoolSizeText_), this.sysPoolMaxPoolSiz_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(minimumFaultsText_), this.sysPoolMinFau_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(perThreadFaultsText_), this.sysPoolPerThrFau_, jPanel, gridBagLayout, n++);
        VUtilities.constrain(new JLabel(maximumFalutsText_), this.sysPoolMaxFau_, jPanel, gridBagLayout, n++);
        return jPanel;
    }

    private void init() {
        try {
            this.sysPoolID_ = Integer.toString(this.sysPool_.getPoolIdentifier());
            VSPMDListener vSPMDListener = null;
            this.sysPoolNewPoolSiz_ = new JTextField();
            String string = String.valueOf(this.sysPool_.getPoolSize());
            this.sysPoolNewPoolSiz_.setText(string);
            if (this.sysPool_.getPoolName().trim().equals("*BASE")) {
                this.sysPoolNewPoolSiz_.setEditable(false);
            } else {
                this.sysPoolNewPoolSiz_.setEditable(true);
            }
            this.sysPoolNewPoolSiz_.addKeyListener(new VSPMDListener());
            this.sysPoolNewPoolActLev_ = new JComboBox();
            this.sysPoolNewPoolActLev_.addItem(same_);
            this.sysPoolNewPoolActLev_.setSelectedItem(same_);
            if (this.isMachinePool_) {
                this.sysPoolNewPoolActLev_.setEditable(false);
                this.sysPoolNewPoolActLev_.setEnabled(false);
            } else {
                this.sysPoolNewPoolActLev_.setEditable(true);
                this.sysPoolNewPoolActLev_.setEnabled(true);
            }
            vSPMDListener = new VSPMDListener(this.sysPoolNewPoolActLev_);
            this.sysPoolMesLog_ = new JComboBox();
            this.sysPoolMesLog_.setEditable(false);
            this.sysPoolMesLog_.addItem(ResourceLoader.getText("DLG_YES"));
            this.sysPoolMesLog_.addItem(ResourceLoader.getText("DLG_NO"));
            this.sysPoolMesLog_.setSelectedItem(ResourceLoader.getText("DLG_YES"));
            vSPMDListener = new VSPMDListener(this.sysPoolMesLog_);
            this.sysPoolPagOpt_ = new JComboBox();
            this.sysPoolPagOpt_.setEditable(false);
            String string2 = this.sysPool_.getPagingOption().trim();
            if (!string2.equals("*FIXED") && !string2.equals(calc_)) {
                this.sysPoolPagOpt_.addItem(string2);
            }
            this.sysPoolPagOpt_.addItem("*FIXED");
            this.sysPoolPagOpt_.addItem(calc_);
            this.sysPoolPagOpt_.setSelectedItem(string2);
            if (this.isMachinePool_) {
                this.sysPoolPagOpt_.setEnabled(false);
            }
            vSPMDListener = new VSPMDListener(this.sysPoolPagOpt_);
            this.sysPoolPri_ = new JComboBox();
            if (this.isMachinePool_) {
                this.sysPoolPri_.addItem("1");
                this.sysPoolPri_.setSelectedItem("1");
                this.sysPoolPri_.setEditable(false);
                this.sysPoolPri_.setEnabled(false);
            } else {
                this.sysPoolPri_.addItem(same_);
                this.sysPoolPri_.addItem(calc_);
                this.sysPoolPri_.setEditable(true);
                this.sysPoolPri_.setEnabled(true);
            }
            vSPMDListener = new VSPMDListener(this.sysPoolPri_);
            this.sysPoolMinPoolSiz_ = new JComboBox();
            this.sysPoolMinPoolSiz_.setEditable(true);
            this.sysPoolMinPoolSiz_.addItem(same_);
            this.sysPoolMinPoolSiz_.addItem(calc_);
            this.sysPoolMinPoolSiz_.setSelectedItem(same_);
            vSPMDListener = new VSPMDListener(this.sysPoolMinPoolSiz_);
            this.sysPoolMaxPoolSiz_ = new JComboBox();
            this.sysPoolMaxPoolSiz_.setEditable(true);
            this.sysPoolMaxPoolSiz_.addItem(same_);
            this.sysPoolMaxPoolSiz_.addItem(calc_);
            this.sysPoolMaxPoolSiz_.setSelectedItem(same_);
            vSPMDListener = new VSPMDListener(this.sysPoolMaxPoolSiz_);
            this.sysPoolMinFau_ = new JComboBox();
            this.sysPoolMinFau_.setEditable(true);
            this.sysPoolMinFau_.addItem(same_);
            this.sysPoolMinFau_.addItem(calc_);
            this.sysPoolMinFau_.setSelectedItem(same_);
            vSPMDListener = new VSPMDListener(this.sysPoolMinFau_);
            this.sysPoolPerThrFau_ = new JComboBox();
            this.sysPoolPerThrFau_.setEditable(true);
            this.sysPoolPerThrFau_.addItem(same_);
            this.sysPoolPerThrFau_.addItem(calc_);
            this.sysPoolPerThrFau_.setSelectedItem(same_);
            vSPMDListener = new VSPMDListener(this.sysPoolPerThrFau_);
            this.sysPoolMaxFau_ = new JComboBox();
            this.sysPoolMaxFau_.setEditable(true);
            this.sysPoolMaxFau_.addItem(same_);
            this.sysPoolMaxFau_.addItem(calc_);
            this.sysPoolMaxFau_.setSelectedItem(same_);
            vSPMDListener = new VSPMDListener(this.sysPoolMaxFau_);
            this.okButton_ = new JButton(ResourceLoader.getText("DLG_OK"));
            this.cancelButton_ = new JButton(ResourceLoader.getText("DLG_CANCEL"));
            this.applyButton_ = new JButton(ResourceLoader.getText("DLG_APPLY"));
            this.applyButton_.setEnabled(false);
            this.okButton_.addActionListener(this);
            this.cancelButton_.addActionListener(this);
            this.applyButton_.addActionListener(this);
            this.addWindowListener(this);
            JPanel jPanel = new JPanel();
            jPanel.add(this.okButton_);
            jPanel.add(this.cancelButton_);
            jPanel.add(this.applyButton_);
            Container container = this.getContentPane();
            container.add("North", this.getMainPane());
            container.add("South", jPanel);
            this.pack();
        }
        catch (Exception exception) {
            Trace.log(2, "Unable to create VSystemPoolModifyDialog.", (Throwable)exception);
            this.errorEventSupport_.fireError(exception);
        }
    }

    public void removeErrorListener(ErrorListener errorListener) {
        if (errorListener == null) {
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        if (workingListener == null) {
            throw new NullPointerException("listener");
        }
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    private boolean setChanges() {
        this.workingEventSupport_.fireStartWorking();
        boolean bl = this.sysPool_.isCaching();
        this.sysPool_.setCaching(true);
        try {
            String string = this.sysPoolNewPoolSiz_.getText().trim();
            if (!string.equals(same_) && string.length() > 0) {
                this.sysPool_.setPoolSize(Integer.parseInt(string));
            }
            if (!this.isMachinePool_ && !(string = this.sysPoolNewPoolActLev_.getSelectedItem().toString().trim()).equals(same_) && string.length() > 0) {
                this.sysPool_.setPoolActivityLevel(Integer.parseInt(string));
            }
            string = this.sysPoolMesLog_.getSelectedItem().toString();
            this.sysPool_.setMessageLogging(string.equals(ResourceLoader.getText("DLG_YES")));
            if (!this.isMachinePool_) {
                string = this.sysPoolPagOpt_.getSelectedItem().toString();
                this.sysPool_.setPagingOption(string);
            }
            if (!this.isMachinePool_) {
                string = this.sysPoolPri_.getSelectedItem().toString().trim();
                if (string.equals(calc_)) {
                    this.sysPool_.setPriority(-2);
                } else if (!string.equals(same_) && string.length() > 0) {
                    this.sysPool_.setPriority(Integer.parseInt(string));
                }
            }
            if ((string = this.sysPoolMinPoolSiz_.getSelectedItem().toString().trim()).equals(calc_)) {
                this.sysPool_.setMinimumPoolSize(-2.0f);
            } else if (!string.equals(same_) && string.length() > 0) {
                this.sysPool_.setMinimumPoolSize(Float.valueOf(string).floatValue());
            }
            string = this.sysPoolMaxPoolSiz_.getSelectedItem().toString().trim();
            if (string.equals(calc_)) {
                this.sysPool_.setMaximumPoolSize(-2.0f);
            } else if (!string.equals(same_) && string.length() > 0) {
                this.sysPool_.setMaximumPoolSize(Float.valueOf(string).floatValue());
            }
            string = this.sysPoolMinFau_.getSelectedItem().toString().trim();
            if (string.equals(calc_)) {
                this.sysPool_.setMinimumFaults(-2.0f);
            } else if (!string.equals(same_) && string.length() > 0) {
                this.sysPool_.setMinimumFaults(Float.valueOf(string).floatValue());
            }
            string = this.sysPoolPerThrFau_.getSelectedItem().toString().trim();
            if (string.equals(calc_)) {
                this.sysPool_.setPerThreadFaults(-2.0f);
            } else if (!string.equals(same_) && string.length() > 0) {
                this.sysPool_.setPerThreadFaults(Float.valueOf(string).floatValue());
            }
            string = this.sysPoolMaxFau_.getSelectedItem().toString().trim();
            if (string.equals(calc_)) {
                this.sysPool_.setMaximumFaults(-2.0f);
            } else if (!string.equals(same_) && string.length() > 0) {
                this.sysPool_.setMaximumFaults(Float.valueOf(string).floatValue());
            }
            this.sysPool_.commitCache();
            this.workingEventSupport_.fireStopWorking();
            this.sysPool_.setCaching(bl);
            this.sysPool_.refreshCache();
        }
        catch (Exception exception) {
            this.workingEventSupport_.fireStopWorking();
            this.sysPool_.setCaching(bl);
            this.sysPool_.refreshCache();
            if (Trace.isTraceOn()) {
                Trace.log(2, "Unable to set values in VSystemPoolModifyDialog.", (Throwable)exception);
            }
            this.errorEventSupport_.fireError(exception);
            return false;
        }
        return true;
    }

    public void startWorking(WorkingEvent workingEvent) {
        this.workingEventSupport_.startWorking(workingEvent);
    }

    public void stopWorking(WorkingEvent workingEvent) {
        this.workingEventSupport_.stopWorking(workingEvent);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.dispose();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private class VSPMDListener
    implements KeyListener,
    ItemListener {
        VSPMDListener() {
        }

        VSPMDListener(JComboBox jComboBox) {
            jComboBox.addItemListener(this);
            jComboBox.getEditor().getEditorComponent().addKeyListener(this);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            VSystemPoolModifyDialog.this.applyButton_.setEnabled(true);
        }

        public void keyPressed(KeyEvent keyEvent) {
            VSystemPoolModifyDialog.this.applyButton_.setEnabled(true);
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

