/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.columnsexist;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.columnsexist.ActionColumnsExist;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionColumnsExistDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionColumnsExist.class;
    private Text wName;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextVar wTablename;
    private ActionColumnsExist action;
    private boolean changed;
    private TableView wFields;
    private TextVar wSchemaname;

    public ActionColumnsExistDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (ActionColumnsExist)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        int rows;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, 0);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wName, this.action.getDatabase(), lsMod);
        Label wlSchemaname = new Label((Composite)this.shell, 131072);
        wlSchemaname.setText(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Schemaname.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchemaname);
        FormData fdlSchemaname = new FormData();
        fdlSchemaname.left = new FormAttachment(0, 0);
        fdlSchemaname.right = new FormAttachment(middle, -margin);
        fdlSchemaname.top = new FormAttachment(this.wConnection, 2 * margin);
        wlSchemaname.setLayoutData((Object)fdlSchemaname);
        Button wbSchema = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbSchema);
        wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbSchema = new FormData();
        fdbSchema.top = new FormAttachment(this.wConnection, 2 * margin);
        fdbSchema.right = new FormAttachment(100, 0);
        wbSchema.setLayoutData((Object)fdbSchema);
        wbSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionColumnsExistDialog.this.getSchemaNames();
            }
        });
        this.wSchemaname = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSchemaname);
        this.wSchemaname.setToolTipText(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Schemaname.Tooltip", (String[])new String[0]));
        this.wSchemaname.addModifyListener(lsMod);
        FormData fdSchemaname = new FormData();
        fdSchemaname.left = new FormAttachment(middle, 0);
        fdSchemaname.top = new FormAttachment(this.wConnection, 2 * margin);
        fdSchemaname.right = new FormAttachment((Control)wbSchema, -margin);
        this.wSchemaname.setLayoutData((Object)fdSchemaname);
        Label wlTablename = new Label((Composite)this.shell, 131072);
        wlTablename.setText(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Tablename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTablename);
        FormData fdlTablename = new FormData();
        fdlTablename.left = new FormAttachment(0, 0);
        fdlTablename.right = new FormAttachment(middle, -margin);
        fdlTablename.top = new FormAttachment((Control)wbSchema, margin);
        wlTablename.setLayoutData((Object)fdlTablename);
        Button wbTable = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)wbSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionColumnsExistDialog.this.getTableName();
            }
        });
        this.wTablename = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTablename);
        this.wTablename.addModifyListener(lsMod);
        FormData fdTablename = new FormData();
        fdTablename.left = new FormAttachment(middle, 0);
        fdTablename.top = new FormAttachment((Control)wbSchema, margin);
        fdTablename.right = new FormAttachment((Control)wbTable, -margin);
        this.wTablename.setLayoutData((Object)fdTablename);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.right = new FormAttachment(middle, -margin);
        fdlFields.top = new FormAttachment((Control)this.wTablename, 3 * margin);
        wlFields.setLayoutData((Object)fdlFields);
        Button wbGetColumns = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbGetColumns);
        wbGetColumns.setText(BaseMessages.getString(PKG, (String)"ActionColumnsExist.GetColums.Button", (String[])new String[0]));
        wbGetColumns.setToolTipText(BaseMessages.getString(PKG, (String)"ActionColumnsExist.GetColums.Tooltip", (String[])new String[0]));
        FormData fdbGetColumns = new FormData();
        fdbGetColumns.right = new FormAttachment(100, 0);
        fdbGetColumns.top = new FormAttachment((Control)wlFields, margin);
        wbGetColumns.setLayoutData((Object)fdbGetColumns);
        Button wbdFilename = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbdFilename);
        wbdFilename.setText(BaseMessages.getString(PKG, (String)"ActionColumnsExist.FilenameDelete.Button", (String[])new String[0]));
        wbdFilename.setToolTipText(BaseMessages.getString(PKG, (String)"ActionColumnsExist.FilenameDelete.Tooltip", (String[])new String[0]));
        FormData fdbdFilename = new FormData();
        fdbdFilename.right = new FormAttachment(100, 0);
        fdbdFilename.left = new FormAttachment((Control)wbGetColumns, 0, 16384);
        fdbdFilename.top = new FormAttachment((Control)wbGetColumns, margin);
        wbdFilename.setLayoutData((Object)fdbdFilename);
        int FieldsRows = rows = this.action.getArguments() == null ? 1 : (this.action.getArguments().length == 0 ? 0 : this.action.getArguments().length);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Fields.Argument.Label", (String[])new String[0]), 1, false)};
        colinf[0].setUsingVariables(true);
        colinf[0].setToolTip(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Fields.Column", (String[])new String[0]));
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment((Control)wbGetColumns, -margin);
        fdFields.bottom = new FormAttachment((Control)wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        wbdFilename.addListener(13, e -> {
            int[] idx = this.wFields.getSelectionIndices();
            this.wFields.remove(idx);
            this.wFields.removeEmptyRows();
            this.wFields.setRowNums();
        });
        wbGetColumns.addListener(13, e -> this.getListColumns());
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void getTableName() {
        String databaseName = this.wConnection.getText();
        if (StringUtils.isNotEmpty((String)databaseName)) {
            DatabaseMeta databaseMeta = this.getWorkflowMeta().findDatabase(databaseName);
            if (databaseMeta != null) {
                DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.getWorkflowMeta().getDatabases());
                std.setSelectedSchemaAndTable(this.wSchemaname.getText(), this.wTablename.getText());
                if (std.open()) {
                    this.wSchemaname.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                    this.wTablename.setText(Const.NVL((String)std.getTableName(), (String)""));
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"ActionColumnsExist.ConnectionError.DialogMessage", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                mb.open();
            }
        }
    }

    public void getData() {
        if (this.action.getName() != null) {
            this.wName.setText(this.action.getName());
        }
        if (this.action.getTablename() != null) {
            this.wTablename.setText(this.action.getTablename());
        }
        if (this.action.getSchemaname() != null) {
            this.wSchemaname.setText(this.action.getSchemaname());
        }
        if (this.action.getDatabase() != null) {
            this.wConnection.setText(this.action.getDatabase().getName());
        }
        if (this.action.getArguments() != null) {
            for (int i = 0; i < this.action.getArguments().length; ++i) {
                TableItem ti = this.wFields.table.getItem(i);
                if (this.action.getArguments()[i] == null) continue;
                ti.setText(1, this.action.getArguments()[i]);
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setDatabase(this.getWorkflowMeta().findDatabase(this.wConnection.getText()));
        this.action.setTablename(this.wTablename.getText());
        this.action.setSchemaname(this.wSchemaname.getText());
        int nrItems = this.wFields.nrNonEmpty();
        int nr = 0;
        for (int i = 0; i < nrItems; ++i) {
            String arg = this.wFields.getNonEmpty(i).getText(1);
            if (arg == null || arg.length() == 0) continue;
            ++nr;
        }
        String[] args = new String[nr];
        nr = 0;
        for (int i = 0; i < nrItems; ++i) {
            String arg = this.wFields.getNonEmpty(i).getText(1);
            if (arg == null || arg.length() == 0) continue;
            args[nr] = arg;
            ++nr;
        }
        this.action.setArguments(args);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getListColumns() {
        DatabaseMeta databaseMeta;
        if (!Utils.isEmpty((CharSequence)this.wTablename.getText()) && (databaseMeta = this.getWorkflowMeta().findDatabase(this.wConnection.getText())) != null) {
            Database database = new Database(loggingObject, this.variables, databaseMeta);
            try {
                database.connect();
                IRowMeta row = database.getTableFieldsMeta(this.variables.resolve(this.wSchemaname.getText()), this.variables.resolve(this.wTablename.getText()));
                if (row != null) {
                    String[] available = row.getFieldNames();
                    this.wFields.removeAll();
                    for (String s : available) {
                        this.wFields.add(new String[]{s});
                    }
                    this.wFields.removeEmptyRows();
                    this.wFields.setRowNums();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"ActionColumnsExist.GetListColumsNoRow.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionColumnsExist.ConnectionError2.DialogMessage", (String[])new String[]{this.wTablename.getText()}), e);
            }
            finally {
                database.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSchemaNames() {
        if (this.wSchemaname.isDisposed()) {
            return;
        }
        DatabaseMeta databaseMeta = this.getWorkflowMeta().findDatabase(this.wConnection.getText());
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, this.variables, databaseMeta);
            try {
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Message", (String[])new String[0]));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchemaname.setText(Const.NVL((String)d, (String)""));
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Empty.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Empty.Title", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.ConnectionError", (String[])new String[0]), e);
            }
            finally {
                if (database != null) {
                    database.disconnect();
                    database = null;
                }
            }
        }
    }
}

