/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.IHopAttribute;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.value.timestamp.SimpleTimestampFormat;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.DTDIgnoringEntityResolver;
import org.apache.hop.core.xml.XMlHandlerCacheEntry;
import org.apache.hop.core.xml.XmlHandlerCache;
import org.apache.hop.core.xml.XmlParserFactoryProducer;
import org.owasp.encoder.Encode;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlHandler {
    private static XmlHandlerCache cache = XmlHandlerCache.getInstance();
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private static final SimpleTimestampFormat simpleTimeStampFormat = new SimpleTimestampFormat("yyyy/MM/dd HH:mm:ss.SSSSSSSSS");

    private XmlHandler() {
    }

    public static String getXmlHeader() {
        return XmlHandler.getXmlHeader("UTF-8");
    }

    public static String getXmlHeader(String encoding) {
        return "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>" + Const.CR;
    }

    public static String getTagValue(Node n, IHopAttribute code) {
        return XmlHandler.getTagValue(n, code.getXmlCode());
    }

    public static String getTagValue(Node n, String tag) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || childnode.getFirstChild() == null) continue;
            return childnode.getFirstChild().getNodeValue();
        }
        return null;
    }

    public static boolean getTagBoolean(Node n, String tag) {
        return XmlHandler.getTagBoolean(n, tag, false);
    }

    public static boolean getTagBoolean(Node n, String tag, boolean defaultWhenNotFound) {
        String value = XmlHandler.getTagValue(n, tag);
        if (StringUtils.isEmpty((String)value)) {
            return defaultWhenNotFound;
        }
        return "y".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
    }

    public static String getTagValueWithAttribute(Node n, String tag, String attribute) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || childnode.getAttributes().getNamedItem(attribute) == null || childnode.getFirstChild() == null) continue;
            return childnode.getFirstChild().getNodeValue();
        }
        return null;
    }

    public static String getTagValue(Node n, String tag, String subtag) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            NodeList tags = childnode.getChildNodes();
            for (int j = 0; j < tags.getLength(); ++j) {
                Node tagnode = tags.item(j);
                if (!tagnode.getNodeName().equalsIgnoreCase(subtag) || tagnode.getFirstChild() == null) continue;
                return tagnode.getFirstChild().getNodeValue();
            }
        }
        return null;
    }

    public static int countNodes(Node n, String tag) {
        if (n == null) {
            return 0;
        }
        int count = 0;
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            ++count;
        }
        return count;
    }

    public static List<Node> getNodes(Node n, String tag) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (n == null) {
            return nodes;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            nodes.add(childnode);
        }
        return nodes;
    }

    public static Node getNodeWithTagValue(Node n, String tag, String subtag, String subtagvalue, int nr) {
        int count = 0;
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node tagnode;
            String value;
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || (value = XmlHandler.getNodeValue(tagnode = XmlHandler.getSubNode(childnode, subtag))) == null || !value.equalsIgnoreCase(subtagvalue)) continue;
            if (count == nr) {
                return childnode;
            }
            ++count;
        }
        return null;
    }

    public static Node getNodeWithAttributeValue(Node n, String tag, String attributeName, String attributeValue) {
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node attribute;
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag) || (attribute = childnode.getAttributes().getNamedItem(attributeName)) == null || !attributeValue.equals(attribute.getTextContent())) continue;
            return childnode;
        }
        return null;
    }

    public static Node getSubNode(Node n, String tag) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            return childnode;
        }
        return null;
    }

    public static Node getLastSubNode(Node n, String tag) {
        if (null != n) {
            NodeList children = n.getChildNodes();
            int i = children.getLength();
            while (i > 0) {
                Node childNode;
                if (!(childNode = children.item(--i)).getNodeName().equalsIgnoreCase(tag)) continue;
                return childNode;
            }
        }
        return null;
    }

    public static Node getSubNode(Node n, String tag, String subtag) {
        Node t = XmlHandler.getSubNode(n, tag);
        if (t != null) {
            return XmlHandler.getSubNode(t, subtag);
        }
        return null;
    }

    public static Node getSubNodeByNr(Node n, String tag, int nr) {
        return XmlHandler.getSubNodeByNr(n, tag, nr, true);
    }

    public static Node getSubNodeByNr(Node n, String tag, int nr, boolean useCache) {
        if (n == null) {
            return null;
        }
        int count = 0;
        NodeList children = n.getChildNodes();
        int lastChildNr = -1;
        XMlHandlerCacheEntry entry = null;
        if (useCache) {
            entry = new XMlHandlerCacheEntry(n, tag);
            lastChildNr = cache.getLastChildNr(entry);
        }
        if (lastChildNr < 0) {
            lastChildNr = 0;
        } else {
            count = nr;
            ++lastChildNr;
        }
        for (int i = lastChildNr; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            if (!childnode.getNodeName().equalsIgnoreCase(tag)) continue;
            if (count == nr) {
                if (useCache) {
                    cache.storeCache(entry, i);
                }
                return childnode;
            }
            ++count;
        }
        return null;
    }

    public static String getNodeValue(Node n) {
        if (n == null) {
            return null;
        }
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childnode = children.item(i);
            String retval = childnode.getNodeValue();
            if (retval == null) continue;
            return retval;
        }
        return null;
    }

    public static String getTagAttribute(Node node, String attribute) {
        Node attr;
        if (node == null) {
            return null;
        }
        String retval = null;
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null && (attr = nnm.getNamedItem(attribute)) != null) {
            retval = attr.getNodeValue();
        }
        return retval;
    }

    public static Document loadXmlFile(String filename) throws HopXmlException {
        try {
            return XmlHandler.loadXmlFile(HopVfs.getFileObject(filename));
        }
        catch (Exception e) {
            throw new HopXmlException(e);
        }
    }

    public static Document loadXmlFile(FileObject fileObject) throws HopXmlException {
        return XmlHandler.loadXmlFile(fileObject, null, false, false);
    }

    public static Document loadXmlFile(FileObject fileObject, String systemID, boolean ignoreEntities, boolean namespaceAware) throws HopXmlException {
        try {
            return XmlHandler.loadXmlFile(HopVfs.getInputStream(fileObject), systemID, ignoreEntities, namespaceAware);
        }
        catch (IOException e) {
            throw new HopXmlException("Unable to read file [" + fileObject.toString() + "]", e);
        }
    }

    public static Document loadXmlFile(InputStream inputStream) throws HopXmlException {
        return XmlHandler.loadXmlFile(inputStream, null, false, false);
    }

    public static Document loadXmlFile(InputStream inputStream, String systemID, boolean ignoreEntities, boolean namespaceAware) throws HopXmlException {
        try {
            Document doc;
            DocumentBuilderFactory dbf = XmlParserFactoryProducer.createSecureDocBuilderFactory();
            dbf.setIgnoringComments(true);
            dbf.setNamespaceAware(namespaceAware);
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (ignoreEntities) {
                db.setEntityResolver(new DTDIgnoringEntityResolver());
            }
            try {
                if (Utils.isEmpty(systemID)) {
                    doc = db.parse(inputStream);
                } else {
                    String systemIDwithEndingSlash = systemID.trim();
                    if (!systemIDwithEndingSlash.endsWith("/") && !systemIDwithEndingSlash.endsWith("\\")) {
                        systemIDwithEndingSlash = systemIDwithEndingSlash.concat("/");
                    }
                    doc = db.parse(inputStream, systemIDwithEndingSlash);
                }
            }
            catch (FileNotFoundException ef) {
                throw new HopXmlException(ef);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            return doc;
        }
        catch (Exception e) {
            throw new HopXmlException("Error reading information from input stream", e);
        }
    }

    public static Document loadXmlFile(File resource) throws HopXmlException {
        try {
            return XmlHandler.loadXmlFile(resource.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new HopXmlException(e);
        }
    }

    public static Document loadXmlFile(URL resource) throws HopXmlException {
        try {
            Document doc;
            DocumentBuilderFactory dbf = XmlParserFactoryProducer.createSecureDocBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            try (InputStream inputStream = resource.openStream();){
                doc = db.parse(inputStream);
            }
            return doc;
        }
        catch (Exception e) {
            throw new HopXmlException("Error reading information from resource", e);
        }
    }

    public static Document loadXmlString(String string) throws HopXmlException {
        return XmlHandler.loadXmlString(string, Boolean.FALSE, Boolean.TRUE);
    }

    public static Node loadXmlString(String xml, String tag) throws HopXmlException {
        Document doc = XmlHandler.loadXmlString(xml);
        return XmlHandler.getSubNode(doc, tag);
    }

    public static Document loadXmlString(String string, Boolean namespaceAware, Boolean deferNodeExpansion) throws HopXmlException {
        DocumentBuilder db = XmlHandler.createDocumentBuilder(namespaceAware, deferNodeExpansion);
        return XmlHandler.loadXmlString(db, string);
    }

    public static Document loadXmlString(DocumentBuilder db, String string) throws HopXmlException {
        try {
            Document doc;
            StringReader stringReader = new StringReader(string);
            InputSource inputSource = new InputSource(stringReader);
            try {
                doc = db.parse(inputSource);
            }
            catch (IOException ef) {
                throw new HopXmlException("Error parsing XML", ef);
            }
            finally {
                stringReader.close();
            }
            return doc;
        }
        catch (Exception e) {
            throw new HopXmlException("Error reading information from XML string : " + Const.CR + string, e);
        }
    }

    public static DocumentBuilder createDocumentBuilder(boolean namespaceAware, boolean deferNodeExpansion) throws HopXmlException {
        try {
            DocumentBuilderFactory dbf = XmlParserFactoryProducer.createSecureDocBuilderFactory();
            dbf.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", deferNodeExpansion);
            dbf.setNamespaceAware(namespaceAware);
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new HopXmlException(e);
        }
    }

    public static String getXmlString(Node document, boolean omitXmlDeclaration, boolean indent) throws HopException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", omitXmlDeclaration ? "yes" : "no");
            transformer.setOutputProperty("indent", indent ? "yes" : "no");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            return writer.getBuffer().toString();
        }
        catch (TransformerException e) {
            throw new HopException("Error converting Document to XML string", e);
        }
    }

    public static String getString() {
        return XmlHandler.class.getName();
    }

    public static String addTagValue(String tag, String val, boolean cr, String ... attributes) {
        StringBuilder value = new StringBuilder("<");
        value.append(Encode.forXml((String)tag));
        for (int i = 0; i < attributes.length; i += 2) {
            value.append(" ").append(Encode.forXml((String)attributes[i])).append("=\"").append(Encode.forXmlAttribute((String)attributes[i + 1])).append("\" ");
        }
        if (val != null && val.length() > 0) {
            value.append('>');
            value.append(Encode.forXml((String)val));
            value.append("</");
            value.append(Encode.forXml((String)tag));
            value.append('>');
        } else {
            value.append("/>");
        }
        if (cr) {
            value.append(Const.CR);
        }
        return value.toString();
    }

    public static void appendReplacedChars(StringBuilder value, String string) {
        value.append(Encode.forXml((String)string));
    }

    public static String addTagValue(IHopAttribute tag, String val) {
        return XmlHandler.addTagValue(tag.getXmlCode(), val);
    }

    public static String addTagValue(String tag, String val) {
        return XmlHandler.addTagValue(tag, val, true, new String[0]);
    }

    public static String addTagValue(IHopAttribute tag, boolean bool) {
        return XmlHandler.addTagValue(tag.getXmlCode(), bool);
    }

    public static String addTagValue(String tag, boolean bool) {
        return XmlHandler.addTagValue(tag, bool, true);
    }

    public static String addTagValue(String tag, boolean bool, boolean cr) {
        return XmlHandler.addTagValue(tag, bool ? "Y" : "N", cr, new String[0]);
    }

    public static String addTagValue(String tag, long l) {
        return XmlHandler.addTagValue(tag, l, true);
    }

    public static String addTagValue(String tag, long l, boolean cr) {
        return XmlHandler.addTagValue(tag, String.valueOf(l), cr, new String[0]);
    }

    public static String addTagValue(IHopAttribute tag, int i) {
        return XmlHandler.addTagValue(tag.getXmlCode(), i);
    }

    public static String addTagValue(String tag, int i) {
        return XmlHandler.addTagValue(tag, i, true);
    }

    public static String addTagValue(String tag, int i, boolean cr) {
        return XmlHandler.addTagValue(tag, String.valueOf(i), cr, new String[0]);
    }

    public static String addTagValue(String tag, double d) {
        return XmlHandler.addTagValue(tag, d, true);
    }

    public static String addTagValue(String tag, double d, boolean cr) {
        return XmlHandler.addTagValue(tag, String.valueOf(d), cr, new String[0]);
    }

    public static String addTagValue(String tag, Date date) {
        return XmlHandler.addTagValue(tag, date, true);
    }

    public static String addTagValue(String tag, Date date, boolean cr) {
        return XmlHandler.addTagValue(tag, XmlHandler.date2string(date), cr, new String[0]);
    }

    public static String addTagValue(String tag, BigDecimal val) {
        return XmlHandler.addTagValue(tag, val, true);
    }

    public static String addTagValue(String tag, BigDecimal val, boolean cr) {
        return XmlHandler.addTagValue(tag, val != null ? val.toString() : null, cr, new String[0]);
    }

    public static String addTagValue(String tag, byte[] val) throws IOException {
        return XmlHandler.addTagValue(tag, val, true);
    }

    public static String addTagValue(String tag, byte[] val, boolean cr) throws IOException {
        String string = val == null ? null : XmlHandler.encodeBinaryData(val);
        return XmlHandler.addTagValue(tag, string, cr, new String[0]);
    }

    public static String encodeBinaryData(byte[] val) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzos = new GZIPOutputStream(baos);
        BufferedOutputStream bos = new BufferedOutputStream(gzos);
        bos.write(val);
        bos.flush();
        bos.close();
        return new String(Base64.encodeBase64((byte[])baos.toByteArray()));
    }

    public static String[] getNodeAttributes(Node node) {
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null) {
            String[] attributes = new String[nnm.getLength()];
            for (int i = 0; i < nnm.getLength(); ++i) {
                Node attr = nnm.item(i);
                attributes[i] = attr.getNodeName();
            }
            return attributes;
        }
        return null;
    }

    public static String[] getNodeElements(Node node) {
        ArrayList<String> elements = new ArrayList<String>();
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String nodeName = nodeList.item(i).getNodeName();
            if (elements.indexOf(nodeName) >= 0) continue;
            elements.add(nodeName);
        }
        if (elements.isEmpty()) {
            return null;
        }
        return elements.toArray(new String[elements.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date stringToDate(String dateString) {
        if (Utils.isEmpty(dateString)) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = XmlHandler.simpleDateFormat;
            synchronized (simpleDateFormat) {
                return XmlHandler.simpleDateFormat.parse(dateString);
            }
        }
        catch (ParseException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timestamp stringToTimestamp(String dateString) {
        if (Utils.isEmpty(dateString)) {
            return null;
        }
        try {
            SimpleTimestampFormat simpleTimestampFormat = simpleTimeStampFormat;
            synchronized (simpleTimestampFormat) {
                return (Timestamp)simpleTimeStampFormat.parse(dateString);
            }
        }
        catch (ParseException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String date2string(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = XmlHandler.simpleDateFormat;
        synchronized (simpleDateFormat) {
            return XmlHandler.simpleDateFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String timestamp2string(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        SimpleTimestampFormat simpleTimestampFormat = simpleTimeStampFormat;
        synchronized (simpleTimestampFormat) {
            return simpleTimeStampFormat.format(timestamp);
        }
    }

    public static byte[] stringToBinary(String string) throws HopException {
        try {
            byte[] bytes = string == null ? new byte[]{} : Base64.decodeBase64((byte[])string.getBytes());
            if (bytes.length > 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                GZIPInputStream gzip = new GZIPInputStream(bais);
                BufferedInputStream bi = new BufferedInputStream(gzip);
                byte[] result = new byte[]{};
                byte[] extra = new byte[1000000];
                int nrExtra = bi.read(extra);
                while (nrExtra >= 0) {
                    int i;
                    int newSize = result.length + nrExtra;
                    byte[] tmp = new byte[newSize];
                    for (i = 0; i < result.length; ++i) {
                        tmp[i] = result[i];
                    }
                    for (i = 0; i < nrExtra; ++i) {
                        tmp[result.length + i] = extra[i];
                    }
                    result = tmp;
                    nrExtra = bi.read(extra);
                }
                bytes = result;
                gzip.close();
            }
            return bytes;
        }
        catch (Exception e) {
            throw new HopException("Error converting string to binary", e);
        }
    }

    public static String buildCDATA(String string) {
        return XmlHandler.buildCDATA(new StringBuilder(), string).toString();
    }

    public static StringBuilder buildCDATA(StringBuilder builder, String string) {
        return builder.append("<![CDATA[").append(Const.NVL(string, "")).append("]]>");
    }

    public static String openTag(String tag) {
        return XmlHandler.openTag(new StringBuilder(), tag).toString();
    }

    public static StringBuilder openTag(StringBuilder builder, String tag) {
        return builder.append('<').append(tag).append('>');
    }

    public static String closeTag(String tag) {
        return XmlHandler.closeTag(new StringBuilder(), tag).toString();
    }

    public static StringBuilder closeTag(StringBuilder builder, String tag) {
        return builder.append("</").append(tag).append('>');
    }

    public static String formatNode(Node node) throws HopXmlException {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to format Node as XML", e);
        }
        return sw.toString();
    }

    public static Node wrapLoadXmlString(String xml) throws HopXmlException {
        String tag = "wrap";
        String newXml = XmlHandler.openTag(tag) + xml + XmlHandler.closeTag(tag);
        return XmlHandler.loadXmlString(newXml, tag);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLicenseHeader(IVariables variables) throws HopException {
        String licenseFile = variables.getVariable("HOP_LICENSE_HEADER_FILE");
        if (StringUtils.isEmpty((String)licenseFile)) {
            return "";
        }
        String realLicenseFile = variables.resolve(licenseFile);
        try (InputStream inputStream = HopVfs.getInputStream(realLicenseFile);){
            List lines = IOUtils.readLines((InputStream)inputStream, (String)"UTF-8");
            if (lines.isEmpty()) {
                String string2 = "";
                return string2;
            }
            String xml = "<!--" + Const.CR;
            for (String line : lines) {
                xml = xml + line + Const.CR;
            }
            xml = xml + "-->" + Const.CR;
            String string = xml;
            return string;
        }
        catch (Exception e) {
            throw new HopException("Error reading license file : " + realLicenseFile, e);
        }
    }
}

