/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.flink.translation.functions.AbstractFlinkCombineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.flink.util.Collector;
import org.joda.time.Instant;

public class SortingFlinkCombineRunner<K, InputT, AccumT, OutputT, W extends BoundedWindow>
extends AbstractFlinkCombineRunner<K, InputT, AccumT, OutputT, W> {
    @Override
    public void combine(AbstractFlinkCombineRunner.FlinkCombiner<K, InputT, AccumT, OutputT> flinkCombiner, WindowingStrategy<Object, W> windowingStrategy, SideInputReader sideInputReader, PipelineOptions options, Iterable<WindowedValue<KV<K, InputT>>> elements, Collector<WindowedValue<KV<K, OutputT>>> out) throws Exception {
        TimestampCombiner timestampCombiner = windowingStrategy.getTimestampCombiner();
        ArrayList sortedInput = Lists.newArrayList();
        for (WindowedValue<KV<K, InputT>> inputValue : elements) {
            for (WindowedValue exploded : inputValue.explodeWindows()) {
                sortedInput.add(exploded);
            }
        }
        sortedInput.sort(Comparator.comparing(o -> ((BoundedWindow)Iterables.getOnlyElement((Iterable)o.getWindows())).maxTimestamp()));
        if (windowingStrategy.needsMerge()) {
            this.mergeWindow(sortedInput);
        }
        Iterator iterator = sortedInput.iterator();
        WindowedValue currentValue = (WindowedValue)iterator.next();
        Object key = ((KV)currentValue.getValue()).getKey();
        BoundedWindow currentWindow = (BoundedWindow)Iterables.getOnlyElement((Iterable)currentValue.getWindows());
        Object firstValue = ((KV)currentValue.getValue()).getValue();
        AccumT accumulator = flinkCombiner.firstInput(key, firstValue, options, sideInputReader, currentValue.getWindows());
        Instant windowTimestamp = timestampCombiner.assign(currentWindow, currentValue.getTimestamp());
        while (iterator.hasNext()) {
            Object value;
            WindowedValue nextValue = (WindowedValue)iterator.next();
            BoundedWindow nextWindow = (BoundedWindow)Iterables.getOnlyElement((Iterable)nextValue.getWindows());
            if (currentWindow.equals(nextWindow)) {
                value = ((KV)nextValue.getValue()).getValue();
                accumulator = flinkCombiner.addInput(key, accumulator, value, options, sideInputReader, currentValue.getWindows());
                windowTimestamp = timestampCombiner.combine(new Instant[]{windowTimestamp, timestampCombiner.assign(currentWindow, nextValue.getTimestamp())});
                continue;
            }
            out.collect((Object)WindowedValue.of((Object)KV.of((Object)key, flinkCombiner.extractOutput(key, accumulator, options, sideInputReader, currentValue.getWindows())), (Instant)windowTimestamp, (BoundedWindow)currentWindow, (PaneInfo)PaneInfo.NO_FIRING));
            currentWindow = nextWindow;
            currentValue = nextValue;
            value = ((KV)nextValue.getValue()).getValue();
            accumulator = flinkCombiner.firstInput(key, value, options, sideInputReader, currentValue.getWindows());
            windowTimestamp = timestampCombiner.assign(currentWindow, nextValue.getTimestamp());
        }
        out.collect((Object)WindowedValue.of((Object)KV.of((Object)key, flinkCombiner.extractOutput(key, accumulator, options, sideInputReader, currentValue.getWindows())), (Instant)windowTimestamp, (BoundedWindow)currentWindow, (PaneInfo)PaneInfo.NO_FIRING));
    }

    private void mergeWindow(List<WindowedValue<KV<K, InputT>>> elements) {
        int currentStart = 0;
        IntervalWindow currentWindow = (IntervalWindow)Iterables.getOnlyElement((Iterable)elements.get(0).getWindows());
        for (int i = 1; i < elements.size(); ++i) {
            WindowedValue<KV<K, InputT>> nextValue = elements.get(i);
            IntervalWindow nextWindow = (IntervalWindow)Iterables.getOnlyElement((Iterable)nextValue.getWindows());
            if (currentWindow.intersects(nextWindow)) {
                currentWindow = currentWindow.span(nextWindow);
                continue;
            }
            for (int j = i - 1; j >= currentStart; --j) {
                WindowedValue<KV<K, InputT>> value = elements.get(j);
                elements.set(j, WindowedValue.of((Object)((KV)value.getValue()), (Instant)value.getTimestamp(), (BoundedWindow)currentWindow, (PaneInfo)value.getPane()));
            }
            currentStart = i;
            currentWindow = nextWindow;
        }
        if (currentStart < elements.size() - 1) {
            for (int j = elements.size() - 1; j >= currentStart; --j) {
                WindowedValue<KV<K, InputT>> value = elements.get(j);
                elements.set(j, WindowedValue.of((Object)((KV)value.getValue()), (Instant)value.getTimestamp(), (BoundedWindow)currentWindow, (PaneInfo)value.getPane()));
            }
        }
    }
}

