/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.valuemapper;

import java.util.HashMap;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.valuemapper.ValueMapperData;
import org.apache.hop.pipeline.transforms.valuemapper.ValueMapperMeta;
import org.apache.hop.pipeline.transforms.valuemapper.Values;

public class ValueMapper
extends BaseTransform<ValueMapperMeta, ValueMapperData> {
    private static final Class<?> PKG = ValueMapperMeta.class;
    private boolean nonMatchActivated = false;

    public ValueMapper(TransformMeta transformMeta, ValueMapperMeta meta, ValueMapperData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((ValueMapperData)this.data).previousMeta = this.getInputRowMeta().clone();
            ((ValueMapperData)this.data).outputMeta = ((ValueMapperData)this.data).previousMeta.clone();
            ((ValueMapperMeta)this.meta).getFields(((ValueMapperData)this.data).outputMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((ValueMapperData)this.data).keynr = ((ValueMapperData)this.data).previousMeta.indexOfValue(((ValueMapperMeta)this.meta).getFieldToUse());
            if (((ValueMapperData)this.data).keynr < 0) {
                String message = BaseMessages.getString(PKG, (String)"ValueMapper.RuntimeError.FieldToUseNotFound.VALUEMAPPER0001", (String[])new String[]{((ValueMapperMeta)this.meta).getFieldToUse(), Const.CR, this.getInputRowMeta().getString(r)});
                this.logError(message);
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            for (Values v : ((ValueMapperMeta)this.meta).getValues()) {
                if (!Utils.isEmpty((CharSequence)v.getSource())) continue;
                if (((ValueMapperData)this.data).emptyFieldValue == null) {
                    ((ValueMapperData)this.data).emptyFieldValue = this.resolve(v.getTarget());
                    continue;
                }
                throw new HopException(BaseMessages.getString(PKG, (String)"ValueMapper.RuntimeError.OnlyOneEmptyMappingAllowed.VALUEMAPPER0004", (String[])new String[0]));
            }
            ((ValueMapperData)this.data).sourceValueMeta = this.getInputRowMeta().getValueMeta(((ValueMapperData)this.data).keynr);
            ((ValueMapperData)this.data).outputValueMeta = Utils.isEmpty((CharSequence)((ValueMapperMeta)this.meta).getTargetField()) ? ((ValueMapperData)this.data).outputMeta.getValueMeta(((ValueMapperData)this.data).keynr) : ((ValueMapperData)this.data).outputMeta.searchValueMeta(((ValueMapperMeta)this.meta).getTargetField());
        }
        Object sourceData = r[((ValueMapperData)this.data).keynr];
        String source = ((ValueMapperData)this.data).sourceValueMeta.getCompatibleString(sourceData);
        String target = null;
        if (((ValueMapperData)this.data).emptyFieldValue != null && (r[((ValueMapperData)this.data).keynr] == null || Utils.isEmpty((CharSequence)source))) {
            target = ((ValueMapperData)this.data).emptyFieldValue;
        } else if (!Utils.isEmpty((CharSequence)source)) {
            target = ((ValueMapperData)this.data).mapValues.get(source);
            if (this.nonMatchActivated && target == null) {
                target = ((ValueMapperData)this.data).nonMatchDefault;
            }
        }
        if (!Utils.isEmpty((CharSequence)((ValueMapperMeta)this.meta).getTargetField())) {
            r = RowDataUtil.resizeArray((Object[])r, (int)((ValueMapperData)this.data).outputMeta.size());
            r[((ValueMapperData)this.data).outputMeta.size() - 1] = !Utils.isEmpty((CharSequence)target) ? target : null;
        } else if (target != null) {
            r[((ValueMapperData)this.data).keynr] = target.length() > 0 ? (((ValueMapperData)this.data).sourceValueMeta.isString() ? target : ((ValueMapperData)this.data).outputValueMeta.convertData(((ValueMapperData)this.data).stringMeta, (Object)target)) : null;
        } else if (((ValueMapperData)this.data).sourceValueMeta.isStorageBinaryString()) {
            Object normal;
            r[((ValueMapperData)this.data).keynr] = normal = ((ValueMapperData)this.data).sourceValueMeta.convertToNormalStorageType(r[((ValueMapperData)this.data).keynr]);
        }
        this.putRow(((ValueMapperData)this.data).outputMeta, r);
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    public boolean init() {
        if (super.init()) {
            ((ValueMapperData)this.data).mapValues = new HashMap();
            if (!Utils.isEmpty((CharSequence)((ValueMapperMeta)this.meta).getNonMatchDefault())) {
                this.nonMatchActivated = true;
                ((ValueMapperData)this.data).nonMatchDefault = this.resolve(((ValueMapperMeta)this.meta).getNonMatchDefault());
            }
            for (Values v : ((ValueMapperMeta)this.meta).getValues()) {
                String src = v.getSource();
                String tgt = this.resolve(v.getTarget());
                if (!Utils.isEmpty((CharSequence)src) && !Utils.isEmpty((CharSequence)tgt)) {
                    ((ValueMapperData)this.data).mapValues.put(src, tgt);
                    continue;
                }
                if (!Utils.isEmpty((CharSequence)tgt)) continue;
                ((ValueMapperData)this.data).mapValues.put(src, "");
            }
            return true;
        }
        return false;
    }
}

