/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.replacestring;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.replacestring.ReplaceStringData;
import org.apache.hop.pipeline.transforms.replacestring.ReplaceStringMeta;

public class ReplaceString
extends BaseTransform<ReplaceStringMeta, ReplaceStringData> {
    private static final Class<?> PKG = ReplaceStringMeta.class;

    public ReplaceString(TransformMeta transformMeta, ReplaceStringMeta meta, ReplaceStringData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public static String replaceString(String originalString, Pattern pattern, String replaceByString) {
        if (originalString == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(originalString);
        if (replaceByString == null) {
            if (matcher.matches()) {
                return null;
            }
            return originalString;
        }
        return matcher.replaceAll(replaceByString);
    }

    @VisibleForTesting
    static Pattern buildPattern(boolean literalParsing, boolean caseSensitive, boolean wholeWord, String patternString, boolean isUnicode) {
        int flags = 0;
        if (literalParsing && !wholeWord) {
            flags |= 0x10;
        }
        if (!caseSensitive) {
            flags |= 2;
        }
        if (isUnicode) {
            flags |= 0x100;
        }
        if (wholeWord) {
            if (literalParsing) {
                patternString = "\\Q" + (String)patternString + "\\E";
            }
            patternString = "\\b" + (String)patternString + "\\b";
        }
        return Pattern.compile((String)patternString, flags);
    }

    private String getResolvedReplaceByString(int index, Object[] row) throws HopException {
        if (((ReplaceStringData)this.data).setEmptyString[index]) {
            return "";
        }
        if (((ReplaceStringData)this.data).replaceFieldIndex[index] == -1) {
            return ((ReplaceStringData)this.data).replaceByString[index];
        }
        return this.getInputRowMeta().getString(row, ((ReplaceStringData)this.data).replaceFieldIndex[index]);
    }

    synchronized Object[] getOneRow(IRowMeta rowMeta, Object[] row) throws HopException {
        Object[] rowData = RowDataUtil.resizeArray((Object[])row, (int)((ReplaceStringData)this.data).outputRowMeta.size());
        int index = 0;
        HashSet<Integer> numFieldsAlreadyBeenTransformed = new HashSet<Integer>();
        for (int i = 0; i < ((ReplaceStringData)this.data).numFields; ++i) {
            IRowMeta currentRowMeta = numFieldsAlreadyBeenTransformed.contains(((ReplaceStringData)this.data).inStreamNrs[i]) ? ((ReplaceStringData)this.data).outputRowMeta : this.getInputRowMeta();
            String value = ReplaceString.replaceString(currentRowMeta.getString(rowData, ((ReplaceStringData)this.data).inStreamNrs[i]), ((ReplaceStringData)this.data).patterns[i], this.getResolvedReplaceByString(i, row));
            if (Utils.isEmpty((CharSequence)((ReplaceStringData)this.data).outStreamNrs[i])) {
                rowData[((ReplaceStringData)this.data).inStreamNrs[i]] = value;
                numFieldsAlreadyBeenTransformed.add(((ReplaceStringData)this.data).inStreamNrs[i]);
                continue;
            }
            rowData[((ReplaceStringData)this.data).inputFieldsNr + index++] = value;
        }
        return rowData;
    }

    public boolean processRow() throws HopException {
        block12: {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((ReplaceStringData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((ReplaceStringData)this.data).inputFieldsNr = ((ReplaceStringData)this.data).outputRowMeta.size();
                ((ReplaceStringMeta)this.meta).getFields(((ReplaceStringData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((ReplaceStringData)this.data).numFields = ((ReplaceStringMeta)this.meta).getFieldInStream().length;
                ((ReplaceStringData)this.data).inStreamNrs = new int[((ReplaceStringData)this.data).numFields];
                ((ReplaceStringData)this.data).outStreamNrs = new String[((ReplaceStringData)this.data).numFields];
                ((ReplaceStringData)this.data).patterns = new Pattern[((ReplaceStringData)this.data).numFields];
                ((ReplaceStringData)this.data).replaceByString = new String[((ReplaceStringData)this.data).numFields];
                ((ReplaceStringData)this.data).setEmptyString = new boolean[((ReplaceStringData)this.data).numFields];
                ((ReplaceStringData)this.data).replaceFieldIndex = new int[((ReplaceStringData)this.data).numFields];
                for (int i = 0; i < ((ReplaceStringData)this.data).numFields; ++i) {
                    ((ReplaceStringData)this.data).inStreamNrs[i] = this.getInputRowMeta().indexOfValue(((ReplaceStringMeta)this.meta).getFieldInStream()[i]);
                    if (((ReplaceStringData)this.data).inStreamNrs[i] < 0) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"ReplaceString.Exception.FieldRequired", (String[])new String[]{((ReplaceStringMeta)this.meta).getFieldInStream()[i]}));
                    }
                    if (this.getInputRowMeta().getValueMeta(((ReplaceStringData)this.data).inStreamNrs[i]).getType() != 2) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"ReplaceString.Exception.FieldTypeNotString", (String[])new String[]{((ReplaceStringMeta)this.meta).getFieldInStream()[i]}));
                    }
                    ((ReplaceStringData)this.data).outStreamNrs[i] = this.resolve(((ReplaceStringMeta)this.meta).getFieldOutStream()[i]);
                    ((ReplaceStringData)this.data).patterns[i] = ReplaceString.buildPattern(((ReplaceStringMeta)this.meta).getUseRegEx()[i] != 1, ((ReplaceStringMeta)this.meta).getCaseSensitive()[i] == 1, ((ReplaceStringMeta)this.meta).getWholeWord()[i] == 1, this.resolve(((ReplaceStringMeta)this.meta).getReplaceString()[i]), ((ReplaceStringMeta)this.meta).isUnicode()[i] == 1);
                    String field = ((ReplaceStringMeta)this.meta).getFieldReplaceByString()[i];
                    if (!Utils.isEmpty((CharSequence)field)) {
                        ((ReplaceStringData)this.data).replaceFieldIndex[i] = this.getInputRowMeta().indexOfValue(field);
                        if (((ReplaceStringData)this.data).replaceFieldIndex[i] < 0) {
                            throw new HopTransformException(BaseMessages.getString(PKG, (String)"ReplaceString.Exception.FieldRequired", (String[])new String[]{field}));
                        }
                    } else {
                        ((ReplaceStringData)this.data).replaceFieldIndex[i] = -1;
                        ((ReplaceStringData)this.data).replaceByString[i] = this.resolve(((ReplaceStringMeta)this.meta).getReplaceByString()[i]);
                    }
                    ((ReplaceStringData)this.data).setEmptyString[i] = ((ReplaceStringMeta)this.meta).isSetEmptyString()[i];
                }
            }
            try {
                Object[] output = this.getOneRow(this.getInputRowMeta(), r);
                this.putRow(((ReplaceStringData)this.data).outputRowMeta, output);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ReplaceString.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"ReplaceString.Log.ErrorInTransform", (String[])new String[]{e.getMessage()}));
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block12;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "ReplaceString001");
            }
        }
        return true;
    }

    public boolean init() {
        return super.init();
    }

    public void dispose() {
        ((ReplaceStringData)this.data).outStreamNrs = null;
        ((ReplaceStringData)this.data).patterns = null;
        ((ReplaceStringData)this.data).replaceByString = null;
        ((ReplaceStringData)this.data).replaceString = null;
        ((ReplaceStringData)this.data).valueChange = null;
        super.dispose();
    }
}

