/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.pipeline;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannelFileWriter;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.parameters.NamedParameters;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.util.CurrentDirectoryResolver;
import org.apache.hop.core.util.FileUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.TransformWithMappingMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.w3c.dom.Node;

@Action(id="PIPELINE", image="ui/images/pipeline.svg", name="i18n::ActionPipeline.Name", description="i18n::ActionPipeline.Description", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.General", keywords={"i18n::ActionPipeline.keyword"}, documentationUrl="/workflow/actions/pipeline.html")
public class ActionPipeline
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionPipeline.class;
    private String filename;
    public String[] arguments;
    public boolean paramsFromPrevious;
    public boolean execPerRow;
    public String[] parameters;
    public String[] parameterFieldNames;
    public String[] parameterValues;
    public boolean clearResultRows;
    public boolean clearResultFiles;
    public boolean createParentFolder;
    public boolean setLogfile;
    public boolean setAppendLogfile;
    public String logfile;
    public String logext;
    public boolean addDate;
    public boolean addTime;
    public LogLevel logFileLevel;
    public boolean waitingToFinish = true;
    private boolean passingAllParameters = true;
    private String runConfiguration;
    private IPipelineEngine<PipelineMeta> pipeline;

    public ActionPipeline(String name) {
        super(name, "");
    }

    public ActionPipeline() {
        this("");
        this.clear();
    }

    private void allocateArgs(int nrArgs) {
        this.arguments = new String[nrArgs];
    }

    private void allocateParams(int nrParameters) {
        this.parameters = new String[nrParameters];
        this.parameterFieldNames = new String[nrParameters];
        this.parameterValues = new String[nrParameters];
    }

    public Object clone() {
        ActionPipeline je = (ActionPipeline)super.clone();
        if (this.arguments != null) {
            int nrArgs = this.arguments.length;
            je.allocateArgs(nrArgs);
            System.arraycopy(this.arguments, 0, je.arguments, 0, nrArgs);
        }
        if (this.parameters != null) {
            int nrParameters = this.parameters.length;
            je.allocateParams(nrParameters);
            System.arraycopy(this.parameters, 0, je.parameters, 0, nrParameters);
            System.arraycopy(this.parameterFieldNames, 0, je.parameterFieldNames, 0, nrParameters);
            System.arraycopy(this.parameterValues, 0, je.parameterValues, 0, nrParameters);
        }
        return je;
    }

    public void setFileName(String n) {
        this.filename = n;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getRealFilename() {
        return this.resolve(this.getFilename());
    }

    public String getLogFilename() {
        Object retval = "";
        if (this.setLogfile) {
            SimpleDateFormat sdf;
            retval = (String)retval + (this.logfile == null ? "" : this.logfile);
            Calendar cal = Calendar.getInstance();
            if (this.addDate) {
                sdf = new SimpleDateFormat("yyyyMMdd");
                retval = (String)retval + "_" + sdf.format(cal.getTime());
            }
            if (this.addTime) {
                sdf = new SimpleDateFormat("HHmmss");
                retval = (String)retval + "_" + sdf.format(cal.getTime());
            }
            if (this.logext != null && this.logext.length() > 0) {
                retval = (String)retval + "." + this.logext;
            }
        }
        return retval;
    }

    public String getXml() {
        int i;
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"params_from_previous", (boolean)this.paramsFromPrevious));
        retval.append("      ").append(XmlHandler.addTagValue((String)"exec_per_row", (boolean)this.execPerRow));
        retval.append("      ").append(XmlHandler.addTagValue((String)"clear_rows", (boolean)this.clearResultRows));
        retval.append("      ").append(XmlHandler.addTagValue((String)"clear_files", (boolean)this.clearResultFiles));
        retval.append("      ").append(XmlHandler.addTagValue((String)"set_logfile", (boolean)this.setLogfile));
        retval.append("      ").append(XmlHandler.addTagValue((String)"logfile", (String)this.logfile));
        retval.append("      ").append(XmlHandler.addTagValue((String)"logext", (String)this.logext));
        retval.append("      ").append(XmlHandler.addTagValue((String)"add_date", (boolean)this.addDate));
        retval.append("      ").append(XmlHandler.addTagValue((String)"add_time", (boolean)this.addTime));
        retval.append("      ").append(XmlHandler.addTagValue((String)"loglevel", this.logFileLevel != null ? this.logFileLevel.getCode() : null));
        retval.append("      ").append(XmlHandler.addTagValue((String)"set_append_logfile", (boolean)this.setAppendLogfile));
        retval.append("      ").append(XmlHandler.addTagValue((String)"wait_until_finished", (boolean)this.waitingToFinish));
        retval.append("      ").append(XmlHandler.addTagValue((String)"create_parent_folder", (boolean)this.createParentFolder));
        retval.append("      ").append(XmlHandler.addTagValue((String)"run_configuration", (String)this.runConfiguration));
        if (this.arguments != null) {
            for (i = 0; i < this.arguments.length; ++i) {
                retval.append("      ").append(XmlHandler.addTagValue((String)("argument" + i), (String)this.arguments[i]));
            }
        }
        if (this.parameters != null) {
            retval.append("      ").append(XmlHandler.openTag((String)"parameters")).append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"pass_all_parameters", (boolean)this.passingAllParameters));
            for (i = 0; i < this.parameters.length; ++i) {
                retval.append("        ").append(XmlHandler.openTag((String)"parameter")).append(Const.CR);
                retval.append("          ").append(XmlHandler.addTagValue((String)"name", (String)this.parameters[i]));
                retval.append("          ").append(XmlHandler.addTagValue((String)"stream_name", (String)this.parameterFieldNames[i]));
                retval.append("          ").append(XmlHandler.addTagValue((String)"value", (String)this.parameterValues[i]));
                retval.append("        ").append(XmlHandler.closeTag((String)"parameter")).append(Const.CR);
            }
            retval.append("      ").append(XmlHandler.closeTag((String)"parameters")).append(Const.CR);
        }
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.filename = XmlHandler.getTagValue((Node)entrynode, (String)"filename");
            this.paramsFromPrevious = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"params_from_previous"));
            this.execPerRow = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"exec_per_row"));
            this.clearResultRows = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"clear_rows"));
            this.clearResultFiles = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"clear_files"));
            this.setLogfile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"set_logfile"));
            this.addDate = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_date"));
            this.addTime = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_time"));
            this.logfile = XmlHandler.getTagValue((Node)entrynode, (String)"logfile");
            this.logext = XmlHandler.getTagValue((Node)entrynode, (String)"logext");
            this.logFileLevel = LogLevel.getLogLevelForCode((String)XmlHandler.getTagValue((Node)entrynode, (String)"loglevel"));
            this.createParentFolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"create_parent_folder"));
            this.runConfiguration = XmlHandler.getTagValue((Node)entrynode, (String)"run_configuration");
            this.setAppendLogfile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"set_append_logfile"));
            String wait = XmlHandler.getTagValue((Node)entrynode, (String)"wait_until_finished");
            this.waitingToFinish = Utils.isEmpty((CharSequence)wait) ? true : "Y".equalsIgnoreCase(wait);
            int argnr = 0;
            while (XmlHandler.getTagValue((Node)entrynode, (String)("argument" + argnr)) != null) {
                ++argnr;
            }
            this.allocateArgs(argnr);
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = XmlHandler.getTagValue((Node)entrynode, (String)("argument" + a));
            }
            Node parametersNode = XmlHandler.getSubNode((Node)entrynode, (String)"parameters");
            String passAll = XmlHandler.getTagValue((Node)parametersNode, (String)"pass_all_parameters");
            this.passingAllParameters = Utils.isEmpty((CharSequence)passAll) || "Y".equalsIgnoreCase(passAll);
            int nrParameters = XmlHandler.countNodes((Node)parametersNode, (String)"parameter");
            this.allocateParams(nrParameters);
            for (int i = 0; i < nrParameters; ++i) {
                Node knode = XmlHandler.getSubNodeByNr((Node)parametersNode, (String)"parameter", (int)i);
                this.parameters[i] = XmlHandler.getTagValue((Node)knode, (String)"name");
                this.parameterFieldNames[i] = XmlHandler.getTagValue((Node)knode, (String)"stream_name");
                this.parameterValues[i] = XmlHandler.getTagValue((Node)knode, (String)"value");
            }
        }
        catch (HopException e) {
            throw new HopXmlException("Unable to load action of type 'pipeline' from XML node", (Throwable)e);
        }
    }

    public void clear() {
        super.clear();
        this.filename = null;
        this.arguments = null;
        this.execPerRow = false;
        this.addDate = false;
        this.addTime = false;
        this.logfile = null;
        this.logext = null;
        this.setLogfile = false;
        this.clearResultRows = false;
        this.clearResultFiles = false;
        this.setAppendLogfile = false;
        this.waitingToFinish = true;
        this.createParentFolder = false;
        this.logFileLevel = LogLevel.BASIC;
    }

    public Result execute(Result result, int nr) throws HopException {
        result.setEntryNr((long)nr);
        LogChannelFileWriter logChannelFileWriter = null;
        LogLevel pipelineLogLevel = this.parentWorkflow.getLogLevel();
        String realLogFilename = "";
        if (this.setLogfile) {
            pipelineLogLevel = this.logFileLevel;
            realLogFilename = this.resolve(this.getLogFilename());
            if (Utils.isEmpty((CharSequence)realLogFilename)) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionPipeline.Exception.LogFilenameMissing", (String[])new String[0]));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            if (!FileUtil.createParentFolder(PKG, (String)realLogFilename, (boolean)this.createParentFolder, (ILogChannel)this.getLogChannel())) {
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            try {
                logChannelFileWriter = new LogChannelFileWriter(this.getLogChannelId(), HopVfs.getFileObject((String)realLogFilename), this.setAppendLogfile);
                logChannelFileWriter.startLogging();
            }
            catch (HopException e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionPipeline.Error.UnableOpenAppender", (String[])new String[]{realLogFilename, e.toString()}));
                this.logError(Const.getStackTracker((Throwable)e));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
        }
        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionPipeline.Log.OpeningPipeline", (String[])new String[]{this.resolve(this.getFilename())}));
        PipelineMeta pipelineMeta = null;
        try {
            pipelineMeta = this.getPipelineMeta(this.getMetadataProvider(), (IVariables)this);
        }
        catch (HopException e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionPipeline.Exception.UnableToRunWorkflow", (String[])new String[]{this.parentWorkflowMeta.getName(), this.getName(), StringUtils.trim((String)e.getMessage())}), e);
            result.setNrErrors(1L);
            result.setResult(false);
            return result;
        }
        RowMetaAndData resultRow = null;
        boolean first = true;
        ArrayList rows = new ArrayList(result.getRows());
        for (int iteration = 0; first && !this.execPerRow || this.execPerRow && rows != null && iteration < rows.size() && result.getNrErrors() == 0L && !this.parentWorkflow.isStopped(); ++iteration) {
            if (this.execPerRow) {
                result.getRows().clear();
            }
            resultRow = rows != null && this.execPerRow ? (RowMetaAndData)rows.get(iteration) : null;
            NamedParameters namedParam = new NamedParameters();
            if (this.parameters != null) {
                for (int idx = 0; idx < this.parameters.length; ++idx) {
                    String value;
                    if (Utils.isEmpty((CharSequence)this.parameters[idx])) continue;
                    namedParam.addParameterDefinition(this.parameters[idx], "", "Action runtime");
                    if (Utils.isEmpty((CharSequence)Const.trim((String)this.parameterFieldNames[idx]))) {
                        value = Const.NVL((String)this.resolve(this.parameterValues[idx]), (String)"");
                        namedParam.setParameterValue(this.parameters[idx], value);
                        continue;
                    }
                    value = "";
                    if (resultRow != null) {
                        value = resultRow.getString(this.parameterFieldNames[idx], "");
                    }
                    namedParam.setParameterValue(this.parameters[idx], value);
                }
            }
            first = false;
            Result previousResult = result;
            try {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionPipeline.StartingPipeline", (String[])new String[]{this.getFilename(), this.getName(), this.getDescription()}));
                }
                if (this.clearResultRows) {
                    previousResult.setRows(new ArrayList());
                }
                if (this.clearResultFiles) {
                    previousResult.getResultFiles().clear();
                }
                if (this.execPerRow) {
                    ArrayList<RowMetaAndData> newList = new ArrayList<RowMetaAndData>();
                    newList.add(resultRow);
                    previousResult.getRows().addAll(newList);
                    if (this.paramsFromPrevious && this.parameters != null) {
                        for (int idx = 0; idx < this.parameters.length; ++idx) {
                            if (Utils.isEmpty((CharSequence)this.parameters[idx])) continue;
                            if (Utils.isEmpty((CharSequence)Const.trim((String)this.parameterFieldNames[idx]))) {
                                namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)this.resolve(this.parameterValues[idx]), (String)""));
                                continue;
                            }
                            String fieldValue = "";
                            if (resultRow != null) {
                                fieldValue = resultRow.getString(this.parameterFieldNames[idx], "");
                            }
                            namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)fieldValue, (String)""));
                        }
                    }
                } else if (this.paramsFromPrevious && this.parameters != null) {
                    for (int idx = 0; idx < this.parameters.length; ++idx) {
                        if (Utils.isEmpty((CharSequence)this.parameters[idx])) continue;
                        if (Utils.isEmpty((CharSequence)Const.trim((String)this.parameterFieldNames[idx]))) {
                            namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)this.resolve(this.parameterValues[idx]), (String)""));
                            continue;
                        }
                        String fieldValue = "";
                        if (resultRow != null) {
                            fieldValue = resultRow.getString(this.parameterFieldNames[idx], "");
                        }
                        namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)fieldValue, (String)""));
                    }
                }
                String[] parameterNames = pipelineMeta.listParameters();
                this.prepareFieldNamesParameters(this.parameters, this.parameterFieldNames, this.parameterValues, (INamedParameters)namedParam, this);
                if (StringUtils.isEmpty((String)this.runConfiguration)) {
                    throw new HopException("This action needs a run configuration to use to execute the specified pipeline");
                }
                this.runConfiguration = this.resolve(this.runConfiguration);
                this.log.logBasic(BaseMessages.getString(PKG, (String)"ActionPipeline.RunConfig.Message", (String[])new String[]{this.runConfiguration}));
                this.pipeline = PipelineEngineFactory.createPipelineEngine((IVariables)this, (String)this.runConfiguration, (IHopMetadataProvider)this.getMetadataProvider(), (PipelineMeta)pipelineMeta);
                this.pipeline.setParent((ILoggingObject)this);
                this.pipeline.setParentWorkflow(this.parentWorkflow);
                this.pipeline.setParentVariables((IVariables)this.parentWorkflow);
                this.pipeline.setLogLevel(pipelineLogLevel);
                this.pipeline.setPreviousResult(previousResult);
                this.pipeline.setMetadataProvider(this.getMetadataProvider());
                this.pipeline.initializeFrom(null);
                this.pipeline.copyParametersFromDefinitions((INamedParameterDefinitions)pipelineMeta);
                TransformWithMappingMeta.activateParams(this.pipeline, this.pipeline, (IVariables)this, (String[])parameterNames, (String[])this.parameters, (String[])this.parameterValues, (boolean)this.isPassingAllParameters());
                IWorkflowEngine rootWorkflow = this.parentWorkflow;
                while (rootWorkflow.getParentWorkflow() != null) {
                    rootWorkflow = rootWorkflow.getParentWorkflow();
                }
                try {
                    this.pipeline.execute();
                    if (this.isWaitingToFinish()) {
                        this.pipeline.waitUntilFinished();
                        if (this.parentWorkflow.isStopped() || this.pipeline.getErrors() != 0) {
                            this.pipeline.stopAll();
                            result.setNrErrors(1L);
                        }
                        this.updateResult(result);
                    }
                    if (!this.setLogfile) continue;
                    ResultFile resultFile = new ResultFile(1, HopVfs.getFileObject((String)realLogFilename), this.parentWorkflow.getWorkflowName(), this.toString());
                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionPipeline.Error.UnablePrepareExec", (String[])new String[0]), e);
                    result.setNrErrors(1L);
                }
                continue;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionPipeline.ErrorUnableOpenPipeline", (String[])new String[]{e.getMessage()}));
                this.logError(Const.getStackTracker((Throwable)e));
                result.setNrErrors(1L);
            }
        }
        if (this.setLogfile && logChannelFileWriter != null) {
            logChannelFileWriter.stopLogging();
            ResultFile resultFile = new ResultFile(1, logChannelFileWriter.getLogFile(), this.parentWorkflow.getWorkflowName(), this.getName());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (logChannelFileWriter.getException() != null) {
                this.logError("Unable to open log file [" + this.getLogFilename() + "] : ");
                this.logError(Const.getStackTracker((Throwable)logChannelFileWriter.getException()));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
        }
        if (result.getNrErrors() == 0L) {
            result.setResult(true);
        } else {
            result.setResult(false);
        }
        return result;
    }

    protected void updateResult(Result result) {
        Result newResult = this.pipeline.getResult();
        result.clear();
        result.add(newResult);
        if (!Utils.isEmpty((List)newResult.getRows())) {
            result.setRows(newResult.getRows());
        }
    }

    public PipelineMeta getPipelineMeta(IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        try {
            PipelineMeta pipelineMeta = null;
            CurrentDirectoryResolver r = new CurrentDirectoryResolver();
            IVariables tmpSpace = r.resolveCurrentDirectory(variables, this.parentWorkflow, this.getFilename());
            String realFilename = tmpSpace.resolve(this.getFilename());
            pipelineMeta = new PipelineMeta(realFilename, metadataProvider, (IVariables)this);
            if (pipelineMeta != null) {
                pipelineMeta.setMetadataProvider(metadataProvider);
            }
            return pipelineMeta;
        }
        catch (HopException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ActionPipeline.Exception.MetaDataLoad", (String[])new String[0]), (Throwable)e);
        }
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public List<SqlStatement> getSqlStatements(IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        this.copyFrom(variables);
        PipelineMeta pipelineMeta = this.getPipelineMeta(metadataProvider, (IVariables)this);
        return pipelineMeta.getSqlStatements(variables);
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (this.setLogfile) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "logfile", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        }
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        } else {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "pipeline-name", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "directory", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        }
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            String realFileName = variables.resolve(this.filename);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.ACTIONFILE));
            references.add(reference);
        }
        return references;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming namingInterface, IHopMetadataProvider metadataProvider) throws HopException {
        this.copyFrom(variables);
        PipelineMeta pipelineMeta = this.getPipelineMeta(metadataProvider, variables);
        String proposedNewFilename = pipelineMeta.exportResources(variables, definitions, namingInterface, metadataProvider);
        String newFilename = "${Internal.Entry.Current.Folder}/" + proposedNewFilename;
        pipelineMeta.setFilename(newFilename);
        this.filename = newFilename;
        return proposedNewFilename;
    }

    protected String getLogfile() {
        return this.logfile;
    }

    public boolean isWaitingToFinish() {
        return this.waitingToFinish;
    }

    public void setWaitingToFinish(boolean waitingToFinish) {
        this.waitingToFinish = waitingToFinish;
    }

    public boolean isPassingAllParameters() {
        return this.passingAllParameters;
    }

    public void setPassingAllParameters(boolean passingAllParameters) {
        this.passingAllParameters = passingAllParameters;
    }

    public String getRunConfiguration() {
        return this.runConfiguration;
    }

    public void setRunConfiguration(String runConfiguration) {
        this.runConfiguration = runConfiguration;
    }

    public IPipelineEngine<PipelineMeta> getPipeline() {
        return this.pipeline;
    }

    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"ActionPipeline.ReferencedObject.Description", (String[])new String[0])};
    }

    private boolean isPipelineDefined() {
        return StringUtils.isNotEmpty((String)this.filename);
    }

    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isPipelineDefined()};
    }

    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return this.getPipelineMeta(metadataProvider, variables);
    }

    public void setParentWorkflowMeta(WorkflowMeta parentWorkflowMeta) {
        super.setParentWorkflowMeta(parentWorkflowMeta);
    }

    public void prepareFieldNamesParameters(String[] parameters, String[] parameterFieldNames, String[] parameterValues, INamedParameters namedParam, ActionPipeline actionPipeline) throws UnknownParamException {
        for (int idx = 0; idx < parameters.length; ++idx) {
            String thisValue = namedParam.getParameterValue(parameters[idx]);
            if (idx >= parameterFieldNames.length || Utils.isEmpty((CharSequence)Const.trim((String)parameterFieldNames[idx]))) continue;
            if (idx < parameterValues.length) {
                if (!Utils.isEmpty((CharSequence)Const.trim((String)parameterValues[idx]))) continue;
                actionPipeline.setVariable(parameters[idx], Const.NVL((String)thisValue, (String)""));
                continue;
            }
            actionPipeline.setVariable(parameters[idx], Const.NVL((String)thisValue, (String)""));
        }
    }
}

