/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.ValueBinder;
import com.google.common.base.Preconditions;
import com.google.spanner.v1.ExecuteSqlRequest;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class Statement
implements Serializable {
    private static final long serialVersionUID = -1967958247625065259L;
    private final Map<String, Value> parameters;
    private final String sql;
    private final ExecuteSqlRequest.QueryOptions queryOptions;

    private Statement(String sql, Map<String, Value> parameters, ExecuteSqlRequest.QueryOptions queryOptions) {
        this.sql = sql;
        this.parameters = parameters;
        this.queryOptions = queryOptions;
    }

    public static Statement of(String sql) {
        return Statement.newBuilder(sql).build();
    }

    public static Builder newBuilder(String sql) {
        return new Builder(sql);
    }

    public boolean hasBinding(String parameter) {
        return this.parameters.containsKey(parameter);
    }

    public ResultSet executeQuery(ReadContext context, Options.QueryOption ... options) {
        return context.executeQuery(this, options);
    }

    public ResultSet analyzeQuery(ReadContext context, ReadContext.QueryAnalyzeMode queryMode) {
        return context.analyzeQuery(this, queryMode);
    }

    public String getSql() {
        return this.sql;
    }

    public ExecuteSqlRequest.QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    public Map<String, Value> getParameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Statement that = (Statement)o;
        return Objects.equals(this.sql, that.sql) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.queryOptions, that.queryOptions);
    }

    public int hashCode() {
        return Objects.hash(this.sql, this.parameters, this.queryOptions);
    }

    StringBuilder toString(StringBuilder b) {
        b.append(this.sql);
        if (!this.parameters.isEmpty()) {
            b.append(" {");
            int n = 0;
            for (Map.Entry<String, Value> parameter : this.parameters.entrySet()) {
                if (n++ > 0) {
                    b.append(", ");
                }
                b.append(parameter.getKey()).append(": ");
                if (parameter.getValue() == null) {
                    b.append("NULL");
                    continue;
                }
                parameter.getValue().toString(b);
            }
            b.append("}");
        }
        if (this.queryOptions != null) {
            b.append(",queryOptions=").append(this.queryOptions.toString());
        }
        return b;
    }

    public static final class Builder {
        final Map<String, Value> parameters;
        private final StringBuilder sqlBuffer;
        private String currentBinding;
        private final ValueBinder<Builder> binder = new Binder();
        private ExecuteSqlRequest.QueryOptions queryOptions;

        private Builder(String sql) {
            this.parameters = new HashMap<String, Value>();
            this.sqlBuffer = new StringBuilder(sql);
        }

        private Builder(Statement statement) {
            this.sqlBuffer = new StringBuilder(statement.sql);
            this.parameters = new HashMap<String, Value>(statement.parameters);
            this.queryOptions = statement.queryOptions == null ? null : statement.queryOptions.toBuilder().build();
        }

        public Builder append(String sqlFragment) {
            this.sqlBuffer.append((String)Preconditions.checkNotNull((Object)sqlFragment));
            return this;
        }

        public Builder withQueryOptions(ExecuteSqlRequest.QueryOptions queryOptions) {
            this.queryOptions = queryOptions;
            return this;
        }

        public ValueBinder<Builder> bind(String parameter) {
            Preconditions.checkState((this.currentBinding == null ? 1 : 0) != 0, (String)"Cannot bind new parameter. Previous binding of parameter '%s' is incomplete.", (Object)this.currentBinding);
            this.currentBinding = parameter;
            return this.binder;
        }

        public Statement build() {
            Preconditions.checkState((this.currentBinding == null ? 1 : 0) != 0, (String)"Binding for parameter '%s' is incomplete.", (Object)this.currentBinding);
            return new Statement(this.sqlBuffer.toString(), Collections.unmodifiableMap(new HashMap<String, Value>(this.parameters)), this.queryOptions);
        }

        private class Binder
        extends ValueBinder<Builder> {
            private Binder() {
            }

            @Override
            Builder handle(Value value) {
                Preconditions.checkArgument((value == null || !value.isCommitTimestamp() ? 1 : 0) != 0, (Object)"Mutation.COMMIT_TIMESTAMP cannot be bound as a query parameter");
                Preconditions.checkState((Builder.this.currentBinding != null ? 1 : 0) != 0, (Object)"No binding in progress");
                Builder.this.parameters.put(Builder.this.currentBinding, value);
                Builder.this.currentBinding = null;
                return Builder.this;
            }
        }
    }
}

