/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.JPingDS;
import com.ibm.as400.access.JPingEchoDS;
import com.ibm.as400.access.JPingEchoReplyDS;
import com.ibm.as400.access.PortMapper;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.SSLOptions;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.SocketContainer;
import com.ibm.as400.access.SocketProperties;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;

public class AS400JPing {
    public static final int ALL_SERVICES = 99;
    private String systemName_;
    private int service_ = 99;
    private int length_ = 10;
    private boolean echo_ = false;
    private SSLOptions useSSL_ = null;
    private long time_ = 20000L;
    private PrintWriter writer_;
    private SocketContainer socketContainer_;
    private Socket ddmSocket_;
    private Thread jpingDaemon_;
    private JPingThread jpingThread_;
    private SocketProperties socketProperties_ = new SocketProperties();
    private static ResourceBundleLoader loader_;

    public AS400JPing(String string) {
        this(string, 99, false);
    }

    public AS400JPing(String string, int n) {
        this(string, n, false);
    }

    public AS400JPing(String string, int n, boolean bl) {
        if (string == null) {
            throw new NullPointerException("systemName");
        }
        if (n < 0 || n > 7 && n != 99) {
            throw new ExtendedIllegalArgumentException("service (" + n + ")", 2);
        }
        this.systemName_ = string;
        this.service_ = n;
        this.useSSL_ = bl ? new SSLOptions() : null;
    }

    public boolean ping() {
        if (this.service_ == 99) {
            boolean bl = true;
            for (int i = 0; i <= 7; ++i) {
                boolean bl2 = bl = bl && this.ping(i);
                if (bl) continue;
                return bl;
            }
            return bl;
        }
        return this.ping(this.service_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized boolean ping(int n) {
        Throwable throwable222;
        boolean bl;
        OutputStream outputStream;
        InputStream inputStream;
        block51: {
            if (n < 0 || n > 7) {
                throw new ExtendedIllegalArgumentException("service (" + n + ")", 2);
            }
            int n2 = (int)this.time_;
            if (n2 > 0) {
                this.socketProperties_.setSoTimeout(n2);
            }
            inputStream = null;
            outputStream = null;
            if (Trace.traceOn_) {
                Trace.log(3, "Ping System:   " + this.systemName_);
                Trace.log(3, "Ping Service:  " + AS400.getServerName(n));
                Trace.log(3, "Packet Length: " + this.length_);
                Trace.log(3, "Echo Packet:   " + (this.echo_ ? "on" : "off"));
                Trace.log(3, "Ping SSL Port: " + (this.useSSL_ != null ? "yes" : "no"));
            }
            this.service_ = n;
            if (n == 5) {
                this.pingDDM();
            } else {
                this.jpingThread_ = new JPingThread();
                this.jpingDaemon_ = new Thread((Runnable)this.jpingThread_, "AS400JPingDaemon");
                this.jpingDaemon_.setDaemon(true);
                this.jpingDaemon_.start();
                Object object = this;
                synchronized (object) {
                    block50: {
                        try {
                            if (Trace.traceOn_) {
                                Trace.log(3, "Ping Timeout:  " + this.time_ + "(ms)");
                            }
                            this.wait(this.time_);
                        }
                        catch (InterruptedException interruptedException) {
                            if (!Trace.traceOn_) break block50;
                            Trace.log(2, "Unexpected exception.", (Throwable)interruptedException);
                        }
                    }
                }
                if (this.socketContainer_ == null) {
                    this.jpingDaemon_.interrupt();
                    throw new Exception("Ping timeout occurred.");
                }
                inputStream = this.socketContainer_.getInputStream();
                outputStream = this.socketContainer_.getOutputStream();
                object = new byte[this.length_];
                for (int i = 0; i < this.length_; ++i) {
                    object[i] = -35;
                }
                if (this.echo_) {
                    JPingEchoDS jPingEchoDS = new JPingEchoDS(n, (byte[])object);
                    jPingEchoDS.write(outputStream);
                    outputStream.flush();
                    JPingEchoReplyDS jPingEchoReplyDS = new JPingEchoReplyDS(((Object)object).length);
                    if (jPingEchoReplyDS.read(inputStream) != this.length_) {
                        Trace.log(2, "Bytes echoed did not match then number of bytes sent.");
                        throw new ConnectionDroppedException(2);
                    }
                } else {
                    JPingDS jPingDS = new JPingDS(n, (byte[])object);
                    jPingDS.write(outputStream);
                    outputStream.flush();
                }
            }
            if (this.writer_ != null) {
                this.writer_.println(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("PROP_NAME_AJP_SUCCESS"), new String[]{AS400.getServerName(n), this.useSSL_ != null ? "-s" : ""}));
            }
            bl = true;
            Object var9_17 = null;
            if (outputStream == null) break block51;
            try {
                outputStream.close();
            }
            catch (Throwable throwable222) {
                Trace.log(2, throwable222);
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Throwable throwable222) {
                Trace.log(2, throwable222);
            }
        }
        if (this.socketContainer_ != null) {
            try {
                this.socketContainer_.close();
            }
            catch (Throwable throwable222) {
                Trace.log(2, throwable222);
            }
        }
        return bl;
        catch (ServerStartupException serverStartupException) {
            Throwable throwable3222;
            boolean bl2;
            block54: {
                if (this.writer_ != null) {
                    this.writer_.println(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("PROP_NAME_AJP_FAILED"), new String[]{AS400.getServerName(n), this.useSSL_ != null ? "-s" : ""}));
                }
                if (Trace.traceOn_) {
                    Trace.log(2, serverStartupException);
                }
                bl2 = false;
                Object var9_18 = null;
                if (outputStream == null) break block54;
                try {
                    outputStream.close();
                }
                catch (Throwable throwable3222) {
                    Trace.log(2, throwable3222);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable3222) {
                    Trace.log(2, throwable3222);
                }
            }
            if (this.socketContainer_ != null) {
                try {
                    this.socketContainer_.close();
                }
                catch (Throwable throwable3222) {
                    Trace.log(2, throwable3222);
                }
            }
            return bl2;
        }
        catch (Exception exception) {
            Throwable throwable4222;
            boolean bl3;
            block57: {
                if (this.writer_ != null) {
                    this.writer_.println(ResourceBundleLoader.substitute(ResourceBundleLoader.getText("PROP_NAME_AJP_FAILED"), new String[]{AS400.getServerName(n), this.useSSL_ != null ? "-s" : ""}));
                }
                if (Trace.traceOn_) {
                    Trace.log(2, exception);
                }
                bl3 = false;
                Object var9_19 = null;
                if (outputStream == null) break block57;
                {
                    catch (Throwable throwable5) {
                        block60: {
                            Throwable throwable6222;
                            Object var9_20 = null;
                            if (outputStream != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable6222) {
                                    Trace.log(2, throwable6222);
                                }
                            }
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable6222) {
                                    Trace.log(2, throwable6222);
                                }
                            }
                            if (this.socketContainer_ == null) break block60;
                            try {
                                this.socketContainer_.close();
                            }
                            catch (Throwable throwable6222) {
                                Trace.log(2, throwable6222);
                            }
                        }
                        throw throwable5;
                    }
                }
                try {
                    outputStream.close();
                }
                catch (Throwable throwable4222) {
                    Trace.log(2, throwable4222);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable4222) {
                    Trace.log(2, throwable4222);
                }
            }
            if (this.socketContainer_ != null) {
                try {
                    this.socketContainer_.close();
                }
                catch (Throwable throwable4222) {
                    Trace.log(2, throwable4222);
                }
            }
            return bl3;
        }
    }

    public boolean pingAllServices() {
        boolean bl = true;
        for (int i = 0; i <= 7; ++i) {
            bl = this.ping(i) && bl;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void pingDDM() throws Exception {
        block30: {
            Throwable throwable2222;
            InputStream inputStream;
            OutputStream outputStream;
            block29: {
                byte[] byArray = new byte[]{0, 117, -48, 1, 0, 0, 0, 111, 16, 65, 0, 11, 17, 71, 0, 7, 0, 9, -40, -63, -30, 0, 96, 20, 4, 20, 3, 0, 3, 20, 35, 0, 3, 20, 5, 0, 3, 20, 6, 0, 3, 20, 7, 0, 3, 20, 116, 0, 5, 20, 88, 0, 1, 20, 87, 0, 3, 20, 12, 0, 3, 20, 25, 0, 3, 20, 30, 0, 3, 20, 34, 0, 3, 36, 15, 0, 3, 20, 50, 0, 3, 20, 51, 0, 3, 20, 64, 0, 1, 20, 59, 0, 3, 36, 7, 0, 3, 20, 99, 0, 3, 20, 101, 0, 3, 20, 60, 0, 3, 20, 127, 0, 4, 20, -96, 0, 4};
                byte[] byArray2 = new byte[]{0, 113, -48, 3, 0, 0, 0, 107, 20, 67, 0, 7, 17, 71, -40, -63, -30, 0, 96, 20, 4, 20, 3, 0, 3, 20, 35, 0, 3, 20, 5, 0, 3, 20, 6, 0, 3, 20, 7, 0, 3, 20, 116, 0, 5, 20, 88, 0, 1, 20, 87, 0, 3, 20, 12, 0, 3, 20, 25, 0, 3, 20, 30, 0, 3, 20, 34, 0, 3, 36, 15, 0, 3, 20, -96, 0, 4, 20, 50, 0, 3, 20, 51, 0, 3, 20, 64, 0, 1, 20, 59, 0, 3, 36, 7, 0, 3, 20, 99, 0, 3, 20, 101, 0, 3, 20, 60, 0, 3, 20, 127, 0, 4};
                outputStream = null;
                inputStream = null;
                this.jpingThread_ = new JPingThread();
                this.jpingDaemon_ = new Thread((Runnable)this.jpingThread_, "AS400JPingDaemon");
                this.jpingDaemon_.setDaemon(true);
                this.jpingDaemon_.start();
                Object object = this;
                synchronized (object) {
                    block28: {
                        try {
                            if (Trace.traceOn_) {
                                Trace.log(3, "Ping Timeout:  " + this.time_ + "(ms)");
                            }
                            this.wait(this.time_);
                        }
                        catch (InterruptedException interruptedException) {
                            if (!Trace.traceOn_) break block28;
                            Trace.log(2, "Unexpected exception.", (Throwable)interruptedException);
                        }
                    }
                }
                if (this.socketContainer_ == null) {
                    this.jpingDaemon_.interrupt();
                    throw new Exception("Ping Timeout occurred.");
                }
                outputStream = this.socketContainer_.getOutputStream();
                if (Trace.traceOn_) {
                    Trace.log(1, "Ping DDM: Writing data");
                }
                outputStream.write(byArray);
                if (Trace.traceOn_) {
                    Trace.log(1, "Ping DDM: flushing write");
                }
                outputStream.flush();
                inputStream = this.socketContainer_.getInputStream();
                object = new byte[113];
                if (Trace.traceOn_) {
                    Trace.log(1, "Ping DDM: Reading data");
                }
                int n = inputStream.read((byte[])object);
                if (Trace.traceOn_) {
                    Trace.log(1, "Ping DDM: " + n + " bytes read");
                }
                if (n < ((Object)object).length) {
                    Trace.log(2, "Unexpected DDM server response.", (byte[])object);
                    throw new Exception("Unexpected DDM server response.");
                }
                for (int i = 0; i < 113; ++i) {
                    if (object[i] == byArray2[i]) continue;
                    Trace.log(2, "Unexpected DDM server response.", (byte[])object);
                    throw new Exception("Unexpected DDM server response.");
                }
                Object var9_12 = null;
                if (inputStream == null) break block29;
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2222) {
                    Trace.log(2, throwable2222);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2222) {
                    Trace.log(2, throwable2222);
                }
            }
            break block30;
            {
                catch (Exception exception) {
                    if (exception.getMessage().equals("Ping Timeout occurred.")) {
                        throw exception;
                    }
                    if (exception.getMessage().equals("Read timed out")) {
                        throw exception;
                    }
                    Exception exception2 = new Exception("Unexpected exception.", exception);
                    throw exception2;
                }
            }
            catch (Throwable throwable3) {
                Throwable throwable42222;
                Object var9_13 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable42222) {
                        Trace.log(2, throwable42222);
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable42222) {
                        Trace.log(2, throwable42222);
                    }
                }
                throw throwable3;
            }
        }
    }

    public void setPrintWriter(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("stream");
        }
        this.writer_ = new PrintWriter(outputStream, true);
    }

    public void setTimeout(long l) {
        this.time_ = l;
    }

    private class JPingThread
    implements Runnable {
        private JPingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            AS400JPing aS400JPing;
            try {
                try {
                    if (AS400JPing.this.service_ == 5) {
                        AS400JPing.this.socketContainer_ = PortMapper.getServerSocket(AS400JPing.this.systemName_, AS400JPing.this.service_, AS400JPing.this.useSSL_, AS400JPing.this.socketProperties_, true);
                    }
                    AS400JPing.this.socketContainer_ = PortMapper.getServerSocket(AS400JPing.this.systemName_, AS400JPing.this.service_, AS400JPing.this.useSSL_, AS400JPing.this.socketProperties_, false);
                }
                catch (Exception exception) {
                    if (Trace.traceOn_) {
                        Trace.log(2, "Unexpected exception.", (Throwable)exception);
                    }
                    Object var3_2 = null;
                    AS400JPing aS400JPing3 = AS400JPing.this;
                    synchronized (aS400JPing3) {
                        AS400JPing.this.notifyAll();
                        return;
                    }
                }
                Object var3_1 = null;
                aS400JPing = AS400JPing.this;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                AS400JPing aS400JPing2 = AS400JPing.this;
                synchronized (aS400JPing2) {
                    AS400JPing.this.notifyAll();
                    throw throwable;
                }
            }
            synchronized (aS400JPing) {
                AS400JPing.this.notifyAll();
                return;
            }
        }
    }
}

