/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.stringcut;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.stringcut.StringCutData;
import org.apache.hop.pipeline.transforms.stringcut.StringCutField;
import org.apache.hop.pipeline.transforms.stringcut.StringCutMeta;

public class StringCut
extends BaseTransform<StringCutMeta, StringCutData> {
    private static final Class<?> PKG = StringCutMeta.class;

    public StringCut(TransformMeta transformMeta, StringCutMeta meta, StringCutData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private String cutString(String string, int cutFrom, int cutTo) {
        String rcode = string;
        if (!Utils.isEmpty((CharSequence)rcode)) {
            int lenCode = rcode.length();
            if (cutFrom >= 0 && cutTo >= 0 && cutFrom > lenCode) {
                rcode = null;
            } else if (cutFrom >= 0 && cutTo >= 0 && cutTo < cutFrom) {
                rcode = null;
            } else if (cutFrom < 0 && cutTo < 0 && cutFrom < -lenCode) {
                rcode = null;
            } else if (cutFrom < 0 && cutTo < 0 && cutFrom < cutTo) {
                rcode = null;
            } else {
                if (cutTo > lenCode) {
                    cutTo = lenCode;
                }
                if (cutTo < 0 && cutFrom == 0 && -cutTo > lenCode) {
                    cutTo = -lenCode;
                }
                if (cutTo < 0 && cutFrom < 0 && -cutTo > lenCode) {
                    cutTo = -lenCode;
                }
                if (cutFrom >= 0 && cutTo > 0) {
                    rcode = rcode.substring(cutFrom, cutTo);
                } else if (cutFrom < 0 && cutTo < 0) {
                    rcode = rcode.substring(rcode.length() + cutTo, lenCode + cutFrom);
                } else if (cutFrom == 0 && cutTo < 0) {
                    int intFrom = rcode.length() + cutTo;
                    rcode = rcode.substring(intFrom, lenCode);
                }
            }
        }
        return rcode;
    }

    private Object[] getOneRow(IRowMeta rowMeta, Object[] row) throws HopException {
        Object[] rowData = new Object[((StringCutData)this.data).outputRowMeta.size()];
        System.arraycopy(row, 0, rowData, 0, rowMeta.size());
        int length = ((StringCutMeta)this.meta).getFields().size();
        int j = 0;
        for (int i = 0; i < length; ++i) {
            String valueIn = this.getInputRowMeta().getString(row, ((StringCutData)this.data).inStreamNrs[i]);
            String value = this.cutString(valueIn, ((StringCutData)this.data).cutFrom[i], ((StringCutData)this.data).cutTo[i]);
            if (Utils.isEmpty((CharSequence)((StringCutData)this.data).outStreamNrs[i])) {
                rowData[((StringCutData)this.data).inStreamNrs[i]] = value;
                continue;
            }
            rowData[((StringCutData)this.data).inputFieldsNr + j] = value;
            ++j;
        }
        return rowData;
    }

    public boolean processRow() throws HopException {
        block10: {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                StringCutField scf;
                int i;
                this.first = false;
                ((StringCutData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((StringCutData)this.data).inputFieldsNr = ((StringCutData)this.data).outputRowMeta.size();
                ((StringCutMeta)this.meta).getFields(((StringCutData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((StringCutData)this.data).inStreamNrs = new int[((StringCutMeta)this.meta).getFields().size()];
                for (i = 0; i < ((StringCutMeta)this.meta).getFields().size(); ++i) {
                    scf = ((StringCutMeta)this.meta).getFields().get(i);
                    ((StringCutData)this.data).inStreamNrs[i] = this.getInputRowMeta().indexOfValue(scf.getFieldInStream());
                    if (((StringCutData)this.data).inStreamNrs[i] < 0) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"StringCut.Exception.FieldRequired", (String[])new String[]{scf.getFieldInStream()}));
                    }
                    if (this.getInputRowMeta().getValueMeta(((StringCutData)this.data).inStreamNrs[i]).getType() == 2) continue;
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"StringCut.Exception.FieldTypeNotString", (String[])new String[]{scf.getFieldInStream()}));
                }
                ((StringCutData)this.data).outStreamNrs = new String[((StringCutMeta)this.meta).getFields().size()];
                for (i = 0; i < ((StringCutMeta)this.meta).getFields().size(); ++i) {
                    scf = ((StringCutMeta)this.meta).getFields().get(i);
                    if (StringUtils.isEmpty((String)scf.getFieldOutStream())) continue;
                    ((StringCutData)this.data).outStreamNrs[i] = this.resolve(scf.getFieldOutStream());
                }
                ((StringCutData)this.data).cutFrom = new int[((StringCutMeta)this.meta).getFields().size()];
                ((StringCutData)this.data).cutTo = new int[((StringCutMeta)this.meta).getFields().size()];
                for (i = 0; i < ((StringCutMeta)this.meta).getFields().size(); ++i) {
                    scf = ((StringCutMeta)this.meta).getFields().get(i);
                    ((StringCutData)this.data).cutFrom[i] = Utils.isEmpty((CharSequence)this.resolve(scf.getCutFrom())) ? 0 : Const.toInt((String)this.resolve(scf.getCutFrom()), (int)0);
                    ((StringCutData)this.data).cutTo[i] = Utils.isEmpty((CharSequence)this.resolve(scf.getCutTo())) ? 0 : Const.toInt((String)this.resolve(scf.getCutTo()), (int)0);
                }
            }
            try {
                Object[] output = this.getOneRow(this.getInputRowMeta(), r);
                this.putRow(((StringCutData)this.data).outputRowMeta, output);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"StringCut.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"StringCut.Log.ErrorInTransform", (String[])new String[]{e.getMessage()}));
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block10;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "StringCut001");
            }
        }
        return true;
    }

    public boolean init() {
        boolean rCode = true;
        if (super.init()) {
            return rCode;
        }
        return false;
    }
}

