/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.debug.transform;

import java.util.HashMap;
import java.util.Map;
import org.apache.hop.core.action.GuiContextAction;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.debug.transform.TransformDebugLevel;
import org.apache.hop.debug.transform.TransformDebugLevelDialog;
import org.apache.hop.debug.util.DebugLevelUtil;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.context.HopGuiPipelineTransformContext;

@GuiPlugin
public class TransformDebugGuiPlugin {
    @GuiContextAction(id="pipeline-graph-transform-11001-clear-logging", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Delete, name="i18n::DebugTransform.ClearCustomLogging.Label", tooltip="i18n::DebugTransform.ClearCustomLogging.ToolTip", image="ui/images/debug.svg", category="Logging", categoryOrder="7")
    public void clearCustomTransformLogging(HopGuiPipelineTransformContext context) {
        PipelineMeta pipelineMeta = context.getPipelineMeta();
        TransformMeta transformMeta = context.getTransformMeta();
        Map attributesMap = pipelineMeta.getAttributesMap();
        Map debugGroupAttributesMap = (Map)attributesMap.get("debug_plugin");
        DebugLevelUtil.clearDebugLevel(debugGroupAttributesMap, transformMeta.getName());
        pipelineMeta.setChanged();
    }

    @GuiContextAction(id="pipeline-graph-transform-11000-config-logging", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Modify, name="i18n::DebugTransform.EditCustomLogging.Label", tooltip="i18n::DebugTransform.EditCustomLogging.ToolTip", image="ui/images/debug.svg", category="Logging", categoryOrder="7")
    public void applyCustomTransformLogging(HopGuiPipelineTransformContext context) {
        HopGui hopGui = HopGui.getInstance();
        try {
            TransformDebugLevel debugLevel;
            PipelineMeta pipelineMeta = context.getPipelineMeta();
            TransformMeta transformMeta = context.getTransformMeta();
            IVariables variables = context.getPipelineGraph().getVariables();
            Map attributesMap = pipelineMeta.getAttributesMap();
            HashMap<String, String> debugGroupAttributesMap = (HashMap<String, String>)attributesMap.get("debug_plugin");
            if (debugGroupAttributesMap == null) {
                debugGroupAttributesMap = new HashMap<String, String>();
                attributesMap.put("debug_plugin", debugGroupAttributesMap);
            }
            if ((debugLevel = DebugLevelUtil.getTransformDebugLevel(debugGroupAttributesMap, transformMeta.getName())) == null) {
                debugLevel = new TransformDebugLevel();
            }
            IRowMeta inputRowMeta = pipelineMeta.getPrevTransformFields(variables, transformMeta);
            TransformDebugLevelDialog dialog = new TransformDebugLevelDialog(hopGui.getShell(), debugLevel, inputRowMeta);
            if (dialog.open()) {
                DebugLevelUtil.storeTransformDebugLevel(debugGroupAttributesMap, transformMeta.getName(), debugLevel);
            }
            pipelineMeta.setChanged();
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), "Error", "Error changing transform log settings", e);
        }
    }
}

