/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.action;

import com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamMutation;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamRecord;
import com.google.cloud.bigtable.data.v2.models.CloseStream;
import com.google.cloud.bigtable.data.v2.models.Heartbeat;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.protobuf.ByteString;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ByteStringRangeHelper;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.TimestampConverter;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.estimator.ThroughputEstimator;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.PartitionRecord;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.restriction.StreamProgress;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.values.KV;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ChangeStreamAction {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ChangeStreamAction.class);
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;
    private final @UnknownKeyFor @NonNull @Initialized ThroughputEstimator<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ChangeStreamMutation>> throughputEstimator;

    public ChangeStreamAction(@UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics, @UnknownKeyFor @NonNull @Initialized ThroughputEstimator<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ChangeStreamMutation>> throughputEstimator) {
        this.metrics = metrics;
        this.throughputEstimator = throughputEstimator;
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation> run(@UnknownKeyFor @NonNull @Initialized PartitionRecord partitionRecord, @UnknownKeyFor @NonNull @Initialized ChangeStreamRecord record, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized StreamProgress, @UnknownKeyFor @NonNull @Initialized StreamProgress> tracker, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ByteString, @UnknownKeyFor @NonNull @Initialized ChangeStreamMutation>> receiver, @UnknownKeyFor @NonNull @Initialized ManualWatermarkEstimator<@UnknownKeyFor @NonNull @Initialized Instant> watermarkEstimator, @UnknownKeyFor @NonNull @Initialized boolean shouldDebug) {
        if (record instanceof Heartbeat) {
            Heartbeat heartbeat = (Heartbeat)record;
            Instant watermark = TimestampConverter.toJodaTime(heartbeat.getEstimatedLowWatermark());
            StreamProgress streamProgress = new StreamProgress(heartbeat.getChangeStreamContinuationToken(), watermark);
            watermarkEstimator.setWatermark(watermark);
            if (shouldDebug) {
                LOG.info("RCSP {}: Heartbeat partition: {} token: {} watermark: {}", new Object[]{ByteStringRangeHelper.formatByteStringRange(partitionRecord.getPartition()), ByteStringRangeHelper.formatByteStringRange(heartbeat.getChangeStreamContinuationToken().getPartition()), heartbeat.getChangeStreamContinuationToken().getToken(), heartbeat.getEstimatedLowWatermark()});
            }
            if (!tracker.tryClaim((Object)streamProgress)) {
                if (shouldDebug) {
                    LOG.info("RCSP {}: Checkpoint heart beat tracker", (Object)ByteStringRangeHelper.formatByteStringRange(partitionRecord.getPartition()));
                }
                return Optional.of(DoFn.ProcessContinuation.stop());
            }
            this.metrics.incHeartbeatCount();
        } else {
            if (record instanceof CloseStream) {
                CloseStream closeStream = (CloseStream)record;
                StreamProgress streamProgress = new StreamProgress(closeStream);
                if (shouldDebug) {
                    LOG.info("RCSP {}: CloseStream: {}", (Object)ByteStringRangeHelper.formatByteStringRange(partitionRecord.getPartition()), (Object)closeStream.getChangeStreamContinuationTokens().stream().map(c -> "{partition: " + ByteStringRangeHelper.formatByteStringRange(c.getPartition()) + " token: " + c.getToken() + "}").collect(Collectors.joining(", ", "[", "]")));
                }
                if (!tracker.tryClaim((Object)streamProgress)) {
                    if (shouldDebug) {
                        LOG.info("RCSP {}: Checkpoint close stream tracker", (Object)ByteStringRangeHelper.formatByteStringRange(partitionRecord.getPartition()));
                    }
                    return Optional.of(DoFn.ProcessContinuation.stop());
                }
                this.metrics.incClosestreamCount();
                return Optional.of(DoFn.ProcessContinuation.resume());
            }
            if (record instanceof ChangeStreamMutation) {
                ChangeStreamMutation changeStreamMutation = (ChangeStreamMutation)record;
                Instant watermark = TimestampConverter.toJodaTime(changeStreamMutation.getEstimatedLowWatermark());
                watermarkEstimator.setWatermark(watermark);
                ChangeStreamContinuationToken changeStreamContinuationToken = ChangeStreamContinuationToken.create((Range.ByteStringRange)Range.ByteStringRange.create((ByteString)((ByteString)partitionRecord.getPartition().getStart()), (ByteString)((ByteString)partitionRecord.getPartition().getEnd())), (String)changeStreamMutation.getToken());
                StreamProgress streamProgress = new StreamProgress(changeStreamContinuationToken, watermark);
                if (!tracker.tryClaim((Object)streamProgress)) {
                    if (shouldDebug) {
                        LOG.info("RCSP {}: Checkpoint data change tracker", (Object)ByteStringRangeHelper.formatByteStringRange(partitionRecord.getPartition()));
                    }
                    return Optional.of(DoFn.ProcessContinuation.stop());
                }
                if (changeStreamMutation.getType() == ChangeStreamMutation.MutationType.GARBAGE_COLLECTION) {
                    this.metrics.incChangeStreamMutationGcCounter();
                } else if (changeStreamMutation.getType() == ChangeStreamMutation.MutationType.USER) {
                    this.metrics.incChangeStreamMutationUserCounter();
                }
                Instant delay = TimestampConverter.toJodaTime(changeStreamMutation.getCommitTimestamp());
                this.metrics.updateProcessingDelayFromCommitTimestamp(Instant.now().getMillis() - delay.getMillis());
                KV outputRecord = KV.of((Object)changeStreamMutation.getRowKey(), (Object)changeStreamMutation);
                this.throughputEstimator.update(Instant.now(), (KV<ByteString, ChangeStreamMutation>)outputRecord);
                receiver.outputWithTimestamp((Object)outputRecord, Instant.EPOCH);
            } else {
                LOG.warn("RCSP {}: Invalid response type", (Object)ByteStringRangeHelper.formatByteStringRange(partitionRecord.getPartition()));
            }
        }
        return Optional.empty();
    }
}

